/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.util.Enumeration;
import java.util.Vector;
import taems.Interrelationship;
import taems.Node;
import taems.Task;
import utilities.Log;

class NodeFinderEnumeration
implements Enumeration {
    Vector matches = new Vector();
    Vector looked = new Vector();
    Node match;
    private boolean err = false;

    public NodeFinderEnumeration(Enumeration es, Node m) {
        this.match = m;
        while (es.hasMoreElements()) {
            Node s = (Node)es.nextElement();
            this.findMatches(s);
        }
    }

    public NodeFinderEnumeration(Node s, Node m) {
        this.match = m;
        this.findMatches(s);
    }

    public boolean hasMoreElements() {
        return !this.matches.isEmpty();
    }

    public Object nextElement() {
        Object o = this.matches.firstElement();
        this.matches.removeElement(o);
        return o;
    }

    private void findMatches(Node n) {
        if (n == null) {
            this.err = true;
            Log.getDefault().log("Warning: NodeFinderEnumeration.findMatches() called with null node", 1);
            return;
        }
        if (this.looked.contains(n)) {
            return;
        }
        this.looked.addElement(n);
        if (n.matches(this.match)) {
            this.matches.addElement(n);
        }
        Enumeration e = n.getOutInterrelationships();
        while (e.hasMoreElements()) {
            this.findMatches((Node)e.nextElement());
        }
        if (n instanceof Task) {
            e = ((Task)n).getSubtasks();
            while (e.hasMoreElements()) {
                this.findMatches((Node)e.nextElement());
            }
        } else if (n instanceof Interrelationship) {
            Node f = ((Interrelationship)n).getFrom();
            this.findMatches(f);
            Node t = ((Interrelationship)n).getTo();
            this.findMatches(t);
        }
        e = n.getInInterrelationships();
        while (e.hasMoreElements()) {
            this.findMatches((Node)e.nextElement());
        }
        if (this.err) {
            this.err = false;
            Log.getDefault().log("Source of last error may be node " + n.getLabel(), 1);
        }
    }
}

