/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import taems.Constraint;
import taems.DisablesInterrelationship;
import taems.EarliestStartTimePrecondition;
import taems.EnablesInterrelationship;
import taems.FacilitatesInterrelationship;
import taems.HindersInterrelationship;
import taems.Interrelationship;
import taems.Method;
import taems.PrecedencePrecondition;
import taems.Precondition;
import taems.Schedule;
import taems.ScheduleElement;
import taems.Task;
import taems.TaskBase;
import utilities.Distribution;
import utilities.Log;

public class MLCSchedule
extends Schedule
implements Serializable,
Cloneable {
    protected Hashtable index_methods = new Hashtable();
    protected Hashtable constraints;
    protected Vector schedules = new Vector();
    protected Vector mlc = new Vector();
    protected Log log = Log.getDefault();

    private Vector append(Vector v1, Vector v2) {
        Vector v = new Vector();
        Enumeration e1 = new Vector(0).elements();
        Enumeration e2 = new Vector(0).elements();
        if (v1 != null) {
            e1 = v1.elements();
        }
        while (e1.hasMoreElements()) {
            v.addElement(e1.nextElement());
        }
        if (v2 != null) {
            e2 = v2.elements();
        }
        while (e2.hasMoreElements()) {
            v.addElement(e2.nextElement());
        }
        return v;
    }

    public String stringifyMLC() {
        String print = new String();
        Enumeration e = this.mlc.elements();
        while (e.hasMoreElements()) {
            Schedule s = (Schedule)e.nextElement();
            print = print + this.stringifySchedule(s) + "\n";
        }
        return print;
    }

    public String toString() {
        return this.stringifyMLC();
    }

    public String stringifySchedules() {
        String print = new String();
        Enumeration e = this.schedules.elements();
        while (e.hasMoreElements()) {
            Schedule s = (Schedule)e.nextElement();
            print = print + this.stringifySchedule(s) + "\n";
        }
        return print;
    }

    public String stringifySchedule(Schedule s) {
        return s.stringify();
    }

    protected ScheduleElement delinearize(ScheduleElement se, int start) {
        if (!se.hasFinished()) {
            this.buildPreconditions(se, start);
            se.setFinishTime(null);
            se.setSchedule(null);
        }
        Method m = se.getMethod();
        this.index_methods.put(m, se);
        return se;
    }

    protected void subBuildPrecedencePC(Hashtable precedences, TaskBase tb) {
        Method m;
        ScheduleElement se;
        String className = tb.getClass().getName();
        if (className.equals("taems.Method") && (se = (ScheduleElement)this.index_methods.get(m = (Method)tb)) != null) {
            precedences.put(se, "0");
        }
        if (className.equals("taems.Task")) {
            Task t = (Task)tb;
            Enumeration e = t.getSubtasks();
            while (e.hasMoreElements()) {
                TaskBase new_tb = (TaskBase)e.nextElement();
                this.subBuildPrecedencePC(precedences, new_tb);
            }
        }
    }

    protected Vector findSequenceDependency(TaskBase tb) {
        Vector<TaskBase> dependence = new Vector<TaskBase>();
        Enumeration e = tb.getSupertasks();
        while (e.hasMoreElements()) {
            Task t = (Task)e.nextElement();
            String qaf = t.getQAF().getClass().getName();
            if (qaf.startsWith("taems.Seq")) {
                Enumeration e1 = t.getSubtasks();
                boolean precedence = true;
                while (precedence && e1.hasMoreElements()) {
                    TaskBase t1 = (TaskBase)e1.nextElement();
                    if (t1.getLabel().equals(tb.getLabel())) {
                        precedence = false;
                        continue;
                    }
                    if (t1 instanceof Method) {
                        dependence.addElement(t1);
                        continue;
                    }
                    Enumeration e2 = ((Task)t1).getAllSubtasks();
                    while (e2.hasMoreElements()) {
                        Object o = e2.nextElement();
                        if (!(o instanceof Method)) continue;
                        dependence.addElement((TaskBase)o);
                    }
                }
            }
            Vector v3 = this.findSequenceDependency(t);
            Enumeration e3 = v3.elements();
            while (e3.hasMoreElements()) {
                dependence.addElement((TaskBase)e3.nextElement());
            }
        }
        return dependence;
    }

    protected void buildPreconditions(ScheduleElement se, int start) {
        Method m = se.getMethod();
        Enumeration e1 = m.getAffectingInterrelationships();
        while (e1.hasMoreElements()) {
            Interrelationship ir = (Interrelationship)e1.nextElement();
            this.log.log("Looking at " + ir.getClass().getName(), 5);
            if (!(ir instanceof EnablesInterrelationship) && !(ir instanceof FacilitatesInterrelationship)) continue;
            Hashtable precedences = new Hashtable();
            this.subBuildPrecedencePC(precedences, (TaskBase)ir.getFrom());
            Enumeration e3 = precedences.keys();
            while (e3.hasMoreElements()) {
                ScheduleElement se2 = (ScheduleElement)e3.nextElement();
                PrecedencePrecondition pp1 = new PrecedencePrecondition(this, se2, ir);
                se.addPrecondition(pp1);
            }
        }
        e1 = this.findSequenceDependency(se.getMethod()).elements();
        while (e1.hasMoreElements()) {
            Method m2 = (Method)e1.nextElement();
            this.log.log("Found that : " + m2.getLabel(), 5);
            ScheduleElement se2 = (ScheduleElement)this.index_methods.get(m2);
            if (se2 == null) continue;
            PrecedencePrecondition pp1 = new PrecedencePrecondition(this, se2, true);
            se.addPrecondition(pp1);
        }
        Enumeration e2 = m.getAffectedInterrelationships();
        while (e2.hasMoreElements()) {
            boolean isValid = false;
            Interrelationship ir = (Interrelationship)e2.nextElement();
            this.log.log("Looking at " + ir.getClass().getName(), 5);
            if (!(ir instanceof DisablesInterrelationship) && !(ir instanceof HindersInterrelationship)) continue;
            Hashtable precedences = new Hashtable();
            this.subBuildPrecedencePC(precedences, (TaskBase)ir.getFrom());
            Enumeration e3 = precedences.keys();
            while (e3.hasMoreElements()) {
                ScheduleElement se3 = (ScheduleElement)e3.nextElement();
                PrecedencePrecondition pp3 = new PrecedencePrecondition(this, se3, ir);
                se.addPrecondition(pp3);
            }
        }
        if (se.getMethod().getEarliestStartTime() != Integer.MIN_VALUE) {
            EarliestStartTimePrecondition estp = new EarliestStartTimePrecondition(this, new Distribution((double)(se.getMethod().getEarliestStartTime() + start), 1.0));
            se.addPrecondition(estp);
        }
    }

    protected void insertInMLC(Vector MLC, ScheduleElement se, int start) {
        this.setupElement(se, start);
        Schedule s = se.getSchedule();
        if (!MLC.contains(s)) {
            MLC.addElement(s);
        }
    }

    protected boolean isLastOfSchedule(ScheduleElement se) {
        Schedule s = se.getSchedule();
        return s.getScheduleElementIndex(se) == s.size() - 1;
    }

    protected void setupElement(ScheduleElement se, int start) {
        if (se.getSchedule() != null) {
            return;
        }
        if (se.numPreconditions() == 0) {
            se.setStartTime(new Distribution(new Float(start), new Float(1.0f)));
            Vector<Distribution> v_end = new Vector<Distribution>();
            v_end.addElement(se.getStartTime());
            v_end.addElement(se.getDurationDistribution());
            Distribution d1 = Distribution.computeJointDistribution(v_end);
            d1.cluster(3);
            se.setFinishTime(d1);
            Schedule s = new Schedule();
            s.addScheduleElement(se);
        }
        if (se.numPreconditions() > 0) {
            Vector<Distribution> v_starttime = new Vector<Distribution>();
            Schedule selected = null;
            Enumeration e = se.getPreconditionsElement();
            while (e.hasMoreElements()) {
                ScheduleElement se2;
                Precondition p = (Precondition)e.nextElement();
                if (p instanceof PrecedencePrecondition && (se2 = p.getScheduleElement()) != null) {
                    if (se2.getSchedule() == null) {
                        this.setupElement(se2, start);
                    }
                    if (this.isLastOfSchedule(se2)) {
                        selected = se2.getSchedule();
                    }
                    v_starttime.addElement(se2.getFinishTime());
                }
                if (!(p instanceof EarliestStartTimePrecondition)) continue;
                v_starttime.addElement(((EarliestStartTimePrecondition)p).getEarliestStartDistribution());
            }
            if (selected == null) {
                selected = new Schedule();
            }
            Distribution d2 = Distribution.computeMaxJointDistribution(v_starttime);
            d2.cluster(3);
            se.setStartTime(d2);
            Vector<Distribution> v_end = new Vector<Distribution>();
            v_end.addElement(se.getStartTime());
            v_end.addElement(se.getDurationDistribution());
            Distribution d3 = Distribution.computeJointDistribution(v_end);
            d3.cluster(3);
            se.setFinishTime(d3);
            selected.addScheduleElement(se);
        }
    }

    public Vector createMLC(Vector linearSchedules, int start) {
        this.index_methods = new Hashtable();
        Vector MLC = new Vector();
        Vector<ScheduleElement> allSE = new Vector<ScheduleElement>();
        Enumeration e1 = linearSchedules.elements();
        while (e1.hasMoreElements()) {
            Schedule s = (Schedule)e1.nextElement();
            Enumeration linear = s.getElements();
            while (linear.hasMoreElements()) {
                ScheduleElement se = (ScheduleElement)linear.nextElement();
                allSE.addElement(this.delinearize(se, start));
            }
        }
        Enumeration e2 = allSE.elements();
        while (e2.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)e2.nextElement();
            this.insertInMLC(MLC, se, start);
        }
        return MLC;
    }

    public MLCSchedule(Vector se, Vector tqi, Vector ci, Distribution qd, Distribution dd, Distribution cd) {
        Schedule s = new Schedule(se, tqi, ci, qd, dd, cd);
        this.constraints = new Hashtable();
        this.addSchedule(s, 0, 0.5f);
    }

    public MLCSchedule(Schedule s, int t, float compact) {
        this.constraints = new Hashtable();
        this.addSchedule(s, t, compact);
    }

    public MLCSchedule() {
        this.constraints = new Hashtable();
    }

    protected void setSchedules(Vector v) {
        this.schedules = v;
    }

    protected void setMLC(Vector v) {
        this.mlc = v;
    }

    public void addConstraint(Object key, Constraint c) {
        if (c.check(0)) {
            this.constraints.put(key, c);
        } else {
            this.log.log("Can't add a constrainst that is not valid, dumb ass", 0);
        }
    }

    public Enumeration getConstraints() {
        return this.constraints.elements();
    }

    public void removeConstraint(Constraint c) {
        Enumeration e = this.constraints.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (this.constraints.get(key) != c) continue;
            this.constraints.remove(key);
        }
    }

    protected void calculateDuration() {
        Vector<Distribution> v_duration = new Vector<Distribution>();
        Vector<Distribution> s_duration = new Vector<Distribution>();
        float value = 0.0f;
        Enumeration e = this.mlc.elements();
        while (e.hasMoreElements()) {
            Schedule s = (Schedule)e.nextElement();
            ScheduleElement se = s.getScheduleElement(s.size() - 1);
            if (!se.hasFinished()) {
                v_duration.addElement(se.getFinishTime());
            }
            se = s.getScheduleElement(0);
            s_duration.addElement(se.getStartTime());
        }
        Distribution d = Distribution.computeMaxJointDistribution(v_duration);
        Distribution d1 = Distribution.computeMinJointDistribution(s_duration);
        Distribution d2 = Distribution.computeDifferenceJointDistribution(d, d1);
        d2.cluster(3);
        this.setDuration(d2);
    }

    public void calculateQualityCostRating() {
        Vector<Distribution> v_quality = new Vector<Distribution>();
        Vector<Distribution> v_cost = new Vector<Distribution>();
        double sum_rating = 0.0;
        Enumeration e = this.schedules.elements();
        while (e.hasMoreElements()) {
            Schedule s2 = (Schedule)e.nextElement();
            v_quality.addElement(s2.getQuality());
            v_cost.addElement(s2.getCost());
            sum_rating += s2.getRating();
        }
        Distribution d = Distribution.computeJointDistribution(v_quality);
        d.cluster(3);
        this.setQuality(d);
        d = Distribution.computeJointDistribution(v_cost);
        d.cluster(3);
        this.setCost(d);
        this.setRating(sum_rating / (double)this.schedules.size());
    }

    public void addScheduleSimple(Schedule s) {
        this.schedules.addElement(s);
    }

    public void addSchedule(Schedule s, int startingtime, float compacting) {
        boolean added = false;
        if (this.schedules.size() == 0) {
            this.quality = new Distribution(new Float(0.0), new Float(1.0));
            this.duration = new Distribution(new Float(0.0), new Float(1.0));
            this.cost = new Distribution(new Float(0.0), new Float(1.0));
            this.schedules.addElement(s);
            this.mlc = this.createMLC(this.schedules, startingtime);
            added = true;
        } else if (!this.schedules.contains(s)) {
            added = true;
            this.schedules.addElement(s);
            Enumeration e2 = s.getElements();
            while (e2.hasMoreElements()) {
                ScheduleElement se = (ScheduleElement)e2.nextElement();
                this.insertInMLC(this.mlc, this.delinearize(se, startingtime), startingtime);
            }
        }
        if (added) {
            this.compactSchedule(s, startingtime, compacting);
        }
        s.calculateDuration();
        this.calculateQualityCostRating();
        this.log.log("Mlc - Quality : " + this.quality.output(), 5);
        this.log.log("Mlc - Cost : " + this.cost.output(), 5);
        this.calculateDuration();
        this.log.log("Mlc - Duration : " + this.duration.output(), 5);
        if (this.getTaskQualityInfo() != null || s.getTaskQualityInfo() != null) {
            this.setTaskQualityInfo(this.append(this.getTaskQualityInfo(), s.getTaskQualityInfo()));
        }
        if (this.getCommitmentInfo() != null || s.getCommitmentInfo() != null) {
            this.setCommitmentInfo(this.append(this.getCommitmentInfo(), s.getCommitmentInfo()));
        }
        this.log.log("Mlc - Rating : " + this.rating, 5);
    }

    public void compactSchedule(Schedule s, int start, float probability) {
        ScheduleElement se;
        boolean compact = true;
        if (probability == -1.0f) {
            compact = false;
        } else if (probability > 1.0f) {
            probability = 1.0f;
        } else if (probability < 0.0f) {
            probability = 0.0f;
        }
        Enumeration e = s.getElements();
        while (e.hasMoreElements()) {
            se = (ScheduleElement)e.nextElement();
            if (se.getMethod().getComposedEarliestStartTime() != Integer.MIN_VALUE) {
                se.setEarliestStartTime(start + se.getMethod().getComposedEarliestStartTime());
                if (compact) {
                    se.setOptimalEarliestStartTime(start + se.getMethod().getComposedEarliestStartTime(), true);
                }
            }
            if (se.getMethod().getComposedDeadline() == Integer.MIN_VALUE) continue;
            se.getMethod().setActualLatestFinishTime(start + se.getMethod().getComposedDeadline());
            se.setLatestFinishTime(start + se.getMethod().getComposedDeadline());
            if (!compact) continue;
            se.setOptimalLatestFinishTime(start + se.getMethod().getComposedDeadline(), true);
        }
        if (compact) {
            e = s.getElements();
            while (e.hasMoreElements()) {
                int offset;
                se = (ScheduleElement)e.nextElement();
                int est = se.getOptimalEarliestStartTime();
                int lst = se.getOptimalLatestStartTime();
                if (est == Integer.MIN_VALUE) {
                    est = se.getStart();
                }
                if (lst == Integer.MIN_VALUE) {
                    lst = se.getStart();
                }
                if ((offset = Math.round((float)est + probability * (float)(lst - est)) - se.getStart()) == 0) continue;
                this.delayStartTime(se, offset);
            }
        }
    }

    public void removeSchedule(Schedule s) {
        this.schedules.removeElement(s);
        Enumeration e = s.getScheduleElements().elements();
        while (e.hasMoreElements()) {
            ScheduleElement se1;
            ScheduleElement se = (ScheduleElement)e.nextElement();
            Enumeration e1 = se.getDependanceTo().elements();
            while (e1.hasMoreElements()) {
                se1 = (ScheduleElement)e1.nextElement();
                if (s.getScheduleElements().contains(se1)) continue;
                Enumeration e2 = se1.getPreconditionsElement();
                while (e2.hasMoreElements()) {
                    Precondition pre = (Precondition)e2.nextElement();
                    if (!pre.dependentOf(se)) continue;
                    se1.removePrecondition(pre);
                    se1.removeDependingOf(se);
                    se.removeDependanceTo(se1);
                }
            }
            e1 = se.getDependingOf().elements();
            while (e1.hasMoreElements()) {
                se1 = (ScheduleElement)e1.nextElement();
                if (s.getScheduleElements().contains(se1)) continue;
                se1.removeDependanceTo(se);
            }
            se.getSchedule().removeScheduleElement(se);
        }
        Vector<Schedule> tmp = new Vector<Schedule>();
        Enumeration e4 = this.mlc.elements();
        while (e4.hasMoreElements()) {
            Schedule s4 = (Schedule)e4.nextElement();
            if (s4.size() != 0) continue;
            tmp.addElement(s4);
        }
        e4 = tmp.elements();
        while (e4.hasMoreElements()) {
            this.mlc.removeElement(e4.nextElement());
        }
    }

    public Enumeration getSchedules() {
        return this.schedules.elements();
    }

    public boolean contains(Schedule s) {
        return this.schedules.contains(s);
    }

    public int numberOfSchedules() {
        return this.schedules.size();
    }

    public Enumeration getElements() {
        return this.getScheduleElements().elements();
    }

    public void removeAllElements() {
        this.schedules.removeAllElements();
        this.schedules = new Vector();
        this.mlc.removeAllElements();
        this.mlc = new Vector();
        this.task_quality_info = null;
        this.commitment_info = null;
        this.quality = null;
        this.duration = null;
        this.cost = null;
    }

    public Vector getScheduleElements() {
        Vector sev = new Vector();
        if (this.mlc == null) {
            return new Vector(0);
        }
        Enumeration e1 = this.mlc.elements();
        while (e1.hasMoreElements()) {
            Schedule s = (Schedule)e1.nextElement();
            Enumeration e2 = s.getElements();
            while (e2.hasMoreElements()) {
                sev.addElement(e2.nextElement());
            }
        }
        return sev;
    }

    public ScheduleElement getScheduleElement(String l) {
        ScheduleElement se;
        block1: {
            Schedule s;
            se = super.getScheduleElement(l);
            if (se != null) break block1;
            Enumeration list = this.getSchedules();
            while (list.hasMoreElements() && (se = (s = (Schedule)list.nextElement()).getScheduleElement(l)) == null) {
            }
        }
        return se;
    }

    public void setScheduleElements(Vector v) {
        Schedule s = new Schedule();
        s.setScheduleElements(v);
        this.addSchedule(s, 0, 0.5f);
    }

    public void insertScheduleElement(ScheduleElement e, int i) {
        this.addScheduleElement(e);
    }

    public void addScheduleElement(ScheduleElement e) {
        Schedule s = new Schedule();
        Vector<ScheduleElement> v = new Vector<ScheduleElement>();
        v.addElement(e);
        s.setScheduleElements(v);
        this.addSchedule(s, 0, 0.5f);
    }

    public void removeScheduleElement(ScheduleElement e) {
        Schedule s = e.getSchedule();
        s.removeScheduleElement(e);
    }

    public boolean checkPreconditions(ScheduleElement target, int time) {
        return target.checkPreconditions(time);
    }

    public boolean isCompleted() {
        boolean answer = true;
        Enumeration e = this.schedules.elements();
        while (e.hasMoreElements() && answer) {
            Schedule s = (Schedule)e.nextElement();
            answer = answer && s.isCompleted();
        }
        return answer;
    }

    public Enumeration getNextTasks(int time) {
        Vector<ScheduleElement> result = new Vector<ScheduleElement>();
        boolean foundNewElements = true;
        Vector listElements = this.getScheduleElements();
        while (foundNewElements) {
            foundNewElements = false;
            for (int i = 0; i < listElements.size(); ++i) {
                ScheduleElement se = (ScheduleElement)listElements.elementAt(i);
                if (se.hasStarted() || time < se.getStart() || !this.checkPreconditions(se, time)) continue;
                listElements.removeElementAt(i);
                result.addElement(se);
                foundNewElements = true;
            }
        }
        return this.sortElements(result);
    }

    public ScheduleElement getScheduleElement(int i) {
        return null;
    }

    public int getScheduleElementIndex(ScheduleElement se) {
        return -1;
    }

    public int size() {
        if (this.schedules != null) {
            return this.getScheduleElements().size();
        }
        return 0;
    }

    public void setStartTime(int time) {
        Enumeration list = this.mlc.elements();
        int offset = time - this.getStartTime();
        if (offset > 0) {
            while (list.hasMoreElements()) {
                Schedule s = (Schedule)list.nextElement();
                s.setStartTime(s.getStartTime() + offset);
            }
        }
    }

    public Vector delayFinishTime(ScheduleElement schelement, int delay) {
        Vector v = this.delayTime(schelement, delay, false);
        schelement.setAttribute("DurationDistribution", schelement.getDurationDistribution());
        schelement.setDurationDistribution(schelement.getDurationDistribution().applyOffset(delay));
        return v;
    }

    public Vector delayStartTime(ScheduleElement schelement, int delay) {
        return this.delayTime(schelement, delay, true);
    }

    protected Vector delayTime(ScheduleElement schelement, int delay, boolean flag) {
        if (flag) {
            if (!schelement.hasAttribute("StartTime")) {
                schelement.setAttribute("StartTime", schelement.getStartTime());
            }
            schelement.setStartTime(schelement.getStartTime().applyOffset(delay));
        }
        if (!schelement.hasAttribute("FinishTime")) {
            schelement.setAttribute("FinishTime", schelement.getFinishTime());
        }
        schelement.setFinishTime(schelement.getFinishTime().applyOffset(delay));
        int finish = (int)schelement.getFinishTime().calculateMax();
        Vector<ScheduleElement> tmp = new Vector<ScheduleElement>();
        tmp.addElement(schelement);
        ScheduleElement se = schelement;
        Enumeration list = se.getDependanceTo().elements();
        while (list.hasMoreElements()) {
            ScheduleElement s = (ScheduleElement)list.nextElement();
            int start = (int)s.getStartTime().calculateMin();
            Vector tv = new Vector();
            if (finish - start > 0) {
                tv = this.delayStartTime(s, finish - start);
            }
            if (!tv.contains(s)) {
                tv.addElement(s);
            }
            Enumeration e1 = tv.elements();
            while (e1.hasMoreElements()) {
                ScheduleElement se2 = (ScheduleElement)e1.nextElement();
                if (tmp.contains(se2)) continue;
                tmp.addElement(se2);
            }
        }
        if (flag) {
            this.setDuration(this.getDuration().applyOffset(delay));
        }
        return tmp;
    }

    public int getStartTime() {
        int earliest = Integer.MAX_VALUE;
        if (this.start == null) {
            if (this.size() > 0) {
                Enumeration e = this.mlc.elements();
                while (e.hasMoreElements()) {
                    Schedule s = (Schedule)e.nextElement();
                    ScheduleElement se = (ScheduleElement)s.getScheduleElements().firstElement();
                    if (se.getStart() >= earliest) continue;
                    earliest = se.getStart();
                }
                return earliest;
            }
            return -1;
        }
        return (int)this.start.calculateMin();
    }

    public void deleteHistory() {
        Enumeration e = this.getElements();
        while (e.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)e.nextElement();
            this.deleteHistory(se);
        }
    }

    public int getFinishTime() {
        int latest = Integer.MIN_VALUE;
        if (this.finish == null) {
            if (this.size() > 0) {
                Enumeration e = this.mlc.elements();
                while (e.hasMoreElements()) {
                    Schedule s = (Schedule)e.nextElement();
                    ScheduleElement se = (ScheduleElement)s.getScheduleElements().lastElement();
                    if (se.getFinish() <= latest) continue;
                    latest = se.getFinish();
                }
                return latest;
            }
            return -1;
        }
        return (int)this.finish.calculateMax();
    }

    public Distribution getFinish() {
        return this.finish;
    }

    public int getTotalDuration() {
        if (this.duration == null) {
            return this.getFinishTime() - this.getStartTime();
        }
        return (int)this.getDuration().calculateMax();
    }

    public int getMaxFinishTime() {
        int max = 0;
        Enumeration e = this.getSchedules();
        while (e.hasMoreElements()) {
            Schedule s = (Schedule)e.nextElement();
            if (max >= s.getFinishTime()) continue;
            max = s.getFinishTime();
        }
        return max;
    }

    public void fixConditions(Schedule query) {
        if (query == null) {
            query = this;
        }
        super.fixConditions(query);
        Enumeration e = this.getSchedules();
        while (e.hasMoreElements()) {
            Schedule s = (Schedule)e.nextElement();
            s.fixConditions(query);
        }
    }

    public Object clone() {
        MLCSchedule cloned = new MLCSchedule();
        Enumeration e = this.schedules.elements();
        Vector<Object> v = new Vector<Object>();
        while (e.hasMoreElements()) {
            v.addElement(((Schedule)e.nextElement()).clone());
        }
        cloned.setSchedules(v);
        e = cloned.getSchedules();
        v = new Vector();
        while (e.hasMoreElements()) {
            Schedule s = (Schedule)e.nextElement();
            Enumeration e1 = s.getElements();
            while (e1.hasMoreElements()) {
                v.addElement(e1.nextElement());
            }
        }
        e = v.elements();
        while (e.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)e.nextElement();
            se.retargetVirtual(cloned, v);
        }
        Vector<Schedule> newmlc = new Vector<Schedule>();
        e = this.mlc.elements();
        while (e.hasMoreElements()) {
            Schedule s = (Schedule)e.nextElement();
            Schedule clonedS = (Schedule)s.cloneWithVirtual();
            clonedS.retargetVirtual(v);
            newmlc.addElement(clonedS);
        }
        cloned.setMLC(newmlc);
        if (this.task_quality_info != null) {
            cloned.setTaskQualityInfo((Vector)this.task_quality_info.clone());
        }
        if (this.commitment_info != null) {
            cloned.setCommitmentInfo((Vector)this.commitment_info.clone());
        }
        if (this.getQuality() != null) {
            cloned.setQuality((Distribution)this.getQuality().clone());
        }
        if (this.getDuration() != null) {
            cloned.setDuration((Distribution)this.getDuration().clone());
        }
        if (this.getCost() != null) {
            cloned.setCost((Distribution)this.getCost().clone());
        }
        cloned.setRating(this.getRating());
        if (this.getStart() != null) {
            cloned.setStart((Distribution)this.getStart().clone());
        }
        if (this.getFinish() != null) {
            cloned.setFinish((Distribution)this.getFinish().clone());
        }
        cloned.display = this.display;
        return cloned;
    }

    public String toTTaems(float v) {
        Enumeration e;
        StringBuffer sb = new StringBuffer("(spec_mlc_schedule\n");
        sb.append("; Schedule contains " + this.schedules.size() + " schedule(s)\n");
        if (this.schedules != null) {
            sb.append("   (schedules\n");
            e = this.getSchedules();
            while (e.hasMoreElements()) {
                sb.append(((Schedule)e.nextElement()).toTTaems(v));
            }
            sb.append("   )\n");
        }
        if (this.schedule_elements != null) {
            sb.append("; Schedule contains " + this.schedule_elements.size() + " schedule elements(s)\n");
            sb.append("   (schedule_elements\n");
            e = this.getElements();
            while (e.hasMoreElements()) {
                sb.append(((ScheduleElement)e.nextElement()).toTTaems(v));
            }
            sb.append("   )\n");
        }
        if (this.task_quality_info != null) {
            sb.append("   (task_quality_infos ");
            e = this.task_quality_info.elements();
            while (e.hasMoreElements()) {
                sb.append(e.nextElement().toString() + " ");
            }
            sb.append(")\n");
        }
        if (this.commitment_info != null) {
            sb.append("   (commitment_info " + this.commitment_info.toString() + ")\n");
        }
        if (this.quality != null) {
            sb.append("   (quality_distribution " + this.quality.output() + ")\n");
        }
        if (this.duration != null) {
            sb.append("   (duration_distribution " + this.duration.output() + ")\n");
        }
        if (this.cost != null) {
            sb.append("   (cost_distribution " + this.cost.output() + ")\n");
        }
        if (this.rating != Double.NEGATIVE_INFINITY) {
            sb.append("   (rating " + this.rating + ")\n");
        }
        sb.append(")\n");
        return sb.toString();
    }
}

