/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import taems.Agent;
import taems.Node;
import taems.TaskBase;
import utilities.Distribution;

public class Commitment
implements Serializable,
Cloneable {
    public static final int WHATIF = -1;
    public static final int GIVEN = 0;
    public static final int HARD = 1;
    public static final String DO = "do";
    public static final String DONT = "dont";
    public static final String DEADLINE = "deadline";
    public static final String EST = "earliest_start_time";
    public static final String EST_DL_DO = "est_and_dl_and_do";
    public static final String SPECIAL = "special";
    public static final String EXISTING = "existing";
    public static final String PROPOSED = "proposed";
    protected String label = null;
    protected Agent from_agent = null;
    protected Agent to_agent = null;
    protected Vector tasks = new Vector(1);
    protected String type;
    protected int importance = 0;
    protected float min_quality = 0.0f;
    protected int earliest_start_time = -1;
    protected int deadline = -1;
    protected int time_satisfied = -1;
    protected int dont_interval_start = -1;
    protected int dont_interval_end = -1;
    protected Distribution quality = null;
    protected Distribution time = null;
    protected boolean nonlocal = false;
    protected Hashtable attributes = new Hashtable();

    public Commitment() {
    }

    public Commitment(String l, String ty, Agent fa, Agent ta, Vector tsk, int imp, float minq, int est, int dl, int sat) {
        this.label = l;
        this.type = ty;
        this.from_agent = fa;
        this.to_agent = ta;
        this.tasks = tsk;
        this.importance = imp;
        this.min_quality = minq;
        this.earliest_start_time = est;
        this.deadline = dl;
        this.time_satisfied = sat;
        this.dont_interval_start = -1;
        this.dont_interval_end = -1;
    }

    public Commitment(String l, Agent fa, Agent ta, TaskBase tsk, int imp, int ds, int de) {
        this(l, DONT, fa, ta, new Vector(), imp, 0.0f, -1, -1, -1);
        this.tasks.addElement(tsk);
        this.dont_interval_start = ds;
        this.dont_interval_end = de;
    }

    public Commitment(String l, Agent fa, Agent ta, Vector tsk, Distribution q, Distribution t) {
        this(l, null, fa, ta, tsk, 0, 0.0f, -1, -1, -1);
        this.quality = q;
        this.time = t;
        this.nonlocal = true;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String l) {
        this.label = l;
    }

    public Agent getFromAgent() {
        return this.from_agent;
    }

    public void setFromAgent(Agent a) {
        this.from_agent = a;
    }

    public Agent getToAgent() {
        return this.to_agent;
    }

    public void setToAgent(Agent a) {
        this.to_agent = a;
    }

    public TaskBase getTask() {
        if (this.tasks != null && this.tasks.size() > 0) {
            return (TaskBase)this.tasks.firstElement();
        }
        return null;
    }

    public void setTask(TaskBase t) {
        this.tasks = new Vector();
        this.tasks.addElement(t);
    }

    public Enumeration getTasks() {
        if (this.tasks != null) {
            return this.tasks.elements();
        }
        return new Vector().elements();
    }

    public Vector getTaskVector() {
        return this.tasks;
    }

    public void setTaskVector(Vector v) {
        this.tasks = v;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String t) {
        this.type = t;
    }

    public int getImportance() {
        return this.importance;
    }

    public void setImportance(int i) {
        this.importance = i;
    }

    public float getMinimumQuality() {
        return this.min_quality;
    }

    public void setMinimumQuality(float m) {
        this.min_quality = m;
    }

    public int getEarliestStartTime() {
        return this.earliest_start_time;
    }

    public void setEarliestStartTime(int e) {
        this.earliest_start_time = e;
    }

    public int getDeadline() {
        return this.deadline;
    }

    public void setDeadline(int d) {
        this.deadline = d;
    }

    public int getDontIntervalStart() {
        return this.dont_interval_start;
    }

    public void setDontIntervalStart(int d) {
        this.dont_interval_start = d;
    }

    public int getDontIntervalEnd() {
        return this.dont_interval_end;
    }

    public void setDontIntervalEnd(int d) {
        this.dont_interval_end = d;
    }

    public int getTimeSatisfied() {
        return this.time_satisfied;
    }

    public void setTimeSatisfied(int t) {
        this.time_satisfied = t;
    }

    public Distribution getQualityDistribution() {
        return this.quality;
    }

    public void setQualityDistribution(Distribution d) {
        this.quality = d;
    }

    public Distribution getTimeDistribution() {
        return this.time;
    }

    public void setTimeDistribution(Distribution d) {
        this.time = d;
    }

    public boolean isNonLocal() {
        return this.getNonLocal();
    }

    public boolean getNonLocal() {
        return this.nonlocal;
    }

    public void setNonLocal(boolean n) {
        this.nonlocal = n;
    }

    public void setCostDistribution(Distribution c) {
        this.setAttribute("cost_distribution", c);
    }

    public Distribution getCostDistribution() {
        return (Distribution)this.getAttribute("cost_distribution");
    }

    public void setResource(String r) {
        this.setAttribute("Resource", r);
    }

    public String getResource() {
        return (String)this.getAttribute("Resource");
    }

    public void setQuantity(float f) {
        this.setAttribute("Quantity", new Float(f));
    }

    public float getQuantity() {
        Float f = (Float)this.getAttribute("Quantity");
        return f != null ? f.floatValue() : Float.NEGATIVE_INFINITY;
    }

    public void setID(long l) {
        this.setAttribute("CoordinationID", new Long(l));
    }

    public long getID() {
        Long l = (Long)this.getAttribute("CoordinationID");
        return l != null ? l : Long.MIN_VALUE;
    }

    public void setExistingOrProposed(String ep) {
        this.setAttribute("existing_or_proposed", ep);
    }

    public String getExistingOrProposed() {
        return (String)this.getAttribute("existing_or_proposed");
    }

    public void setQualityForCommitmentSatisfaction(Distribution d) {
        this.setAttribute("quality_for_commitment_satisfaction", d);
    }

    public Distribution getQualityForCommitmentSatisfaction() {
        return (Distribution)this.getAttribute("quality_for_commitment_satisfaction");
    }

    public boolean isNormalType() {
        if (this.getType() == null) {
            return false;
        }
        return this.getType().equals(DO) || this.getType().equals(DONT) || this.getType().equals(DEADLINE) || this.getType().equals(EST) || this.getType().equals(EST_DL_DO);
    }

    public boolean isSpecialType() {
        if (this.getType() == null) {
            return true;
        }
        return this.getType().equals(SPECIAL) || !this.isNormalType();
    }

    public Object getAttribute(Object k) {
        return this.attributes.get(k.toString());
    }

    public void setAttribute(Object k, Object d) {
        if (d == null) {
            this.removeAttribute(k);
        } else {
            this.attributes.put(k.toString(), d);
        }
    }

    public void removeAttribute(Object k) {
        this.attributes.remove(k.toString());
    }

    public Enumeration getAttributes() {
        return this.attributes.keys();
    }

    public boolean hasAttribute(Object k) {
        return this.attributes.containsKey(k.toString());
    }

    protected Hashtable getAttributesTable() {
        return this.attributes;
    }

    public boolean containsInterval(int start, int end) {
        return this.dont_interval_start <= start && end <= this.dont_interval_end;
    }

    public Object clone() {
        Commitment cloned = new Commitment();
        if (this.getLabel() != null) {
            cloned.setLabel(new String(this.getLabel()));
        }
        if (this.getFromAgent() != null) {
            cloned.setFromAgent((Agent)this.getFromAgent().clone());
        }
        if (this.getToAgent() != null) {
            cloned.setToAgent((Agent)this.getToAgent().clone());
        }
        if (this.getTaskVector() != null) {
            cloned.setTaskVector((Vector)this.tasks.clone());
        }
        if (this.getType() != null) {
            cloned.setType(this.getType());
        }
        cloned.setImportance(this.getImportance());
        cloned.setMinimumQuality(this.getMinimumQuality());
        cloned.setEarliestStartTime(this.getEarliestStartTime());
        cloned.setDeadline(this.getDeadline());
        cloned.setTimeSatisfied(this.getTimeSatisfied());
        cloned.setDontIntervalStart(this.getDontIntervalStart());
        cloned.setDontIntervalEnd(this.getDontIntervalEnd());
        if (this.getQualityDistribution() != null) {
            cloned.setQualityDistribution((Distribution)this.getQualityDistribution().clone());
        }
        if (this.getTimeDistribution() != null) {
            cloned.setTimeDistribution((Distribution)this.getTimeDistribution().clone());
        }
        if (this.getCostDistribution() != null) {
            cloned.setCostDistribution((Distribution)this.getCostDistribution().clone());
        }
        cloned.setNonLocal(this.getNonLocal());
        if (this.attributes != null) {
            cloned.attributes = (Hashtable)this.attributes.clone();
        }
        return cloned;
    }

    public boolean matches(Commitment c) {
        if (!Node.matches(c.getLabel(), this.getLabel())) {
            return false;
        }
        if (!Node.matches(c.getFromAgent(), this.getFromAgent())) {
            return false;
        }
        if (!Node.matches(c.getToAgent(), this.getToAgent())) {
            return false;
        }
        if (!Node.matches(c.getType(), this.getType())) {
            return false;
        }
        Enumeration e1 = c.getTasks();
        while (e1.hasMoreElements()) {
            TaskBase ct = (TaskBase)e1.nextElement();
            boolean found = false;
            Enumeration e2 = this.getTasks();
            while (e2.hasMoreElements()) {
                TaskBase mt = (TaskBase)e2.nextElement();
                if (!ct.matches(mt)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        if (!Node.matches(c.getImportance(), this.getImportance())) {
            return false;
        }
        if (!Node.matches(c.getMinimumQuality(), this.getMinimumQuality())) {
            return false;
        }
        if (!Node.matches(c.getEarliestStartTime(), this.getEarliestStartTime())) {
            return false;
        }
        if (!Node.matches(c.getDeadline(), this.getDeadline())) {
            return false;
        }
        if (!Node.matches(c.getTimeSatisfied(), this.getTimeSatisfied())) {
            return false;
        }
        if (!Node.matches(c.getCostDistribution(), this.getCostDistribution())) {
            return false;
        }
        if (!Node.matches(c.getResource(), this.getResource())) {
            return false;
        }
        if (!Node.matches(c.getQuantity(), this.getQuantity())) {
            return false;
        }
        if (!Node.matches(c.getID(), this.getID())) {
            return false;
        }
        if (!Node.matches(c.getDontIntervalStart(), this.getDontIntervalStart())) {
            return false;
        }
        if (!Node.matches(c.getDontIntervalEnd(), this.getDontIntervalEnd())) {
            return false;
        }
        if (!Node.matches(c.getQualityDistribution(), this.getQualityDistribution())) {
            return false;
        }
        return Node.matches(c.getTimeDistribution(), this.getTimeDistribution());
    }

    public String toTTaems(float v) {
        StringBuffer sb = new StringBuffer("");
        if (v >= 1.1f) {
            sb.append("(spec_commitment\n");
            sb.append(Node.attributesToString(this.attributes, v));
            if (this.getLabel() != null) {
                sb.append("   (label " + this.getLabel() + ")\n");
            }
            if (this.getType() != null) {
                sb.append("   (type " + this.getType() + ")\n");
            }
            if (this.getFromAgent() != null) {
                sb.append("   (from_agent " + this.getFromAgent().getLabel() + ")\n");
            }
            if (this.getToAgent() != null) {
                sb.append("   (to_agent " + this.getToAgent().getLabel() + ")\n");
            }
            sb.append("   (task");
            Enumeration e = this.getTasks();
            String notes = "\n";
            while (e.hasMoreElements()) {
                TaskBase t = (TaskBase)e.nextElement();
                sb.append(" " + t.getLabel());
                if (!t.isVirtual()) continue;
                notes = notes + ";  ** Note: node " + t.getLabel() + " is virtual.\n";
            }
            sb.append(")" + notes);
            if (this.isNonLocal()) {
                if (this.getQualityDistribution() != null) {
                    sb.append("   (quality_distribution " + this.getQualityDistribution().output() + ")\n");
                }
                if (this.getTimeDistribution() != null) {
                    sb.append("   (time_distribution " + this.getTimeDistribution().output() + ")\n");
                }
                sb.append("   (nonlocal)\n");
            } else {
                if (this.getQualityDistribution() != null) {
                    sb.append(";   (quality_distribution " + this.getQualityDistribution().output() + ")\n");
                }
                if (this.getTimeDistribution() != null) {
                    sb.append(";   (time_distribution " + this.getTimeDistribution().output() + ")\n");
                }
                sb.append("   (importance " + this.getImportance() + ")\n");
                sb.append("   (minimum_quality " + this.getMinimumQuality() + ")\n");
                sb.append("   (earliest_start_time " + this.getEarliestStartTime() + ")\n");
                sb.append("   (deadline " + this.getDeadline() + ")\n");
                if (this.getType() != null && this.getType().equalsIgnoreCase(DONT)) {
                    sb.append("   (dont_interval_start " + this.getDontIntervalStart() + ")\n");
                    sb.append("   (dont_interval_end " + this.getDontIntervalEnd() + ")\n");
                }
                sb.append("   (time_satisfied " + this.getTimeSatisfied() + ")\n");
            }
            sb.append(")\n");
        } else if (!this.isNonLocal()) {
            sb.append("(spec_commitment\n");
            if (v >= 1.01f) {
                sb.append(Node.attributesToString(this.attributes, v));
            }
            sb.append("   (label " + this.getLabel() + ")\n");
            sb.append("   (type " + this.getType() + ")\n");
            if (this.getFromAgent() != null) {
                sb.append("   (agent " + this.getFromAgent().getLabel() + ")\n");
            }
            sb.append("   (task");
            Enumeration e = this.getTasks();
            String notes = "\n";
            while (e.hasMoreElements()) {
                TaskBase t = (TaskBase)e.nextElement();
                sb.append(" " + t.getLabel());
                if (!t.isVirtual()) continue;
                notes = notes + ";  ** Note: node " + t.getLabel() + " is virtual.\n";
            }
            sb.append(")" + notes);
            sb.append("   (importance " + this.getImportance() + ")\n");
            sb.append("   (minimum_quality " + this.getMinimumQuality() + ")\n");
            sb.append("   (earliest_start_time " + this.getEarliestStartTime() + ")\n");
            sb.append("   (deadline " + this.getDeadline() + ")\n");
            if (this.getType() != null && this.getType().equalsIgnoreCase(DONT)) {
                sb.append("   (dont_interval_start " + this.getDontIntervalStart() + ")\n");
                sb.append("   (dont_interval_end " + this.getDontIntervalEnd() + ")\n");
            }
            sb.append("   (time_satisfied " + this.getTimeSatisfied() + ")\n");
            sb.append(")\n");
        } else {
            sb.append("(spec_nonlocal_commitment\n");
            if (v >= 1.01f) {
                sb.append(Node.attributesToString(this.attributes, v));
            }
            sb.append("   (label " + this.getLabel() + ")\n");
            sb.append("   (task");
            Enumeration e = this.getTasks();
            String notes = "\n";
            while (e.hasMoreElements()) {
                TaskBase t = (TaskBase)e.nextElement();
                sb.append(" " + t.getLabel());
                if (!t.isVirtual()) continue;
                notes = notes + ";  ** Note: node " + t.getLabel() + " is virtual.\n";
            }
            sb.append(")" + notes);
            if (this.getFromAgent() != null) {
                sb.append("   (from_agent " + this.getFromAgent().getLabel() + ")\n");
            }
            if (this.getToAgent() != null) {
                sb.append("   (to_agent " + this.getToAgent().getLabel() + ")\n");
            }
            if (this.getQualityDistribution() != null) {
                sb.append("   (quality_distribution " + this.getQualityDistribution().output() + ")\n");
            }
            if (this.getTimeDistribution() != null) {
                sb.append("   (time_distribution " + this.getTimeDistribution().output() + ")\n");
            }
            sb.append(")\n");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toTTaems(1.1f);
    }
}

