/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import taems.Node;

public class Agent
implements Serializable,
Cloneable {
    protected String label = "";
    protected Hashtable attributes = new Hashtable();

    public Agent(String l) {
        this.label = l;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String l) {
        this.label = l;
    }

    public Object getAttribute(Object k) {
        return this.attributes.get(k.toString());
    }

    public void setAttribute(Object k, Object d) {
        if (d == null) {
            this.removeAttribute(k);
        } else {
            this.attributes.put(k.toString(), d);
        }
    }

    public void removeAttribute(Object k) {
        this.attributes.remove(k.toString());
    }

    public Enumeration getAttributes() {
        return this.attributes.keys();
    }

    public boolean hasAttribute(Object k) {
        return this.attributes.containsKey(k.toString());
    }

    protected Hashtable getAttributesTable() {
        return this.attributes;
    }

    public boolean matches(Agent a) {
        return a == null || Node.matches(a.getLabel(), this.getLabel());
    }

    public Object clone() {
        Agent cloned = null;
        try {
            cloned = (Agent)super.clone();
        }
        catch (Exception e) {
            System.out.println("Clone Error: " + e);
        }
        if (this.attributes != null) {
            cloned.attributes = (Hashtable)this.attributes.clone();
        }
        if (this.label != null) {
            cloned.setLabel(new String(this.label));
        } else {
            cloned.setLabel(null);
        }
        return cloned;
    }

    public void copy(Agent a) {
        if (this.label != null) {
            a.setLabel(new String(this.label));
        } else {
            a.setLabel("");
        }
        if (this.attributes != null) {
            a.attributes = (Hashtable)this.attributes.clone();
        }
    }

    public String toTTaems(float v) {
        StringBuffer sb = new StringBuffer("");
        sb.append("(spec_agent\n");
        sb.append(Node.attributesToString(this.attributes, v));
        sb.append("  (label " + this.getLabel() + ")\n");
        sb.append(")\n");
        return sb.toString();
    }

    public String toString() {
        return this.toTTaems(1.1f);
    }
}

