/*
 * Decompiled with CFR 0.152.
 */
package utilities.cfg;

import java.util.Hashtable;
import java.util.Iterator;
import utilities.SortedHashtableIterator;
import utilities.cfg.CfgItem;

public class CfgSection {
    Hashtable items = new Hashtable();

    public void addItem(CfgItem item) {
        if (item.getName() == null || item.getValue() == null || item.getName().equals("")) {
            return;
        }
        if (this.items.containsKey(item.getName())) {
            this.items.remove(item.getName());
        }
        this.items.put(item.getName(), item);
    }

    public CfgItem getItem(String name) {
        return (CfgItem)this.items.get(name.toLowerCase());
    }

    public boolean contains(String name) {
        return this.items.containsKey(name.toLowerCase());
    }

    public void removeItem(String name) {
        if (this.contains(name)) {
            this.items.remove(name.toLowerCase());
        }
    }

    public Iterator getItems() {
        return new SortedHashtableIterator(this.items);
    }

    protected String indent(int level, String s) {
        if (level == 0) {
            return s + "\n";
        }
        StringBuffer b = new StringBuffer();
        while (level-- > 0) {
            b.append("    ");
        }
        b.append(s);
        b.append("\n");
        return b.toString();
    }

    public String toString() {
        StringBuffer b = new StringBuffer("{\n");
        this.toStringBuffer(b, 0);
        return b.toString();
    }

    protected void toStringBuffer(StringBuffer b, int level) {
        b.append(this.indent(level, "{"));
        Iterator i = this.getItems();
        while (i.hasNext()) {
            ((CfgItem)i.next()).toStringBuffer(b, level + 1);
        }
        b.append(this.indent(level, "}"));
    }
}

