/*
 * Decompiled with CFR 0.152.
 */
package utilities.cfg;

import java.awt.Point;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import utilities.cfg.CfgFileParser;
import utilities.cfg.CfgItem;
import utilities.cfg.CfgSection;
import utilities.cfg.ConfiguredObject;

public class CfgManager {
    CfgItem mainblock;
    String filename;
    Hashtable configured_objects = new Hashtable();
    Hashtable configured_objects_reverse = new Hashtable();
    static Hashtable manager_mappings = new Hashtable();
    boolean unspace_keys = false;

    public static void setManager(ConfiguredObject o, CfgManager m) {
        if (o == null || m == null) {
            return;
        }
        if (manager_mappings.containsKey(o)) {
            manager_mappings.remove(o);
        }
        manager_mappings.put(o, m);
    }

    public static void clearManager(ConfiguredObject o) {
        if (manager_mappings.containsKey(o)) {
            manager_mappings.remove(o);
        }
    }

    public static CfgManager getManager(ConfiguredObject o) {
        if (manager_mappings.containsKey(o)) {
            return (CfgManager)manager_mappings.get(o);
        }
        return null;
    }

    public CfgManager(CfgItem main, String fname) {
        this.mainblock = main == null || !(main.getValue() instanceof CfgSection) ? new CfgItem("main", new CfgSection()) : main;
        this.filename = fname == null ? "main.cfg" : fname;
    }

    public CfgManager() {
        this(null, null);
    }

    public CfgManager(String fname) {
        FileInputStream cfgstream = null;
        this.filename = fname == null ? "main.cfg" : fname;
        try {
            cfgstream = new FileInputStream(this.filename);
        }
        catch (FileNotFoundException fnf) {
            try {
                FileOutputStream newout = new FileOutputStream(this.filename);
                OutputStreamWriter writer = new OutputStreamWriter(newout);
                writer.write("main {\n}\n");
                writer.close();
                newout.close();
                cfgstream = new FileInputStream(this.filename);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        if (cfgstream == null) {
            return;
        }
        CfgFileParser parser = new CfgFileParser(cfgstream);
        try {
            this.mainblock = parser.Input();
            cfgstream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.mainblock == null) {
            this.mainblock = new CfgItem("main", new CfgSection());
        }
    }

    public String getFileName() {
        return this.filename;
    }

    public void setFileName(String s) {
        this.filename = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        if (this.unspace_keys) {
            key = this.unspace(key);
        }
        StringTokenizer st = new StringTokenizer(key, "/.,");
        CfgItem cfgItem = this.mainblock;
        synchronized (cfgItem) {
            CfgItem cur_level = this.mainblock;
            while (st.hasMoreTokens()) {
                if (cur_level == null) {
                    return null;
                }
                String s = st.nextToken();
                if (s.length() == 0) continue;
                if (cur_level instanceof CfgItem) {
                    Object cur_val = cur_level.getValue();
                    if (cur_val instanceof CfgSection) {
                        cur_level = ((CfgSection)cur_val).getItem(s);
                        continue;
                    }
                    return null;
                }
                if (cur_level instanceof CfgSection) {
                    cur_level = ((CfgSection)((Object)cur_level)).getItem(s);
                    continue;
                }
                return null;
            }
            return cur_level;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        if (this.unspace_keys) {
            key = this.unspace(key);
        }
        StringTokenizer st = new StringTokenizer(key, "/.,");
        CfgSection parent = null;
        String s = null;
        CfgItem cfgItem = this.mainblock;
        synchronized (cfgItem) {
            CfgItem cur_level = this.mainblock;
            while (st.hasMoreTokens()) {
                if (cur_level == null) {
                    return;
                }
                s = st.nextToken();
                if (s.length() == 0) continue;
                if (cur_level instanceof CfgItem) {
                    Object cur_val = cur_level.getValue();
                    if (cur_val instanceof CfgSection) {
                        parent = (CfgSection)cur_val;
                        cur_level = ((CfgSection)cur_val).getItem(s);
                        continue;
                    }
                    return;
                }
                if (cur_level instanceof CfgSection) {
                    parent = (CfgSection)((Object)cur_level);
                    cur_level = ((CfgSection)((Object)cur_level)).getItem(s);
                    continue;
                }
                return;
            }
            if (parent != null) {
                CfgItem o = parent.getItem(s);
                parent.removeItem(s);
            }
        }
    }

    public void put(String key, boolean b) {
        this.put(key, new Boolean(b));
    }

    public void put(String key, int i) {
        this.put(key, new Integer(i));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, Object o) {
        if (o instanceof Boolean) {
            o = o.toString();
        }
        if (this.unspace_keys) {
            key = this.unspace(key);
        }
        StringTokenizer st = new StringTokenizer(key, "/.,");
        String s = null;
        CfgItem cfgItem = this.mainblock;
        synchronized (cfgItem) {
            CfgItem cur_level = this.mainblock;
            while (st.hasMoreTokens()) {
                CfgSection cur_val;
                s = st.nextToken();
                if (s.length() == 0) continue;
                if (st.hasMoreTokens()) {
                    if (!(cur_level.getValue() instanceof CfgSection)) {
                        cur_level.setValue(new CfgSection());
                    }
                    if (!(cur_val = (CfgSection)cur_level.getValue()).contains(s)) {
                        cur_val.addItem(new CfgItem(s, new CfgSection()));
                    }
                    cur_level = cur_val.getItem(s);
                    continue;
                }
                cur_val = (CfgSection)cur_level.getValue();
                if (cur_val == null) {
                    return;
                }
                CfgItem newitem = new CfgItem(s, o);
                cur_val.addItem(newitem);
            }
        }
    }

    public void updateFromConfiguredObjects() {
        Enumeration e = this.configured_objects.keys();
        while (e.hasMoreElements()) {
            ConfiguredObject o = (ConfiguredObject)e.nextElement();
            o.saveCfg();
        }
    }

    public void updateToConfiguredObjects() {
        Enumeration e = this.configured_objects.keys();
        while (e.hasMoreElements()) {
            ConfiguredObject o = (ConfiguredObject)e.nextElement();
            o.updateCfg();
        }
    }

    public void addConfiguredObject(ConfiguredObject o, String newkey) {
        if (o == null || newkey == null) {
            return;
        }
        this.removeConfiguredObject(o);
        if (this.unspace_keys) {
            newkey = this.unspace(newkey);
        }
        this.removeConfiguredPath(newkey);
        CfgManager.setManager(o, this);
        this.configured_objects.put(o, newkey);
        o.updateCfg();
        o.saveCfg();
    }

    public void wipeConfiguredObject(ConfiguredObject o) {
        if (this.configured_objects.containsKey(o)) {
            this.remove((String)this.configured_objects.get(o));
            CfgManager.clearManager(o);
            this.configured_objects_reverse.remove(this.configured_objects.get(o));
            this.configured_objects.remove(o);
        }
    }

    public void removeConfiguredObject(ConfiguredObject o) {
        if (this.configured_objects.containsKey(o)) {
            CfgManager.clearManager(o);
            this.configured_objects_reverse.remove(this.configured_objects.get(o));
            this.configured_objects.remove(o);
        }
    }

    public void removeConfiguredPath(String key) {
        if (this.configured_objects_reverse.containsKey(key)) {
            this.remove(key);
            this.configured_objects.remove(this.configured_objects_reverse.get(key));
            this.configured_objects_reverse.remove(key);
        }
    }

    public ConfiguredObject getKeyObject(String path) {
        if (this.configured_objects_reverse.containsKey(path)) {
            return (ConfiguredObject)this.configured_objects_reverse.get(path);
        }
        return null;
    }

    public String getObjectKey(ConfiguredObject o) {
        if (this.configured_objects.containsKey(o)) {
            return (String)this.configured_objects.get(o);
        }
        return null;
    }

    public void setObjectKey(ConfiguredObject o, String key) {
        this.addConfiguredObject(o, key);
    }

    public Object getValue(String key) {
        Object o = this.get(key);
        if (o == null || o instanceof CfgSection) {
            return null;
        }
        if (o instanceof CfgItem) {
            return ((CfgItem)o).getValue();
        }
        return o;
    }

    public Boolean getBooleanValue(String key) {
        Object o = this.getValue(key);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            if (((String)o).equals("true") || ((String)o).equals("yes")) {
                return new Boolean(true);
            }
            if (((String)o).equals("false") || ((String)o).equals("no")) {
                return new Boolean(false);
            }
            return null;
        }
        if (o instanceof Integer) {
            if (((Integer)o).equals(new Integer(0))) {
                return new Boolean(false);
            }
            return new Boolean(true);
        }
        return null;
    }

    public String getStringValue(String key) {
        Object o = this.getValue(key);
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public Integer getIntegerValue(String key) {
        Object o = this.getValue(key);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return null;
    }

    public Point getPointValue(String key) {
        Object o = this.getValue(key);
        if (o instanceof Point) {
            return (Point)o;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        this.updateFromConfiguredObjects();
        try {
            System.err.println("trying to open " + this.filename);
            FileWriter cfgwriter = new FileWriter(this.filename);
            System.err.println("trying to write file");
            CfgItem cfgItem = this.mainblock;
            synchronized (cfgItem) {
                cfgwriter.write(this.mainblock.toString());
            }
            cfgwriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    protected String unspace(String s) {
        String result = new String("");
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            result = result + st.nextToken();
        }
        return result;
    }
}

