/*
 * Decompiled with CFR 0.152.
 */
package utilities.cfg;

import java.awt.Point;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;
import utilities.cfg.CfgFileParserConstants;
import utilities.cfg.CfgFileParserTokenManager;
import utilities.cfg.CfgItem;
import utilities.cfg.CfgSection;
import utilities.cfg.ParseException;
import utilities.cfg.SimpleCharStream;
import utilities.cfg.Token;

public class CfgFileParser
implements CfgFileParserConstants {
    static boolean debug = false;
    private static boolean jj_initialized_once = false;
    public static CfgFileParserTokenManager token_source;
    static SimpleCharStream jj_input_stream;
    public static Token token;
    public static Token jj_nt;
    private static int jj_ntk;
    private static Token jj_scanpos;
    private static Token jj_lastpos;
    private static int jj_la;
    public static boolean lookingAhead;
    private static boolean jj_semLA;
    private static int jj_gen;
    private static final int[] jj_la1;
    private static int[] jj_la1_0;
    private static final JJCalls[] jj_2_rtns;
    private static boolean jj_rescan;
    private static int jj_gc;
    private static final LookaheadSuccess jj_ls;
    private static Vector jj_expentries;
    private static int[] jj_expentry;
    private static int jj_kind;
    private static int[] jj_lasttokens;
    private static int jj_endpos;

    public static final CfgItem Input() throws ParseException {
        CfgItem file = CfgFileParser.Item();
        return file;
    }

    public static final CfgItem Item() throws ParseException {
        Token t1 = CfgFileParser.jj_consume_token(16);
        if (CfgFileParser.jj_2_1(2)) {
            Token t2 = CfgFileParser.jj_consume_token(16);
            if (debug) {
                System.err.println("parsed " + t2.image + " as an id");
            }
            return new CfgItem(t1.image, t2.image);
        }
        if (CfgFileParser.jj_2_2(2)) {
            Point p = CfgFileParser.Duple();
            return new CfgItem(t1.image, p);
        }
        if (CfgFileParser.jj_2_3(2)) {
            Number i = CfgFileParser.Int();
            if (debug) {
                System.err.println("parsed " + i + " as an int");
            }
            return new CfgItem(t1.image, i);
        }
        if (CfgFileParser.jj_2_4(2)) {
            Float f = CfgFileParser.Num();
            if (debug) {
                System.err.println("parsed " + f + " as a num");
            }
            return new CfgItem(t1.image, f);
        }
        if (CfgFileParser.jj_2_5(2)) {
            CfgSection section = CfgFileParser.Section();
            if (debug) {
                System.err.println("parsed token  as a section");
            }
            return new CfgItem(t1.image, section);
        }
        CfgFileParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final CfgSection Section() throws ParseException {
        CfgSection section = new CfgSection();
        CfgFileParser.jj_consume_token(10);
        while (CfgFileParser.jj_2_6(2)) {
            CfgItem nextitem = CfgFileParser.Item();
            section.addItem(nextitem);
        }
        CfgFileParser.jj_consume_token(11);
        return section;
    }

    public static final Number Int() throws ParseException {
        Number n;
        Token i = CfgFileParser.jj_consume_token(8);
        try {
            n = new Integer(i.image);
        }
        catch (NumberFormatException e) {
            try {
                n = new Long(i.image);
            }
            catch (NumberFormatException e2) {
                try {
                    n = new BigInteger(i.image);
                }
                catch (NumberFormatException e3) {
                    throw new ParseException("The number " + i.image + "is either invalid or _way_ too big.");
                }
            }
        }
        return n;
    }

    public static final Float Num() throws ParseException {
        Token n = CfgFileParser.jj_consume_token(9);
        return new Float(n.image);
    }

    public static final Point Duple() throws ParseException {
        Token x = CfgFileParser.jj_consume_token(8);
        CfgFileParser.jj_consume_token(7);
        Token y = CfgFileParser.jj_consume_token(8);
        return new Point(Integer.parseInt(x.image), Integer.parseInt(y.image));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean jj_2_1(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !CfgFileParser.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            CfgFileParser.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean jj_2_2(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !CfgFileParser.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            CfgFileParser.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean jj_2_3(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !CfgFileParser.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            CfgFileParser.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean jj_2_4(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !CfgFileParser.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            CfgFileParser.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean jj_2_5(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !CfgFileParser.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            CfgFileParser.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean jj_2_6(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !CfgFileParser.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            CfgFileParser.jj_save(5, xla);
        }
    }

    private static final boolean jj_3_4() {
        return CfgFileParser.jj_3R_4();
    }

    private static final boolean jj_3R_2() {
        if (CfgFileParser.jj_scan_token(8)) {
            return true;
        }
        return CfgFileParser.jj_scan_token(7);
    }

    private static final boolean jj_3_3() {
        return CfgFileParser.jj_3R_3();
    }

    private static final boolean jj_3_6() {
        return CfgFileParser.jj_3R_6();
    }

    private static final boolean jj_3_2() {
        return CfgFileParser.jj_3R_2();
    }

    private static final boolean jj_3R_5() {
        Token xsp;
        if (CfgFileParser.jj_scan_token(10)) {
            return true;
        }
        do {
            xsp = jj_scanpos;
        } while (!CfgFileParser.jj_3_6());
        jj_scanpos = xsp;
        return CfgFileParser.jj_scan_token(11);
    }

    private static final boolean jj_3_1() {
        return CfgFileParser.jj_scan_token(16);
    }

    private static final boolean jj_3R_4() {
        return CfgFileParser.jj_scan_token(9);
    }

    private static final boolean jj_3R_3() {
        return CfgFileParser.jj_scan_token(8);
    }

    private static final boolean jj_3_5() {
        return CfgFileParser.jj_3R_5();
    }

    private static final boolean jj_3R_6() {
        if (CfgFileParser.jj_scan_token(16)) {
            return true;
        }
        Token xsp = jj_scanpos;
        if (CfgFileParser.jj_3_1()) {
            jj_scanpos = xsp;
            if (CfgFileParser.jj_3_2()) {
                jj_scanpos = xsp;
                if (CfgFileParser.jj_3_3()) {
                    jj_scanpos = xsp;
                    if (CfgFileParser.jj_3_4()) {
                        jj_scanpos = xsp;
                        if (CfgFileParser.jj_3_5()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[0];
    }

    public CfgFileParser(InputStream stream) {
        int i;
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  You must");
            System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        jj_input_stream = new SimpleCharStream(stream, 1, 1);
        token_source = new CfgFileParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            CfgFileParser.jj_la1[i] = -1;
        }
        for (i = 0; i < jj_2_rtns.length; ++i) {
            CfgFileParser.jj_2_rtns[i] = new JJCalls();
        }
    }

    public static void ReInit(InputStream stream) {
        int i;
        jj_input_stream.ReInit(stream, 1, 1);
        CfgFileParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            CfgFileParser.jj_la1[i] = -1;
        }
        for (i = 0; i < jj_2_rtns.length; ++i) {
            CfgFileParser.jj_2_rtns[i] = new JJCalls();
        }
    }

    public CfgFileParser(Reader stream) {
        int i;
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  You must");
            System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        jj_input_stream = new SimpleCharStream(stream, 1, 1);
        token_source = new CfgFileParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            CfgFileParser.jj_la1[i] = -1;
        }
        for (i = 0; i < jj_2_rtns.length; ++i) {
            CfgFileParser.jj_2_rtns[i] = new JJCalls();
        }
    }

    public static void ReInit(Reader stream) {
        int i;
        jj_input_stream.ReInit(stream, 1, 1);
        CfgFileParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            CfgFileParser.jj_la1[i] = -1;
        }
        for (i = 0; i < jj_2_rtns.length; ++i) {
            CfgFileParser.jj_2_rtns[i] = new JJCalls();
        }
    }

    public CfgFileParser(CfgFileParserTokenManager tm) {
        int i;
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  You must");
            System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            CfgFileParser.jj_la1[i] = -1;
        }
        for (i = 0; i < jj_2_rtns.length; ++i) {
            CfgFileParser.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CfgFileParserTokenManager tm) {
        int i;
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            CfgFileParser.jj_la1[i] = -1;
        }
        for (i = 0; i < jj_2_rtns.length; ++i) {
            CfgFileParser.jj_2_rtns[i] = new JJCalls();
        }
    }

    private static final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = token;
        token = oldToken.next != null ? CfgFileParser.token.next : (CfgFileParser.token.next = token_source.getNextToken());
        jj_ntk = -1;
        if (CfgFileParser.token.kind == kind) {
            ++jj_gen;
            if (++jj_gc > 100) {
                jj_gc = 0;
                for (int i = 0; i < jj_2_rtns.length; ++i) {
                    JJCalls c = jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return token;
        }
        token = oldToken;
        jj_kind = kind;
        throw CfgFileParser.generateParseException();
    }

    private static final boolean jj_scan_token(int kind) {
        if (jj_scanpos == jj_lastpos) {
            --jj_la;
            if (CfgFileParser.jj_scanpos.next == null) {
                jj_scanpos = CfgFileParser.jj_scanpos.next = token_source.getNextToken();
                jj_lastpos = CfgFileParser.jj_scanpos.next;
            } else {
                jj_lastpos = jj_scanpos = CfgFileParser.jj_scanpos.next;
            }
        } else {
            jj_scanpos = CfgFileParser.jj_scanpos.next;
        }
        if (jj_rescan) {
            int i = 0;
            Token tok = token;
            while (tok != null && tok != jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                CfgFileParser.jj_add_error_token(kind, i);
            }
        }
        if (CfgFileParser.jj_scanpos.kind != kind) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public static final Token getNextToken() {
        token = CfgFileParser.token.next != null ? CfgFileParser.token.next : (CfgFileParser.token.next = token_source.getNextToken());
        jj_ntk = -1;
        ++jj_gen;
        return token;
    }

    public static final Token getToken(int index) {
        Token t = lookingAhead ? jj_scanpos : token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = token_source.getNextToken());
        }
        return t;
    }

    private static final int jj_ntk() {
        jj_nt = CfgFileParser.token.next;
        if (jj_nt == null) {
            CfgFileParser.token.next = token_source.getNextToken();
            jj_ntk = CfgFileParser.token.next.kind;
            return jj_ntk;
        }
        jj_ntk = CfgFileParser.jj_nt.kind;
        return jj_ntk;
    }

    private static void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == jj_endpos + 1) {
            CfgFileParser.jj_lasttokens[CfgFileParser.jj_endpos++] = kind;
        } else if (jj_endpos != 0) {
            jj_expentry = new int[jj_endpos];
            for (int i = 0; i < jj_endpos; ++i) {
                CfgFileParser.jj_expentry[i] = jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < jj_expentry.length; ++i) {
                    if (oldentry[i] == jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                jj_expentries.addElement(jj_expentry);
            }
            if (pos != 0) {
                jj_endpos = pos;
                CfgFileParser.jj_lasttokens[CfgFileParser.jj_endpos - 1] = kind;
            }
        }
    }

    public static ParseException generateParseException() {
        int i;
        jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[22];
        for (i = 0; i < 22; ++i) {
            la1tokens[i] = false;
        }
        if (jj_kind >= 0) {
            la1tokens[CfgFileParser.jj_kind] = true;
            jj_kind = -1;
        }
        for (i = 0; i < 0; ++i) {
            if (jj_la1[i] != jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 22; ++i) {
            if (!la1tokens[i]) continue;
            jj_expentry = new int[1];
            CfgFileParser.jj_expentry[0] = i;
            jj_expentries.addElement(jj_expentry);
        }
        jj_endpos = 0;
        CfgFileParser.jj_rescan_token();
        CfgFileParser.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[jj_expentries.size()][];
        for (int i2 = 0; i2 < jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])jj_expentries.elementAt(i2);
        }
        return new ParseException(token, exptokseq, CfgFileParserConstants.tokenImage);
    }

    public static final void enable_tracing() {
    }

    public static final void disable_tracing() {
    }

    private static final void jj_rescan_token() {
        jj_rescan = true;
        for (int i = 0; i < 6; ++i) {
            JJCalls p = jj_2_rtns[i];
            do {
                if (p.gen <= jj_gen) continue;
                jj_la = p.arg;
                jj_lastpos = jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        CfgFileParser.jj_3_1();
                        break;
                    }
                    case 1: {
                        CfgFileParser.jj_3_2();
                        break;
                    }
                    case 2: {
                        CfgFileParser.jj_3_3();
                        break;
                    }
                    case 3: {
                        CfgFileParser.jj_3_4();
                        break;
                    }
                    case 4: {
                        CfgFileParser.jj_3_5();
                        break;
                    }
                    case 5: {
                        CfgFileParser.jj_3_6();
                    }
                }
            } while ((p = p.next) != null);
        }
        jj_rescan = false;
    }

    private static final void jj_save(int index, int xla) {
        JJCalls p = jj_2_rtns[index];
        while (p.gen > jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = jj_gen + xla - jj_la;
        p.first = token;
        p.arg = xla;
    }

    static {
        lookingAhead = false;
        jj_la1 = new int[0];
        CfgFileParser.jj_la1_0();
        jj_2_rtns = new JJCalls[6];
        jj_rescan = false;
        jj_gc = 0;
        jj_ls = new LookaheadSuccess();
        jj_expentries = new Vector();
        jj_kind = -1;
        jj_lasttokens = new int[100];
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

