/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import utilities.Clock;

public class Log
extends OutputStreamWriter {
    public static final int LOG_SILENT = -1;
    public static final int LOG_EMERG = 0;
    public static final int LOG_ALERT = 0;
    public static final int LOG_CRIT = 0;
    public static final int LOG_ERR = 0;
    public static final int LOG_WARNING = 1;
    public static final int LOG_INFO = 2;
    public static final int LOG_DEBUG = 3;
    public static final int LOG_DEBUG2 = 4;
    public static final int LOG_SPAM = 5;
    public static final String ANSI_S = "\u001b[";
    public static final String ANSI_F = "\u001b[m";
    public static final String ANSI_C_RED = "31m";
    public static final String ANSI_C_GRN = "32m";
    public static final String ANSI_C_YEL = "33m";
    public static final String ANSI_C_BLU = "34m";
    public static final String ANSI_C_PUR = "35m";
    public static final String ANSI_C_CYN = "36m";
    public static final String ANSI_C_PNK = "37m";
    private static final int DEFAULT_LEVEL = 3;
    private static Log defLog;
    protected static long time;
    protected static String name;
    private boolean flush = true;
    private static boolean absolute;
    protected int level;
    private static boolean colors;
    public static final Integer lock;

    public Log(OutputStream s, int l) {
        super(s);
        this.setLevel(l);
        this.log("Logfile started.");
    }

    public Log(OutputStream s) {
        this(s, 3);
    }

    public Log(String file) throws IOException {
        this(new FileOutputStream(file));
    }

    public Log(String file, boolean append) throws IOException {
        this(new FileOutputStream(file, append));
    }

    protected void finalize() throws IOException {
        this.log("Logfile completed.");
        this.flush();
        this.close();
    }

    public void setName(String n) {
        name = n;
    }

    public String getName() {
        return name;
    }

    public static void setColors(boolean c) {
        colors = c;
    }

    public static synchronized void setDefault(Log l) {
        defLog = l;
    }

    public static synchronized Log getDefault() {
        if (defLog == null) {
            Log.setDefault(new Log(System.err));
        }
        return defLog;
    }

    public int getLogLevel() {
        return this.level;
    }

    public void setLevel(int l) {
        this.level = l;
    }

    public static String formatStr(String s, int l) {
        long t = Calendar.getInstance().getTime().getTime();
        if (!absolute) {
            t -= time;
        }
        if (colors) {
            if (l == 0) {
                s = "\u001b[31m" + s + ANSI_F;
            } else if (l == 1) {
                s = "\u001b[35m" + s + ANSI_F;
            }
            s = "\u001b[36m(" + Thread.currentThread().getName() + ")" + ANSI_F + ANSI_S + ANSI_C_GRN + " [" + Clock.getTime() + ":" + name + "] " + ANSI_F + s + "\n";
        } else {
            s = "(" + Thread.currentThread().getName() + ")" + " [" + Clock.getTime() + ":" + name + "] " + s + "\n";
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String s, int l) {
        if (l > this.level) {
            return;
        }
        try {
            Integer n = lock;
            synchronized (n) {
                this.write(Log.formatStr(s, l));
            }
            if (this.flush) {
                this.flush();
            }
        }
        catch (IOException e) {
            System.err.println("Error writing to logfile.");
        }
    }

    public void log(String s) {
        this.log(s, 3);
    }

    public void setFlush(boolean f) {
        this.flush = f;
        if (this.flush) {
            this.flush();
        }
    }

    public void flush() {
        try {
            super.flush();
        }
        catch (IOException e) {
            System.err.println("Error flushing logfile.");
        }
    }

    static {
        time = Calendar.getInstance().getTime().getTime();
        name = "???";
        absolute = false;
        colors = true;
        lock = new Integer(0);
    }
}

