/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.io.BufferedReader;
import utilities.Message;

public class LengthPrefixMessage
extends Message {
    protected static final int PREFIXLEN = 6;

    public LengthPrefixMessage(String s) {
        this.setData(s);
        this.setContent(this.parseData(s));
    }

    public LengthPrefixMessage(Object c, String da) {
        this("tell", c, da);
        this.updateData();
    }

    public LengthPrefixMessage(String p, Object c, String da) {
        super(c, "", 0, da, 0);
        this.updateData();
    }

    private void updateData() {
        String prefix = "" + this.getContent().toString().length();
        while (prefix.length() < 6) {
            prefix = "0" + prefix;
        }
        this.setData(prefix + this.getContent().toString());
    }

    private String parseData(String s) {
        String str = "";
        if (s.length() >= 6) {
            String prefix = s.substring(0, 6);
            int len = Integer.parseInt(prefix);
            if (s.length() != 6 + len) {
                System.err.println("Warning: Message prefix (" + len + ") and content length (" + s.length() + ") don't match");
            }
            str = s.substring(6, 6 + len);
        }
        return str;
    }

    public static String receive(BufferedReader b) {
        String prefix = LengthPrefixMessage.receive(b, 6);
        int len = 0;
        try {
            len = Integer.parseInt(prefix);
        }
        catch (NumberFormatException e) {
            System.err.println("Error: " + e);
            return "";
        }
        String str = LengthPrefixMessage.receive(b, len);
        return prefix + str;
    }

    public void setContent(Object c) {
        super.setContent(c);
        this.updateData();
    }
}

