/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.text.ParseException;
import utilities.KQML;
import utilities.Message;

public class KQMLMessage
extends Message
implements Cloneable {
    private String perf = "";
    private KQML kqmlmess = new KQML();

    public KQMLMessage(String s) {
        try {
            this.kqmlmess.parseMessage(s);
            super.setData(s);
            super.setSourceAddr(this.kqmlmess.getValue("sender"));
            if (this.getField("sender-port") != null) {
                super.setSourcePort(Integer.parseInt(this.kqmlmess.getValue("sender-port")));
            }
            super.setDestAddr(this.kqmlmess.getValue("receiver"));
            if (this.getField("receiver-port") != null) {
                super.setDestPort(Integer.parseInt(this.kqmlmess.getValue("receiver-port")));
            }
            super.setContent(this.kqmlmess.getValue("content"));
            this.perf = this.kqmlmess.getValue("performative");
        }
        catch (ParseException e) {
            System.err.println(e);
        }
    }

    public KQMLMessage(Object c, String da) {
        this("tell", c, da);
    }

    public KQMLMessage(String p, Object c, String da) {
        this(p, c, da, -1);
    }

    public KQMLMessage(String p, Object c, String da, int po) {
        super(c, "", -1, da, po);
        this.perf = p;
        this.addField("language", "KQML");
        this.makeMessage();
    }

    private void makeMessage() {
        this.addField("performative", this.perf);
        this.addField("sender", this.getSourceAddr());
        if (this.getSourcePort() >= 0) {
            this.addField("sender-port", String.valueOf(this.getSourcePort()));
        }
        this.addField("receiver", this.getDestAddr());
        if (this.getDestPort() >= 0) {
            this.addField("receiver-port", String.valueOf(this.getDestPort()));
        }
        if (this.getContent() != null) {
            String c = this.getContent().toString();
            if (c.indexOf(" ") > 0 && !c.startsWith("(") && !c.endsWith(")")) {
                c = "(" + c + ")";
            }
            this.addField("content", c);
        } else {
            this.removeField("content");
        }
    }

    public void addField(String fn, String fc) {
        if (fc == null) {
            this.removeField(fn);
            return;
        }
        this.kqmlmess.addField(fn, fc);
        this.updateData();
    }

    public void removeField(String fn) {
        this.kqmlmess.removeField(fn);
        this.updateData();
    }

    private void updateData() {
        this.setData(this.kqmlmess.getSendString());
    }

    public String getField(String fn) {
        return this.kqmlmess.getValue(fn);
    }

    public String getPerformative() {
        return this.perf;
    }

    public void setPerformative(String p) {
        this.perf = p;
        this.makeMessage();
    }

    public void setContent(Object c) {
        super.setContent(c);
        this.makeMessage();
    }

    public void setDestAddr(String da) {
        super.setDestAddr(da);
        this.makeMessage();
    }

    public void setDestPort(int dp) {
        super.setDestPort(dp);
        this.makeMessage();
    }

    public void setSourceAddr(String sa) {
        super.setSourceAddr(sa);
        this.makeMessage();
    }

    public void setSourcePort(int sp) {
        super.setSourcePort(sp);
        this.makeMessage();
    }

    public String contentWord() {
        if (this.getContent() == null) {
            return null;
        }
        return this.contentWord(this.cleanString(this.getContent().toString()));
    }

    public String contentData() {
        if (this.getContent() == null) {
            return null;
        }
        return this.contentData(this.cleanString(this.getContent().toString()));
    }

    private String cleanString(String str) {
        if (str == null) {
            return null;
        }
        if (str.startsWith("(")) {
            str = str.substring(1);
        }
        if (str.endsWith(")")) {
            str = str.substring(0, str.length() - 1);
        }
        str = str.trim();
        return str;
    }

    public Object clone() {
        KQMLMessage n = (KQMLMessage)super.clone();
        n.setPerformative(this.getPerformative());
        n.kqmlmess = (KQML)this.kqmlmess.clone();
        this.makeMessage();
        return n;
    }

    public String toString() {
        return "Message (from " + this.getSourceAddr() + ") " + "(to " + this.getDestAddr() + ") \"" + this.getData() + "\"\n";
    }
}

