/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.text.ParseException;
import java.text.StringCharacterIterator;
import java.util.Enumeration;
import java.util.Hashtable;

public class KQML
implements Cloneable {
    Hashtable fields = new Hashtable();
    String performative;

    public KQML() {
        this.performative = "";
    }

    public KQML(String str) throws ParseException {
        this.parseMessage(str);
    }

    public void parseMessage(String str) throws ParseException {
        block23: {
            int end;
            StringCharacterIterator it = new StringCharacterIterator(str);
            this.fields.clear();
            while (Character.isWhitespace(it.current())) {
                it.next();
            }
            if (it.current() == '\uffff') {
                throw new ParseException("KQML message must begin with (", it.getIndex());
            }
            if (it.current() != '(') {
                throw new ParseException("KQML message must begin with (", it.getIndex());
            }
            it.next();
            while (Character.isWhitespace(it.current())) {
                it.next();
            }
            if (it.current() == '\uffff') {
                throw new ParseException("Error finding performative", it.getIndex());
            }
            int start = end = it.getIndex();
            while (Character.isLetterOrDigit(it.current()) || Character.getType(it.current()) == 20) {
                it.next();
            }
            if (!Character.isWhitespace(it.current())) {
                throw new ParseException("Error finding performative", it.getIndex());
            }
            end = it.getIndex();
            this.performative = str.substring(start, end);
            while (true) {
                if (Character.isWhitespace(it.current())) {
                    it.next();
                    continue;
                }
                if (it.current() == '\uffff') {
                    throw new ParseException("Unexpected end of message", it.getIndex());
                }
                if (it.current() == ')') break block23;
                if (it.current() != ':') break;
                it.next();
                start = end = it.getIndex();
                while (it.current() != '\uffff') {
                    if (it.current() == '(') {
                        throw new ParseException("Error getting parameter name", it.getIndex());
                    }
                    if (it.current() == ')') {
                        end = it.getIndex();
                        break;
                    }
                    if (Character.isWhitespace(it.current())) {
                        end = it.getIndex();
                        break;
                    }
                    it.next();
                }
                String item = str.substring(start, end);
                while (Character.isWhitespace(it.current())) {
                    it.next();
                }
                if (it.current() == '\uffff') {
                    throw new ParseException("Unexpected end of message", it.getIndex());
                }
                if (it.current() == ':') {
                    this.fields.put(item, "");
                    continue;
                }
                if (it.current() == ')') continue;
                int count = 0;
                start = end = it.getIndex();
                while (it.current() != '\uffff') {
                    if (it.current() == '(') {
                        it.next();
                        ++count;
                        continue;
                    }
                    if (it.current() == ')') {
                        if (count == 0) {
                            end = it.getIndex();
                            break;
                        }
                        it.next();
                        --count;
                        continue;
                    }
                    if (Character.isWhitespace(it.current())) {
                        if (count == 0) {
                            end = it.getIndex();
                            break;
                        }
                        it.next();
                        continue;
                    }
                    it.next();
                }
                String value = str.substring(start, end);
                this.fields.put(item, value);
            }
            throw new ParseException("Unexpected end of message", it.getIndex());
        }
    }

    public String getValue(String i) {
        if (i.equalsIgnoreCase("performative")) {
            return this.getPerformative();
        }
        return (String)this.fields.get(i);
    }

    public void addFieldValuePair(String i, String v) {
        this.addField(i, v);
    }

    public void addField(String i, String v) {
        if (i.equalsIgnoreCase("performative")) {
            this.setPerformative(v);
            return;
        }
        this.fields.put(i, v);
    }

    public void removeField(String i) {
        if (i.equalsIgnoreCase("performative")) {
            return;
        }
        this.fields.remove(i);
    }

    public String getPerformative() {
        return this.performative;
    }

    public void setPerformative(String p) {
        this.performative = p;
    }

    public String getSendString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        buf.append(this.getPerformative());
        Enumeration e = this.fields.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            buf.append(" :" + key + " " + this.getValue(key));
        }
        buf.append(")");
        return buf.toString();
    }

    public Object clone() {
        KQML n = new KQML();
        n.setPerformative(this.getPerformative());
        Enumeration e = this.fields.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            n.addField(key, this.getValue(key));
        }
        return n;
    }

    public String toString() {
        return this.getSendString();
    }
}

