/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;
import utilities.GraphEdge;
import utilities.NodePanel;
import utilities.cfg.CfgManager;
import utilities.cfg.ConfiguredObject;

public class GraphNode
implements Serializable,
Cloneable,
ConfiguredObject,
Comparable {
    protected Vector outedges = new Vector();
    protected Vector inedges = new Vector();
    protected Vector undiredges = new Vector();
    protected Hashtable attributes = new Hashtable();
    protected boolean draggable = false;
    protected transient boolean selected;
    String label;

    public GraphNode(String l) {
        this.setLabel(l);
    }

    public GraphNode() {
        this(null);
    }

    public synchronized void updateCfg() {
        CfgManager manager = CfgManager.getManager(this);
        if (manager == null) {
            System.err.println("GraphNode " + this.getLabel() + "has no cfg manager...");
            return;
        }
        String key = manager.getObjectKey(this);
        if (key == null || key.length() == 0) {
            return;
        }
        Object tmp = manager.getValue(key + "/name");
        if (tmp != null && tmp instanceof String) {
            this.setLabel((String)tmp);
        }
    }

    public synchronized void saveCfg() {
        CfgManager manager = CfgManager.getManager(this);
        if (manager == null) {
            return;
        }
        String key = manager.getObjectKey(this);
        if (key == null || key.length() == 0) {
            return;
        }
        manager.put(key + "/name", this.getLabel());
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String l) {
        this.label = l;
    }

    public Object getAttribute(Object k) {
        return this.attributes.get(k.toString());
    }

    public void setAttribute(Object k, Object d) {
        if (d == null) {
            this.attributes.remove(k.toString());
        } else {
            this.attributes.put(k.toString(), d);
        }
    }

    public Enumeration getAttributes() {
        return this.attributes.keys();
    }

    public boolean hasAttribute(Object k) {
        return this.attributes.containsKey(k.toString());
    }

    public void addEdge(GraphNode t) {
        if (!this.undiredges.contains(t)) {
            this.undiredges.addElement(t);
            t.addEdge(this);
        }
    }

    public void removeEdge(GraphNode t) {
        if (this.undiredges.contains(t)) {
            this.undiredges.removeElement(t);
            t.removeEdge(this);
        }
    }

    public void addEdge(GraphEdge e, GraphNode t) {
        e.setEndpoints(this, t);
    }

    public void removeEdge(GraphEdge e) {
        if (this.outedges.contains(e) || this.inedges.contains(e)) {
            e.excise();
        }
    }

    protected void removeInEdge(GraphEdge e) {
        this.inedges.removeElement(e);
    }

    public Enumeration getOutEdges() {
        return this.outedges.elements();
    }

    protected void removeOutEdge(GraphEdge e) {
        this.outedges.removeElement(e);
    }

    protected void addOutEdge(GraphEdge e) {
        if (this instanceof GraphEdge) {
            System.err.println("Error: Cannot attach an Edge to another Edge");
            return;
        }
        this.outedges.addElement(e);
    }

    public boolean hasOutEdges() {
        return this.outedges.size() > 0;
    }

    public int numOutEdges() {
        return this.outedges.size();
    }

    public Enumeration getInEdges() {
        return this.inedges.elements();
    }

    public Enumeration getUndirEdges() {
        return this.undiredges.elements();
    }

    public boolean hasUndirEdges() {
        return this.undiredges.size() > 0;
    }

    public int numUndirEdges() {
        return this.undiredges.size();
    }

    protected void addInEdge(GraphEdge e) {
        if (this instanceof GraphEdge) {
            System.err.println("Error: Cannot attach an Edge to another Edge");
            return;
        }
        this.inedges.addElement(e);
    }

    public boolean hasInEdges() {
        return this.inedges.size() > 0;
    }

    public int numInEdges() {
        return this.inedges.size();
    }

    public void excise() {
        GraphEdge e;
        while (this.hasInEdges()) {
            e = (GraphEdge)this.inedges.firstElement();
            e.setTo(null);
        }
        while (this.hasOutEdges()) {
            e = (GraphEdge)this.outedges.firstElement();
            e.setTo(null);
        }
    }

    public int compareTo(Object o) {
        if (!(o instanceof GraphNode)) {
            return 1;
        }
        if (this.equals(o)) {
            return 0;
        }
        int result = this.getLabel() == null ? (((GraphNode)o).getLabel() == null ? 0 : 1) : (((GraphNode)o).getLabel() == null ? -1 : this.getLabel().compareTo(((GraphNode)o).getLabel()));
        if (result == 0) {
            if (o == this) {
                return 0;
            }
            return o.hashCode() - this.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public boolean matches(Object o) {
        if (o == null) {
            return true;
        }
        if (!(o instanceof GraphNode)) {
            return false;
        }
        GraphNode n = (GraphNode)o;
        if (n.getLabel() != null) {
            if (this.getLabel() == null) {
                return false;
            }
            if (!this.getLabel().startsWith(n.getLabel())) {
                return false;
            }
        }
        return n.getClass().isInstance(this);
    }

    public Object clone() {
        GraphNode cloned = null;
        try {
            cloned = (GraphNode)super.clone();
        }
        catch (Exception e) {
            System.out.println("Clone Error: " + e);
        }
        cloned.outedges = new Vector();
        Enumeration e = this.getOutEdges();
        while (e.hasMoreElements()) {
            GraphEdge g = (GraphEdge)((GraphEdge)e.nextElement()).clone();
            g.setFrom(cloned);
        }
        cloned.inedges = new Vector();
        return cloned;
    }

    public String toString() {
        return this.getLabel();
    }

    public JPanel getDefaultPanel() {
        return new NodePanel(this, this.getLabel());
    }
}

