/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import utilities.GraphEdge;
import utilities.GraphNode;
import utilities.NodePanel;
import utilities.cfg.ConfiguredObject;

public class GraphLayout
implements LayoutManager2,
ConfiguredObject {
    Hashtable components = new Hashtable();
    TreeMap nodes = new TreeMap();
    Hashtable locations = new Hashtable();
    Dimension preferred = new Dimension(25, 25);
    Point origin = new Point(0, 0);
    boolean layedoutonce = false;
    protected int H_SPACE = 50;
    protected int V_SPACE = 50;
    protected int H_SPACE2 = 50;
    protected int V_SPACE2 = 50;
    protected int H_MARGIN = 50;
    protected int V_MARGIN = 50;
    int rows;
    int columns;
    int currow = 0;
    int curcol = 0;
    boolean willsave = true;
    boolean handlesrecursiveplacement = true;
    String savefile = null;
    GraphNode notanode = new GraphNode("not a node - if this is visible, there is a bug in the Graph rendering system");
    Point snap = new Point(0, 0);
    Point dragoffset = new Point(0, 0);
    Component selected = null;
    JTextArea text = new JTextArea("Nothing Selected");
    boolean thorough_placement = false;
    GraphNode ncached = null;
    Component sourcecached = null;
    JComponent menu_action_container = null;
    JPopupMenu the_menu = null;
    Vector unaddedMenuItems = new Vector();

    public GraphLayout(int r, int c, String savename, JTextArea txt) {
        this.rows = r;
        this.columns = c;
        this.text.setEditable(false);
        this.text = txt;
        this.savefile = savename;
        if (this.savefile == null) {
            this.willsave = false;
        }
        this.text.setBackground(Color.lightGray);
        this.loadNodePlacements();
    }

    public GraphLayout(int r, int c) {
        this(r, c, null, new JTextArea());
    }

    public GraphLayout(String n, JTextArea txt) {
        this(0, 0, n, txt);
    }

    public GraphLayout() {
        this(0, 0, null, new JTextArea());
    }

    public void setSave(boolean b) {
        this.willsave = b;
    }

    public void setRecursivePlacement(boolean b) {
        this.handlesrecursiveplacement = b;
    }

    public boolean willHandleRecursivePlacement() {
        return this.handlesrecursiveplacement;
    }

    public void setSaveFile(String s) {
        this.savefile = new String(s);
    }

    public void setSpacing(int hspace, int vspace, int hspace2, int vspace2, int hmargin, int vmargin) {
        this.H_SPACE = Math.max(hspace, 0);
        this.V_SPACE = Math.max(vspace, 0);
        this.H_SPACE2 = Math.max(hspace2, 0);
        this.V_SPACE2 = Math.max(vspace2, 0);
        this.H_MARGIN = Math.max(hmargin, 0);
        this.V_MARGIN = Math.max(vmargin, 0);
    }

    public void addLayoutComponent(String name, Component component) {
        this.addLayoutComponent(component, name);
    }

    public void removeLayoutComponent(Component component) {
        if (this.components.contains(component)) {
            this.components.remove(component);
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        if (!this.layedoutonce) {
            this.placeNodes();
        }
        return this.preferred;
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public void layoutContainer(Container parent) {
        this.placeNodes();
        this.addMenuIfNecessary(parent);
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints == null || !(constraints instanceof GraphNode)) {
            System.err.println("here!");
            Object o = this.nodes.get(this.notanode);
            if (o == null || !(o instanceof Set)) {
                o = new TreeSet(new ComponentComparator());
                this.nodes.put(this.notanode, o);
            }
            ((Set)o).add(comp);
            this.components.put(comp, this.notanode);
            return;
        }
        this.components.put(comp, constraints);
        this.nodes.put(constraints, comp);
        comp.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                GraphLayout.this.processMouseEvent(e);
            }

            public void mouseReleased(MouseEvent e) {
                GraphLayout.this.processMouseEvent(e);
            }
        });
        comp.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                GraphLayout.this.processMouseEvent(e);
            }

            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    public Dimension maximumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }

    public boolean findConflict(Component c, Rectangle location) {
        Enumeration e = this.components.keys();
        while (e.hasMoreElements()) {
            LayoutManager layout;
            Component com = (Component)e.nextElement();
            if (c == com || !com.getBounds().intersects(location) || !this.hasBeenPlaced(com)) continue;
            if (com instanceof Container && (layout = ((Container)com).getLayout()) instanceof GraphLayout && layout != this && ((GraphLayout)layout).willHandleRecursivePlacement() && (!(c instanceof Container) || !(((Container)c).getLayout() instanceof GraphLayout))) {
                Rectangle newlocation = new Rectangle(location.x - com.getLocation().x, location.y - com.getLocation().y, location.width, location.height);
                if (!((GraphLayout)layout).findConflict(c, newlocation)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public Vector findNodes(Point p) {
        Vector<Component> v = new Vector<Component>();
        Enumeration e = this.components.keys();
        while (e.hasMoreElements()) {
            Component c = (Component)e.nextElement();
            if (!c.getBounds().contains(p) || !c.isVisible()) continue;
            v.addElement(c);
        }
        return v;
    }

    public Component findNode(Point p) {
        Vector v = this.findNodes(p);
        Enumeration e = v.elements();
        Component i = null;
        Component n = null;
        while (e.hasMoreElements()) {
            Component c = (Component)e.nextElement();
            GraphNode no = this.getNode(c);
            if (no instanceof GraphEdge) {
                return c;
            }
            if (this.isMoveable(c)) {
                i = c;
                continue;
            }
            n = c;
        }
        if (n != null) {
            return n;
        }
        return i;
    }

    protected boolean isMoveable(Component c) {
        if (c instanceof NodePanel) {
            return ((NodePanel)c).isMoveable();
        }
        return false;
    }

    public JTextArea getText() {
        return this.text;
    }

    protected void processMouseEvent(MouseEvent e) {
        Point p = e.getPoint();
        GraphNode n = null;
        Component source = (Component)e.getSource();
        p = new Point(p.x + source.getLocation().x, p.y + source.getLocation().y);
        if (source == this.sourcecached) {
            n = this.ncached;
        } else if (e.getID() != 501) {
            n = this.ncached;
            source = this.sourcecached;
        } else {
            Component temp = this.findNode(p);
            if (temp != null) {
                source = temp;
            }
            if (source != null) {
                n = this.getNode(source);
            }
            this.ncached = n;
            this.sourcecached = source;
        }
        if (source != null && source instanceof JComponent) {
            JPopupMenu menu = (JPopupMenu)((JComponent)source).getClientProperty("GraphMenu");
            if (e.isPopupTrigger()) {
                if (menu != null && !menu.isVisible()) {
                    menu.show((Component)e.getSource(), e.getPoint().x, e.getPoint().y);
                    return;
                }
            } else if (e.getID() == 501 && menu != null && menu.isVisible()) {
                menu.setVisible(false);
            }
        }
        if (e.getID() == 501) {
            if (this.selected != null && this.selected instanceof NodePanel) {
                ((NodePanel)this.selected).setSelected(false);
            }
            if (n != null) {
                if (n instanceof GraphNode) {
                    if (source instanceof NodePanel) {
                        ((NodePanel)source).setSelected(true);
                    }
                    if (this.getNode(this.selected) != n) {
                        System.err.println(n.toString());
                        this.text.setText(n.toString());
                        this.selected = source;
                        if (this.menu_action_container != null) {
                            this.menu_action_container.repaint();
                        } else if (source != null) {
                            source.repaint();
                        }
                        source.getParent().repaint();
                    }
                }
                this.snap = new Point(source.getLocation());
                this.dragoffset = e.getSource() == source ? new Point(e.getX(), e.getY()) : new Point(e.getX() + ((Component)e.getSource()).getLocation().x - source.getLocation().x, e.getY() + ((Component)e.getSource()).getLocation().y - source.getLocation().y);
            } else {
                this.text.setText("Nothing selected.");
            }
        }
        if (e.getID() == 502 && this.selected != null && source == this.selected) {
            if (!this.isMoveable(this.selected)) {
                this.selected.setLocation(this.snap);
                if (this.menu_action_container != null) {
                    this.menu_action_container.repaint();
                } else if (source != null) {
                    source.repaint();
                }
                source.getParent().repaint();
            } else {
                this.saveNodePlacements();
            }
        }
        if (e.getID() == 506) {
            if (this.selected != null && source == this.selected) {
                Point z = this.selected == e.getSource() ? new Point(e.getX() + this.selected.getLocation().x, e.getY() + this.selected.getLocation().y) : new Point(e.getX() + ((Component)e.getSource()).getLocation().x, e.getY() + ((Component)e.getSource()).getLocation().y);
                if (z.x >= 0 && z.y >= 0) {
                    this.selected.setLocation(new Point(z.x - this.dragoffset.x, z.y - this.dragoffset.y));
                }
            }
            if (this.menu_action_container != null) {
                this.menu_action_container.repaint();
            } else if (source != null) {
                source.repaint();
            }
            source.getParent().repaint();
        }
        if (source != null) {
            this.storeNodePlacement(source);
        }
    }

    public void addMenuItem(JMenuItem item) {
        if (this.the_menu == null) {
            this.unaddedMenuItems.addElement(item);
        } else {
            this.the_menu.add(item);
        }
    }

    protected void addMenuIfNecessary(Container c) {
        c.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                GraphLayout.this.processMouseEvent(e);
            }

            public void mouseReleased(MouseEvent e) {
                GraphLayout.this.processMouseEvent(e);
            }
        });
        if (c instanceof JComponent) {
            JComponent jc;
            this.menu_action_container = jc = (JComponent)c;
            Boolean B = (Boolean)jc.getClientProperty("GraphLayoutMenuInPlace");
            if (B == null || !B.booleanValue()) {
                JPopupMenu menu = (JPopupMenu)jc.getClientProperty("GraphMenu");
                if (menu == null) {
                    menu = new JPopupMenu();
                    jc.putClientProperty("GraphMenu", menu);
                }
                this.the_menu = menu;
                JMenuItem m = new JMenuItem("Refresh");
                m.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        GraphLayout.this.menu_action_container.repaint();
                    }
                });
                menu.add(m);
                m = new JMenuItem("Reset node placements");
                m.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        GraphLayout.this.resetNodePlacing();
                        GraphLayout.this.menu_action_container.repaint();
                    }
                });
                menu.add(m);
                Enumeration e = this.unaddedMenuItems.elements();
                while (e.hasMoreElements()) {
                    menu.add((JMenuItem)e.nextElement());
                }
                this.unaddedMenuItems = new Vector();
                menu.setInvoker(c);
                jc.putClientProperty("GraphLayoutMenuInPlace", new Boolean(true));
            }
        }
    }

    public Component getSelected() {
        return this.selected;
    }

    public void setSelected(Component c) {
        this.selected = c;
    }

    public GraphNode getNode(Component c) {
        if (c == null) {
            return null;
        }
        Object fnord = this.components.get(c);
        if (fnord == this.notanode) {
            return null;
        }
        return (GraphNode)fnord;
    }

    public Component getComponent(GraphNode n) {
        return (Component)this.nodes.get(n);
    }

    protected String getSaveName(Component c) {
        String s = null;
        GraphNode n = this.getNode(c);
        if (n != null) {
            if (n instanceof GraphNode) {
                s = n.getLabel();
                if ((s == null || s == "") && n instanceof GraphEdge) {
                    s = "Edge: " + ((GraphEdge)n).getFrom().getLabel() + " to " + ((GraphEdge)n).getTo().getLabel();
                }
            } else {
                s = n.getLabel();
            }
        } else {
            s = String.valueOf(c.hashCode());
        }
        return s;
    }

    protected void storeNodePlacement(Component c) {
        String s = this.getSaveName(c);
        if (s != null && s != "") {
            this.locations.put(s, c.getLocation());
        }
    }

    protected void restoreNodePlacement(Component c) {
        String s = this.getSaveName(c);
        Point loading = null;
        if (s != null && this.locations.containsKey(s)) {
            loading = (Point)this.locations.get(s);
        }
        if (loading != null) {
            loading = new Point(loading.x, loading.y);
        }
        if (loading == null) {
            this.placeNewNode(c);
        } else {
            this.placeNewNode(c, loading);
        }
    }

    public Point getLocationForLine(GraphNode n, GraphNode src) {
        NodePanel panel = null;
        JPanel jpanel = (JPanel)this.getComponent(n);
        if (jpanel != null && jpanel instanceof NodePanel) {
            panel = (NodePanel)jpanel;
        }
        Point p = panel != null ? panel.getLocationForLine(src) : (jpanel != null ? new Point(jpanel.getLocation().x + jpanel.getWidth() / 2, jpanel.getLocation().y + jpanel.getHeight() / 2) : new Point(0, 0));
        return p;
    }

    protected void placeNewNode(Component c) {
        Point initial;
        GraphNode n = this.getNode(c);
        if (n != null && n instanceof GraphEdge) {
            GraphNode f = ((GraphEdge)n).getFrom();
            GraphNode t = ((GraphEdge)n).getTo();
            initial = new Point(Math.abs((this.getLocationForLine((GraphNode)f, (GraphNode)t).x + this.getLocationForLine((GraphNode)t, (GraphNode)f).x) / 2), Math.abs((this.getLocationForLine((GraphNode)f, (GraphNode)t).y + this.getLocationForLine((GraphNode)t, (GraphNode)f).y) / 2));
        } else if (n != null && !this.isMoveable(c)) {
            initial = new Point(0, 0);
        } else {
            initial = new Point(this.curcol * this.H_SPACE + this.H_MARGIN, this.currow * this.V_SPACE + this.V_MARGIN);
            if (this.columns > 0 && this.curcol >= this.columns - 1) {
                ++this.currow;
                this.curcol = 0;
            } else {
                ++this.curcol;
            }
        }
        this.placeNewNode(c, initial);
    }

    protected Point findClearSpaceAlongLine(Component c, Point p1, Point p2, int spacing) {
        int temp;
        int checks;
        Dimension d = c.getPreferredSize();
        if (p1.x < this.H_MARGIN) {
            p1.x = this.H_MARGIN;
        }
        if (p1.y < this.V_MARGIN) {
            p1.y = this.V_MARGIN;
        }
        if (p2.x < this.H_MARGIN) {
            p2.x = this.H_MARGIN;
        }
        if (p2.y < this.V_MARGIN) {
            p2.y = this.V_MARGIN;
        }
        if ((checks = (int)(Math.sqrt(temp = (p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y) * (p1.y - p2.y)) / (double)spacing)) < 1) {
            checks = 1;
        }
        int ychange = -(p1.y - p2.y) / checks;
        int xchange = -(p1.x - p2.x) / checks;
        Point p = new Point(p1.x, p1.y);
        for (int count = 0; count < checks; ++count) {
            if (!this.findConflict(c, new Rectangle(p.x, p.y, d.width, d.height))) {
                return p;
            }
            p = new Point(p.x + xchange, p.y + ychange);
        }
        return null;
    }

    protected Point findClearSpaceThorough(Component c, Point initial, int out) {
        Rectangle search = new Rectangle(initial.x - out * this.H_SPACE2, initial.y - out * this.V_SPACE2, 2 * out * this.H_SPACE2, 2 * out * this.V_SPACE2);
        Point p = this.findClearSpaceAlongLine(c, new Point(search.x, search.y), new Point(search.x + search.width, search.y), this.H_SPACE2);
        if (p != null) {
            return p;
        }
        p = this.findClearSpaceAlongLine(c, new Point(search.x + search.width, search.y), new Point(search.x + search.width, search.y + search.height), this.V_SPACE2);
        if (p != null) {
            return p;
        }
        p = this.findClearSpaceAlongLine(c, new Point(search.x + search.width, search.y + search.height), new Point(search.x, search.y + search.width), this.H_SPACE2);
        if (p != null) {
            return p;
        }
        p = this.findClearSpaceAlongLine(c, new Point(search.x, search.y), new Point(search.x + search.width, search.y), this.V_SPACE2);
        if (p != null) {
            return p;
        }
        return null;
    }

    protected Point findClearSpaceQuick(Component c, Point initial, int out) {
        GraphNode n = this.getNode(c);
        Point p = new Point(initial.x + out * this.H_SPACE, initial.y);
        Dimension d = c.getPreferredSize();
        if (p.x >= 0 && p.y >= 0 && !this.findConflict(c, new Rectangle(p.x, p.y, d.width, d.height))) {
            return p;
        }
        if (n != null && n instanceof GraphEdge) {
            p = new Point(initial.x, initial.y + out * this.V_SPACE);
            if (p.x >= 0 && p.y >= 0 && !this.findConflict(c, new Rectangle(p.x, p.y, d.width, d.height))) {
                return p;
            }
        }
        p = new Point(initial.x - out * this.H_SPACE, initial.y);
        if (p.x >= 0 && p.y >= 0 && !this.findConflict(c, new Rectangle(p.x, p.y, d.width, d.height))) {
            return p;
        }
        if (n != null && n instanceof GraphEdge) {
            p = new Point(initial.x, initial.y - out * this.V_SPACE);
            if (p.x >= 0 && p.y >= 0 && !this.findConflict(c, new Rectangle(p.x, p.y, d.width, d.height))) {
                return p;
            }
        }
        return null;
    }

    protected Point findClearSpace(Component c, Point initial) {
        Point p = new Point(Math.max(initial.x, 0), Math.max(initial.y, 0));
        GraphNode n = this.getNode(c);
        Dimension d = c.getPreferredSize();
        if (!this.findConflict(c, new Rectangle(p.x, p.y, d.width, d.height))) {
            return p;
        }
        for (int out = 1; out < 1000; ++out) {
            p = this.thorough_placement || n != null && n instanceof GraphEdge ? this.findClearSpaceThorough(c, initial, out) : this.findClearSpaceQuick(c, initial, out);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    protected boolean hasBeenPlaced(Component c) {
        if (this.getSaveName(c) != null && this.locations.containsKey(this.getSaveName(c))) {
            return true;
        }
        return this.getNode(c) != null && !this.isMoveable(c);
    }

    protected void placeNewNode(Component c, Point initial) {
        Point p = new Point(initial.x, initial.y);
        GraphNode n = this.getNode(c);
        Dimension d = c.getPreferredSize();
        if (this.isMoveable(c)) {
            p = this.findClearSpace(c, p);
            c.setLocation(p);
        }
        this.storeNodePlacement(c);
        if (p.x + d.width + this.H_MARGIN - this.origin.x > this.preferred.width) {
            this.preferred = new Dimension(p.x + d.width + this.H_MARGIN - this.origin.x, this.preferred.height);
        }
        if (p.y + d.height + this.V_MARGIN - this.origin.y > this.preferred.height) {
            this.preferred = new Dimension(this.preferred.width, p.y + d.height + this.V_MARGIN - this.origin.y);
        }
    }

    public void resetNodePlacing() {
        this.currow = 0;
        this.curcol = 0;
        this.locations = new Hashtable();
        this.placeNodes();
    }

    protected void saveNodePlacements() {
        if (!this.willsave) {
            return;
        }
        try {
            FileOutputStream file = new FileOutputStream(this.savefile);
            ObjectOutputStream out = new ObjectOutputStream(file);
            out.writeObject(this.locations);
        }
        catch (IOException e) {
            System.err.println("Cannot open " + this.savefile + " for output");
            return;
        }
    }

    protected void loadNodePlacements() {
        if (!this.willsave) {
            return;
        }
        try {
            FileInputStream file = new FileInputStream(this.savefile);
            ObjectInputStream in = new ObjectInputStream(file);
            this.locations = (Hashtable)in.readObject();
        }
        catch (IOException e) {
            System.err.println("Cannot open " + this.savefile + " for input");
            this.locations = new Hashtable();
            return;
        }
        catch (ClassNotFoundException e2) {
            System.err.println("Somethings really screwed up...");
            return;
        }
    }

    public void placeNodes() {
        GraphNode n;
        this.curcol = 0;
        this.currow = 0;
        Iterator<Object> i = this.nodes.values().iterator();
        this.layedoutonce = true;
        while (i.hasNext()) {
            Component c = (Component)i.next();
            c.setSize(c.getPreferredSize());
        }
        i = this.nodes.keySet().iterator();
        while (i.hasNext()) {
            n = (GraphNode)i.next();
            if (n == null || n == this.notanode || n instanceof GraphEdge) continue;
            this.restoreNodePlacement(this.getComponent(n));
        }
        i = this.nodes.keySet().iterator();
        while (i.hasNext()) {
            n = (GraphNode)i.next();
            if (n == null || !(n instanceof GraphEdge)) continue;
            this.restoreNodePlacement(this.getComponent(n));
        }
        this.saveNodePlacements();
    }

    public synchronized void updateCfg() {
    }

    public synchronized void saveCfg() {
    }

    protected class ComponentComparator
    implements Comparator {
        protected ComponentComparator() {
        }

        public boolean equals(Object obj) {
            return obj instanceof ComponentComparator;
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1.equals(obj2)) {
                return 0;
            }
            if (obj1 instanceof Component && obj2 instanceof Component) {
                return ((Component)obj1).getName().compareTo(((Component)obj2).getName());
            }
            throw new ClassCastException();
        }
    }
}

