/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Distribution
extends Vector
implements Serializable {
    public Distribution() {
    }

    public Distribution(Float Value, Float Distribution2) {
        this();
        this.appendTerm(Value, Distribution2);
    }

    public Distribution(float Value, float Distribution2) {
        this(new Float(Value), new Float(Distribution2));
    }

    public Distribution(double Value, double Distribution2) {
        this((float)Value, (float)Distribution2);
    }

    public Distribution(String str) {
        str = str.trim();
        if (str.startsWith("(")) {
            str = str.substring(1, str.length());
        }
        if (str.endsWith(")")) {
            str = str.substring(0, str.length() - 1);
        }
        str = str.trim();
        StringTokenizer tok = new StringTokenizer(str);
        while (tok.hasMoreElements()) {
            Float v = Float.valueOf(tok.nextToken());
            Float d = Float.valueOf(tok.nextToken());
            this.appendTerm(v, d);
        }
    }

    public float[] getArray() {
        float[] distribution = new float[this.size()];
        int counter = 0;
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            distribution[counter + 1] = ((Float)e.nextElement()).floatValue();
            distribution[counter] = ((Float)e.nextElement()).floatValue();
            counter += 2;
        }
        return distribution;
    }

    public Hashtable getHashtable() {
        Hashtable<Float, Float> ht = new Hashtable<Float, Float>();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            ht.put((Float)e.nextElement(), (Float)e.nextElement());
        }
        return ht;
    }

    public float findValue(float v) {
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            float value = ((Float)e.nextElement()).floatValue();
            float prob = ((Float)e.nextElement()).floatValue();
            if (value != v) continue;
            return prob;
        }
        return 0.0f;
    }

    public float findClosestValue(float v) {
        Enumeration e = this.elements();
        float closestvalue = Float.POSITIVE_INFINITY;
        float closestprob = Float.NEGATIVE_INFINITY;
        while (e.hasMoreElements()) {
            float value = ((Float)e.nextElement()).floatValue();
            float prob = ((Float)e.nextElement()).floatValue();
            if (Math.abs(value - v) < Math.abs(closestvalue - v)) {
                closestvalue = value;
                closestprob = prob;
                continue;
            }
            if (Math.abs(value - v) != Math.abs(closestvalue - v) || !(prob > closestprob)) continue;
            closestvalue = value;
            closestprob = prob;
        }
        return closestvalue;
    }

    public boolean containsValue(float v, float t) {
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            float value = ((Float)e.nextElement()).floatValue();
            if (!(value - t <= v) || !(value + t >= v)) continue;
            return true;
        }
        return false;
    }

    public float calculateMin() {
        Enumeration e = this.elements();
        float min = ((Float)this.elementAt(0)).floatValue();
        while (e.hasMoreElements()) {
            float cur = ((Float)e.nextElement()).floatValue();
            if (min > cur) {
                min = cur;
            }
            cur = ((Float)e.nextElement()).floatValue();
        }
        return min;
    }

    public float calculateMax() {
        Enumeration e = this.elements();
        float max = ((Float)this.elementAt(0)).floatValue();
        while (e.hasMoreElements()) {
            float cur = ((Float)e.nextElement()).floatValue();
            if (max < cur) {
                max = cur;
            }
            cur = ((Float)e.nextElement()).floatValue();
        }
        return max;
    }

    public float calculateAvg() {
        Enumeration e = this.elements();
        float avg = 0.0f;
        while (e.hasMoreElements()) {
            float value = ((Float)e.nextElement()).floatValue();
            float prob = ((Float)e.nextElement()).floatValue();
            avg += value * prob;
        }
        return avg;
    }

    public float calculateMostLikely() {
        Enumeration e = this.elements();
        float mvalue = 0.0f;
        float mprob = 0.0f;
        while (e.hasMoreElements()) {
            float value = ((Float)e.nextElement()).floatValue();
            float prob = ((Float)e.nextElement()).floatValue();
            if (!(prob > mprob)) continue;
            mprob = prob;
            mvalue = value;
        }
        return mvalue;
    }

    public float calculateDeviation() {
        float mean = this.calculateAvg();
        Enumeration e = this.elements();
        float somme = 0.0f;
        float somme_prob = 0.0f;
        while (e.hasMoreElements()) {
            float value = ((Float)e.nextElement()).floatValue();
            float prob = ((Float)e.nextElement()).floatValue();
            somme += prob * (value * value);
            somme_prob = prob + somme_prob;
        }
        float result = (float)Math.sqrt(somme / somme_prob - mean * mean);
        return result;
    }

    public float calculateTotalDensity() {
        float prob = 0.0f;
        for (int i = 0; i < this.size(); ++i) {
            prob += ((Float)this.elementAt(++i)).floatValue();
        }
        return prob;
    }

    public Distribution applyDensity(float density) {
        Distribution d = (Distribution)this.clone();
        for (int i = 0; i < d.size(); ++i) {
            float prob = ((Float)d.elementAt(++i)).floatValue();
            d.setElementAt(new Float(prob * density), i);
        }
        return d;
    }

    public Distribution applyPower(float power) {
        Distribution d = (Distribution)this.clone();
        for (int i = 0; i < d.size(); ++i) {
            float value = ((Float)d.elementAt(i)).floatValue();
            d.setElementAt(new Float(value * power), i);
            ++i;
        }
        return d;
    }

    public Distribution applyOffset(float offset) {
        Distribution d = (Distribution)this.clone();
        for (int i = 0; i < d.size(); ++i) {
            float value = ((Float)d.elementAt(i)).floatValue();
            d.setElementAt(new Float(value + offset), i);
            ++i;
        }
        return d;
    }

    public void appendTerm(Float v, Float d) {
        this.addElement(v);
        this.addElement(d);
    }

    public void appendTerm(float v, float d) {
        this.addElement(new Float(v));
        this.addElement(new Float(d));
    }

    public void appendTerm(double v, double d) {
        this.addElement(new Float(v));
        this.addElement(new Float(d));
    }

    public Distribution appendDistribution(Distribution d) {
        Distribution d1 = (Distribution)this.clone();
        Enumeration e = d.elements();
        while (e.hasMoreElements()) {
            Float value = (Float)e.nextElement();
            Float prob = (Float)e.nextElement();
            d1.insertElementAt(prob, 0);
            d1.insertElementAt(value, 0);
        }
        return d1;
    }

    public static Distribution computeJointDistribution(Vector v) {
        Distribution newd = new Distribution();
        Distribution.subComputeJointDistribution(0.0f, 1.0f, v, 0, newd);
        newd.compact();
        return newd;
    }

    public static Distribution computeJointDistribution(Distribution d1, Distribution d2) {
        Vector<Distribution> v = new Vector<Distribution>();
        v.addElement(d1);
        v.addElement(d2);
        return Distribution.computeJointDistribution(v);
    }

    private static void subComputeJointDistribution(float v, float p, Vector dists, int index, Distribution output) {
        if (index < dists.size()) {
            Distribution d = (Distribution)dists.elementAt(index);
            Enumeration e = d.elements();
            while (e.hasMoreElements()) {
                float nv = ((Float)e.nextElement()).floatValue();
                float np = ((Float)e.nextElement()).floatValue();
                Distribution.subComputeJointDistribution(v + nv, p * np, dists, index + 1, output);
            }
        } else {
            output.appendTerm(new Float(v), new Float(p));
        }
    }

    public static Distribution computeDifferenceJointDistribution(Vector v) {
        Distribution newd = new Distribution();
        Distribution.subComputeDifferenceJointDistribution(0.0f, 1.0f, v, 0, newd);
        newd.compact();
        return newd;
    }

    public static Distribution computeDifferenceJointDistribution(Distribution d1, Distribution d2) {
        Vector<Distribution> v = new Vector<Distribution>();
        v.addElement(d1);
        v.addElement(d2);
        return Distribution.computeDifferenceJointDistribution(v);
    }

    private static void subComputeDifferenceJointDistribution(float v, float p, Vector dists, int index, Distribution output) {
        if (index < dists.size()) {
            Distribution d = (Distribution)dists.elementAt(index);
            Enumeration e = d.elements();
            while (e.hasMoreElements()) {
                float p1;
                float v1;
                float nv = ((Float)e.nextElement()).floatValue();
                float np = ((Float)e.nextElement()).floatValue();
                if ((double)v == 0.0) {
                    v1 = nv;
                    p1 = np;
                } else {
                    v1 = v - nv;
                    p1 = p * np;
                }
                Distribution.subComputeDifferenceJointDistribution(v1, p1, dists, index + 1, output);
            }
        } else {
            output.appendTerm(new Float(v), new Float(p));
        }
    }

    public static Distribution computeMaxJointDistribution(Vector v) {
        Distribution newd = new Distribution();
        Distribution.subComputeMaxJointDistribution(0.0f, 1.0f, v, 0, newd);
        newd.compact();
        return newd;
    }

    public static Distribution computeMaxJointDistribution(Distribution d1, Distribution d2) {
        Vector<Distribution> v = new Vector<Distribution>();
        v.addElement(d1);
        v.addElement(d2);
        return Distribution.computeMaxJointDistribution(v);
    }

    private static void subComputeMaxJointDistribution(float v, float p, Vector dists, int index, Distribution output) {
        if (index < dists.size()) {
            Distribution d = (Distribution)dists.elementAt(index);
            Enumeration e = d.elements();
            while (e.hasMoreElements()) {
                float nv = ((Float)e.nextElement()).floatValue();
                float np = ((Float)e.nextElement()).floatValue();
                float fv = v > nv ? v : nv;
                Distribution.subComputeMaxJointDistribution(fv, p * np, dists, index + 1, output);
            }
        } else {
            output.appendTerm(new Float(v), new Float(p));
            output.compact();
        }
    }

    public static Distribution computeMinJointDistribution(Vector v) {
        Distribution newd = new Distribution();
        Distribution.subComputeMinJointDistribution(2.1474836E9f, 1.0f, v, 0, newd);
        newd.compact();
        return newd;
    }

    public static Distribution computeMinJointDistribution(Distribution d1, Distribution d2) {
        Vector<Distribution> v = new Vector<Distribution>();
        v.addElement(d1);
        v.addElement(d2);
        return Distribution.computeMinJointDistribution(v);
    }

    private static void subComputeMinJointDistribution(float v, float p, Vector dists, int index, Distribution output) {
        if (index < dists.size()) {
            Distribution d = (Distribution)dists.elementAt(index);
            Enumeration e = d.elements();
            while (e.hasMoreElements()) {
                float nv = ((Float)e.nextElement()).floatValue();
                float np = ((Float)e.nextElement()).floatValue();
                float fv = v < nv ? v : nv;
                Distribution.subComputeMinJointDistribution(fv, p * np, dists, index + 1, output);
            }
        } else {
            output.appendTerm(new Float(v), new Float(p));
            output.compact();
        }
    }

    public void compact() {
        for (int i = 0; i < this.size(); i += 2) {
            Float value = (Float)this.elementAt(i);
            Float prob = (Float)this.elementAt(i + 1);
            for (int j = this.size() - 2; j > i; j -= 2) {
                Float v = (Float)this.elementAt(j);
                if (!value.equals(v)) continue;
                Float p = (Float)this.elementAt(j + 1);
                prob = new Float(prob.floatValue() + p.floatValue());
                this.removeElementAt(j + 1);
                this.removeElementAt(j);
            }
            this.setElementAt(prob, i + 1);
        }
    }

    public void normalize() {
        Enumeration e = this.elements();
        float totalprob = 0.0f;
        while (e.hasMoreElements()) {
            e.nextElement();
            totalprob += ((Float)e.nextElement()).floatValue();
        }
        for (int i = 1; i < this.size(); i += 2) {
            Float prob = (Float)this.elementAt(i);
            this.setElementAt(new Float(prob.floatValue() / totalprob), i);
        }
    }

    public void cluster(int pointsNumber) {
        this.compact();
        Distribution original = (Distribution)this.clone();
        if (pointsNumber >= this.size() / 2) {
            return;
        }
        this.removeAllElements();
        if (pointsNumber == 1) {
            this.appendTerm(new Float(original.calculateMostLikely()), new Float(1.0f));
        } else if (pointsNumber == 2) {
            float minVal = original.calculateMin();
            float minDis = original.findValue(original.calculateMin());
            float avgVal = original.calculateMostLikely();
            float avgDis = original.findValue(original.calculateMostLikely());
            float maxVal = original.calculateMax();
            float maxDis = original.findValue(original.calculateMax());
            if (minDis > maxDis) {
                this.appendTerm(new Float(minVal), new Float(minDis));
                this.appendTerm(new Float(avgVal), new Float(1.0f - minDis));
            } else {
                this.appendTerm(new Float(avgVal), new Float(1.0f - maxDis));
                this.appendTerm(new Float(maxVal), new Float(maxDis));
            }
            this.compact();
        } else {
            float minValue = original.calculateMin();
            float maxValue = original.calculateMax();
            float mostLikelyValue = original.calculateMostLikely();
            this.appendTerm(new Float(minValue), new Float(0.0f));
            this.appendTerm(new Float(maxValue), new Float(0.0f));
            this.appendTerm(new Float(mostLikelyValue), new Float(0.0f));
            original.sortByDistribution();
            int k = 3;
            for (int i = original.size() - 2; i > 0 && k < pointsNumber; i -= 2) {
                float val = ((Float)original.elementAt(i)).floatValue();
                if (val == minValue || val == maxValue || val == mostLikelyValue) continue;
                this.appendTerm(new Float(val), new Float(0.0f));
                ++k;
            }
            this.compact();
            this.sortByValue();
            for (int j = 0; j < original.size(); j += 2) {
                float delta2 = Float.MAX_VALUE;
                boolean found_right_bucket = false;
                float movedVal = ((Float)original.elementAt(j)).floatValue();
                float movedDis = ((Float)original.elementAt(j + 1)).floatValue();
                float prevBucketDis = 0.0f;
                float bucketVal = 0.0f;
                float bucketDis = 0.0f;
                for (int i = 0; !found_right_bucket && i < this.size(); i += 2) {
                    if (i > 0) {
                        prevBucketDis = ((Float)this.elementAt(i - 1)).floatValue();
                    }
                    bucketVal = ((Float)this.elementAt(i)).floatValue();
                    bucketDis = ((Float)this.elementAt(i + 1)).floatValue();
                    float delta1 = bucketVal - movedVal;
                    if (delta1 < 0.0f) {
                        delta1 *= -1.0f;
                    }
                    if (delta1 == delta2) {
                        this.setElementAt(new Float(prevBucketDis + movedDis / 2.0f), i - 1);
                        this.setElementAt(new Float(bucketDis + movedDis / 2.0f), i + 1);
                        found_right_bucket = true;
                    } else if (delta1 > delta2) {
                        this.setElementAt(new Float(prevBucketDis + movedDis), i - 1);
                        found_right_bucket = true;
                    }
                    delta2 = delta1;
                }
                if (found_right_bucket) continue;
                bucketDis = ((Float)this.elementAt(this.size() - 1)).floatValue();
                this.setElementAt(new Float(bucketDis + movedDis), this.size() - 1);
            }
        }
    }

    public void sort() {
        this.sortByValue();
    }

    public void sortByValue() {
        Enumeration e = this.elements();
        Float frequency = new Float(0.0f);
        for (int i = 0; i < this.size() - 2; i += 2) {
            int enumr = i;
            Float value = (Float)this.elementAt(enumr);
            for (int j = i; j < this.size(); j += 2) {
                if (!(((Float)this.elementAt(j)).floatValue() < value.floatValue())) continue;
                enumr = j;
                value = (Float)this.elementAt(enumr);
                frequency = (Float)this.elementAt(enumr + 1);
            }
            if (i == enumr) continue;
            this.setElementAt(this.elementAt(i), enumr);
            this.setElementAt(this.elementAt(i + 1), enumr + 1);
            this.setElementAt(value, i);
            this.setElementAt(frequency, i + 1);
        }
    }

    public void sortByDistribution() {
        Enumeration e = this.elements();
        Float value = new Float(0.0f);
        for (int i = 0; i < this.size() - 2; i += 2) {
            int enumr = i;
            Float frequency = (Float)this.elementAt(enumr + 1);
            for (int j = i; j < this.size(); j += 2) {
                if (!(((Float)this.elementAt(j + 1)).floatValue() < frequency.floatValue())) continue;
                enumr = j;
                value = (Float)this.elementAt(enumr);
                frequency = (Float)this.elementAt(enumr + 1);
            }
            if (i == enumr) continue;
            this.setElementAt(this.elementAt(i), enumr);
            this.setElementAt(this.elementAt(i + 1), enumr + 1);
            this.setElementAt(value, i);
            this.setElementAt(frequency, i + 1);
        }
    }

    public boolean equals(Distribution d) {
        if (d == null) {
            return false;
        }
        if (this.size() != d.size()) {
            return false;
        }
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Float value = (Float)e.nextElement();
            Float prob = (Float)e.nextElement();
            boolean found = false;
            for (int i = 0; i < d.size(); i += 2) {
                Float dvalue = (Float)d.elementAt(i);
                Float dprob = (Float)d.elementAt(i + 1);
                if (!value.equals(dvalue) || !prob.equals(dprob)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public double compare(Distribution b) {
        return this.compare(this, b);
    }

    private double compare(Distribution a, Distribution b) {
        Double tmpval;
        double tmpval2;
        int i;
        double accumval = 0.0;
        double accsum = 0.0;
        Hashtable accumhash0 = new Hashtable();
        Hashtable accumhash1 = new Hashtable();
        Hashtable hash0 = a.getHashtable();
        Hashtable hash1 = b.getHashtable();
        Distribution listOfAllValues = a.appendDistribution(b);
        listOfAllValues.compact();
        listOfAllValues.sortByValue();
        for (i = 0; i < listOfAllValues.size(); i += 2) {
            if (hash0.containsKey(listOfAllValues.elementAt(i))) {
                tmpval2 = ((Float)hash0.get(listOfAllValues.elementAt(i))).doubleValue();
                accsum += tmpval2;
            }
            accumhash0.put(listOfAllValues.elementAt(i), new Double(accsum));
        }
        accsum = 0.0;
        for (i = 0; i < listOfAllValues.size(); i += 2) {
            if (hash1.containsKey(listOfAllValues.elementAt(i))) {
                tmpval2 = ((Float)hash1.get(listOfAllValues.elementAt(i))).doubleValue();
                accsum += tmpval2;
            }
            accumhash1.put(listOfAllValues.elementAt(i), new Double(accsum));
        }
        Enumeration e = accumhash0.keys();
        while (e.hasMoreElements()) {
            Float tmpkey = (Float)e.nextElement();
            tmpval = (Double)accumhash0.get(tmpkey);
        }
        e = accumhash1.keys();
        while (e.hasMoreElements()) {
            Float tmpkey = (Float)e.nextElement();
            tmpval = (Double)accumhash1.get(tmpkey);
        }
        double finalsum = 0.0;
        for (int i2 = 0; i2 < listOfAllValues.size() - 2; i2 += 2) {
            double intersum = Math.abs((Double)accumhash0.get(listOfAllValues.elementAt(i2)) - (Double)accumhash1.get(listOfAllValues.elementAt(i2)));
            double intersum2 = (((Float)listOfAllValues.elementAt(i2 + 2)).doubleValue() - ((Float)listOfAllValues.elementAt(i2)).doubleValue()) * intersum;
            finalsum += intersum2;
        }
        double lastdiv = ((Float)listOfAllValues.elementAt(listOfAllValues.size() - 2)).doubleValue() - ((Float)listOfAllValues.firstElement()).doubleValue();
        double distance = finalsum / lastdiv;
        return distance;
    }

    public String output() {
        StringBuffer sb = new StringBuffer("");
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            float n1 = ((Float)e.nextElement()).floatValue();
            if (!e.hasMoreElements()) {
                return "Error";
            }
            float n2 = ((Float)e.nextElement()).floatValue();
            sb.append(n1);
            sb.append(" ");
            sb.append(n2);
            if (!e.hasMoreElements()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }
}

