/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import utilities.UTimer;

public class BetterArea
extends Area {
    static int default_depth = 6;
    static Hashtable CLists = new Hashtable();
    static BetterArea junk = new BetterArea();
    int depth;
    private static double temparea;
    protected boolean include_partials = true;
    protected boolean use_intersects = false;
    protected boolean use_contains_cache = true;
    private Hashtable ccache = new Hashtable();
    int containscount = 0;
    int hitcount = 0;
    int misscount = 0;
    boolean printcachestats = false;

    public BetterArea() {
        this.depth = default_depth;
    }

    public BetterArea(Shape s) {
        super(s);
        this.depth = default_depth;
    }

    protected static CListElement calculateControlList(int depth) {
        depth = Math.min(depth, 16);
        int wall = 1 << depth;
        BetterArea betterArea = junk;
        betterArea.getClass();
        CListElement parent = betterArea.new CListElement(0, 0, wall, wall);
        parent.next = BetterArea.calculateControlList(parent, 1, depth);
        parent.skip = null;
        return parent;
    }

    protected static CListElement calculateControlList(CListElement parent, int curdepth, int maxdepth) {
        if (curdepth > maxdepth) {
            return parent.skip;
        }
        int neww = parent.w >> 1;
        int newh = parent.h >> 1;
        if (neww == 0 || newh == 0) {
            return parent.skip;
        }
        BetterArea betterArea = junk;
        betterArea.getClass();
        CListElement e11 = betterArea.new CListElement(parent.x, parent.y, neww, newh);
        BetterArea betterArea2 = junk;
        betterArea2.getClass();
        CListElement e12 = betterArea2.new CListElement(parent.x + neww, parent.y, neww, newh);
        BetterArea betterArea3 = junk;
        betterArea3.getClass();
        CListElement e21 = betterArea3.new CListElement(parent.x, parent.y + newh, neww, newh);
        BetterArea betterArea4 = junk;
        betterArea4.getClass();
        CListElement e22 = betterArea4.new CListElement(parent.x + neww, parent.y + newh, neww, newh);
        e11.skip = e12;
        e12.skip = e21;
        e21.skip = e22;
        e22.skip = parent.skip;
        e11.next = BetterArea.calculateControlList(e11, curdepth + 1, maxdepth);
        e12.next = BetterArea.calculateControlList(e12, curdepth + 1, maxdepth);
        e21.next = BetterArea.calculateControlList(e21, curdepth + 1, maxdepth);
        e22.next = BetterArea.calculateControlList(e22, curdepth + 1, maxdepth);
        return e11;
    }

    protected static CListElement getCList(int depth) {
        CListElement e = (CListElement)CLists.get(new Integer(depth));
        if (e == null) {
            e = BetterArea.calculateControlList(depth);
            CLists.put(new Integer(depth), e);
        }
        return e;
    }

    public static void main(String[] args) {
        int temp;
        int i;
        Ellipse2D.Double e = new Ellipse2D.Double(10.0, 10.0, 20.0, 20.0);
        final BetterArea b = new BetterArea(e);
        System.out.println("circle of radius 10.0 - ");
        System.out.println("include_partials: true");
        b.include_partials = true;
        for (i = 0; i <= 7; ++i) {
            temp = i;
            b.printcachestats = true;
            UTimer.time(100, new UTimer("findArea with partials"){

                public void action() {
                    b.setDepth(temp);
                    temparea = b.findArea();
                    b.flushCache();
                    b.printcachestats = false;
                }
            }, true);
            System.out.println("  computed area with depth of " + i + ": " + temparea);
        }
        System.out.println("include_partials: false");
        b.include_partials = false;
        for (i = 0; i <= 7; ++i) {
            temp = i;
            b.printcachestats = true;
            UTimer.time(100, new UTimer("findArea without partials"){

                public void action() {
                    b.setDepth(temp);
                    temparea = b.findArea();
                    b.flushCache();
                    b.printcachestats = false;
                }
            }, true);
            System.out.println("computed area with depth of " + i + ": " + temparea + "\n");
        }
        System.out.println("actual area: 314.1592653589793");
    }

    public void setDepth(int i) {
        this.depth = i;
    }

    public int getDepth() {
        return this.depth;
    }

    public double findArea() {
        if (this.isEmpty()) {
            return 0.0;
        }
        CListElement clist = BetterArea.getCList(this.getDepth());
        Rectangle2D bounds = this.getBounds2D();
        double scalex = bounds.getWidth() / (double)clist.w;
        double scaley = bounds.getHeight() / (double)clist.h;
        CListElement cur = clist;
        double total = 0.0;
        while (cur != null) {
            double addval;
            Rectangle2D rect = cur.getRectangle(scalex, scaley, bounds.getX(), bounds.getY());
            if (this.checkContains(rect)) {
                addval = rect.getWidth() * rect.getHeight();
                total += addval;
                cur = cur.skip;
                continue;
            }
            if (this.include_partials && cur.next == cur.skip && this.checkIntersects(rect)) {
                addval = rect.getWidth() * rect.getHeight();
                total += addval;
                cur = cur.skip;
                continue;
            }
            cur = cur.next;
        }
        return total;
    }

    protected boolean checkContains(Rectangle2D rect) {
        if (this.use_intersects) {
            return this.contains(rect);
        }
        double x1 = rect.getX();
        double x2 = x1 + rect.getWidth();
        double y1 = rect.getY();
        double y2 = y1 + rect.getHeight();
        if (this.use_contains_cache) {
            if (!this.containsCacheing(x1, y1)) {
                return false;
            }
            if (!this.containsCacheing(x2, y1)) {
                return false;
            }
            if (!this.containsCacheing(x1, y2)) {
                return false;
            }
            if (!this.containsCacheing(x2, y2)) {
                return false;
            }
        } else {
            if (!this.contains(x1, y1)) {
                return false;
            }
            if (!this.contains(x2, y1)) {
                return false;
            }
            if (!this.contains(x1, y2)) {
                return false;
            }
            if (!this.contains(x2, y2)) {
                return false;
            }
        }
        return true;
    }

    protected void flushCache() {
        if (this.ccache.size() > 0) {
            this.printCacheStats();
            this.ccache = new Hashtable();
            this.containscount = 0;
            this.hitcount = 0;
            this.misscount = 0;
        }
    }

    protected void printCacheStats() {
        if (this.printcachestats && (this.hitcount > 0 || this.misscount > 0)) {
            System.out.println("point cache hits: " + this.hitcount + ", misses: " + this.misscount);
        }
    }

    protected boolean containsCacheing(double x, double y) {
        Point p = new Point((int)x, (int)y);
        if (this.ccache.containsKey(p)) {
            ++this.hitcount;
            return (Boolean)this.ccache.get(p);
        }
        ++this.misscount;
        boolean b = this.contains(x, y);
        this.ccache.put(p, new Boolean(b));
        return b;
    }

    protected boolean checkIntersects(Rectangle2D rect) {
        if (this.use_intersects) {
            return this.intersects(rect);
        }
        double x1 = rect.getX();
        double x2 = x1 + rect.getWidth();
        double y1 = rect.getY();
        double y2 = y1 + rect.getHeight();
        if (this.use_contains_cache) {
            if (this.containsCacheing(x1, y1)) {
                return true;
            }
            if (this.containsCacheing(x2, y1)) {
                return true;
            }
            if (this.containsCacheing(x1, y2)) {
                return true;
            }
            if (this.containsCacheing(x2, y2)) {
                return true;
            }
        } else {
            if (this.contains(x1, y1)) {
                return true;
            }
            if (this.contains(x2, y1)) {
                return true;
            }
            if (this.contains(x1, y2)) {
                return true;
            }
            if (this.contains(x2, y2)) {
                return true;
            }
        }
        return false;
    }

    public void add(Area rhs) {
        this.flushCache();
        super.add(rhs);
    }

    public void exclusiveOr(Area rhs) {
        this.flushCache();
        super.add(rhs);
    }

    public void intersect(Area rhs) {
        this.flushCache();
        super.intersect(rhs);
    }

    public void reset() {
        this.flushCache();
        super.reset();
    }

    public void subtract(Area rhs) {
        this.flushCache();
        super.subtract(rhs);
    }

    public void transform(AffineTransform t) {
        this.flushCache();
        super.transform(t);
    }

    public void dumpPath() {
        PathIterator i = this.getPathIterator(null);
        int winding = i.getWindingRule();
        float[] array = new float[6];
        System.err.println("dumping path:");
        System.err.println("winding " + winding);
        while (!i.isDone()) {
            int whereto = i.currentSegment(array);
            if (whereto == 4) {
                System.err.println("  SEG_CLOSE");
            } else if (whereto == 0) {
                System.err.println("  SEG_MOVETO: " + array[0] + ", " + array[1]);
            } else if (whereto == 1) {
                System.err.println("  SEG_LINETO: " + array[0] + ", " + array[1]);
            } else if (whereto == 2) {
                System.err.println("  SEG_QUADTO: " + array[0] + ", " + array[1] + ", " + array[2] + ", " + array[3]);
            } else if (whereto == 3) {
                System.err.println("  SEG_CUBICTO: " + array[0] + ", " + array[1] + ", " + array[2] + ", " + array[3] + ", " + array[4] + ", " + array[5]);
            }
            i.next();
        }
        System.err.println("done");
    }

    public Iterator getClosedSubpaths() {
        PathIterator i = this.getPathIterator(null);
        Vector<Path2D> subshapes = new Vector<Path2D>();
        int winding = i.getWindingRule();
        Path2D cur = null;
        float[] pathstart = null;
        while (!i.isDone()) {
            float[] array = new float[6];
            boolean close = false;
            int whereto = i.currentSegment(array);
            if (whereto == 4) {
                if (cur != null) {
                    cur.closePath();
                }
                close = true;
            } else {
                if (whereto == 0) {
                    pathstart = array;
                    cur = new GeneralPath(winding);
                    ((Path2D.Float)cur).moveTo(array[0], array[1]);
                    i.next();
                    continue;
                }
                if (cur == null) {
                    System.err.println("WARNING: path without moveto - there'llprobably be an exception soon");
                    cur = new GeneralPath(winding);
                }
                if (whereto == 1) {
                    ((Path2D.Float)cur).lineTo(array[0], array[1]);
                } else if (whereto == 2) {
                    ((Path2D.Float)cur).quadTo(array[0], array[1], array[2], array[3]);
                } else if (whereto == 3) {
                    ((Path2D.Float)cur).curveTo(array[0], array[1], array[2], array[3], array[4], array[5]);
                }
                if (pathstart == null) {
                    pathstart = array;
                }
            }
            if (close && cur != null) {
                subshapes.add(cur);
                cur = null;
                close = false;
            }
            i.next();
        }
        return subshapes.iterator();
    }

    public boolean hasMultipleClosedSubpaths() {
        float[] pathstart = new float[6];
        float[] array = new float[6];
        PathIterator i = this.getPathIterator(null);
        int count = 0;
        while (!i.isDone()) {
            int whereto = i.currentSegment(array);
            if (whereto == 0) {
                i.currentSegment(pathstart);
            } else if (whereto == 4) {
                ++count;
            } else {
                boolean equal = true;
                for (int c = 0; c < pathstart.length; ++c) {
                    if (array[c] == pathstart[c]) continue;
                    equal = false;
                    break;
                }
                if (equal) {
                    ++count;
                }
            }
            if (count > 1) {
                return true;
            }
            i.next();
        }
        return false;
    }

    public Object clone() {
        Object o = super.clone();
        return new BetterArea((Shape)o);
    }

    static {
        CLists.put(new Integer(default_depth), BetterArea.calculateControlList(default_depth));
        temparea = 0.0;
    }

    protected class CListElement {
        public int x;
        public int y;
        public int w;
        public int h;
        public CListElement next = null;
        public CListElement skip = null;

        public CListElement(int tx, int ty, int tw, int th) {
            this.x = tx;
            this.y = ty;
            this.w = tw;
            this.h = th;
        }

        public Rectangle2D getRectangle(double scalex, double scaley, double x1, double y1) {
            double tx = (double)this.x * scalex + x1;
            double ty = (double)this.y * scaley + y1;
            double tw = (double)this.w * scalex;
            double th = (double)this.h * scaley;
            return new Rectangle2D.Double(tx, ty, tw, th);
        }

        public Rectangle2D getRectangle(double scalex, double scaley) {
            return this.getRectangle(scalex, scaley, 0.0, 0.0);
        }

        public String toStringWithoutLinks() {
            return new String("x " + this.x + ", y " + this.y + ", w " + this.w + ", h " + this.h);
        }

        public String toString() {
            String s = this.toStringWithoutLinks();
            s = new String(s + ", next [");
            s = this.next == null ? new String(s + "null], skip [") : new String(s + this.next.toStringWithoutLinks() + "], skip [");
            s = this.skip == null ? new String(s + "null]") : new String(s + this.skip.toStringWithoutLinks() + "]");
            return s;
        }
    }
}

