/*
 * Decompiled with CFR 0.152.
 */
package taems.preprocessor;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import taems.preprocessor.Block;
import taems.preprocessor.DefineBlock;
import taems.preprocessor.PreProcessor;

public class randomFunction
extends Block {
    public static final RandomValue FLOAT = new RandomValue(0);
    public static final RandomValue INT = new RandomValue(1);
    protected static Random r;
    protected RandomValue type;
    protected Object l;
    protected Object h;

    public randomFunction(PreProcessor p, RandomValue r, Object l, Object h) {
        super(p);
        this.type = r;
        this.l = l;
        this.h = h;
    }

    public String toPTaems() {
        String answer = "#random(";
        Enumeration e = this.getSubBlocks();
        while (e.hasMoreElements()) {
            Block b = (Block)e.nextElement();
            answer = answer + b.toPTaems();
        }
        return answer + ")";
    }

    public void reset() {
        r = null;
    }

    public String toTTaems(Hashtable ht) {
        return " " + this.nextNumber(ht).toString();
    }

    public Object nextNumber(Hashtable ht) {
        Number answer = new Integer(0);
        int il = 0;
        int ih = 0;
        float fl = 0.0f;
        float fh = 0.0f;
        String sl = this.l instanceof Block ? ((Block)this.l).toTTaems(ht) : this.l.toString();
        String sh = this.h instanceof Block ? ((Block)this.h).toTTaems(ht) : this.h.toString();
        if (this.type.equals(INT)) {
            il = (int)Float.valueOf(sl.toString()).floatValue();
            ih = (int)Float.valueOf(sh.toString()).floatValue();
        } else {
            fl = Float.valueOf(sl.toString()).floatValue();
            fh = Float.valueOf(sh.toString()).floatValue();
        }
        if (r == null) {
            r = new Random();
            if (ht.containsKey("RandomSeed")) {
                long seed = (Long)ht.get("RandomSeed");
                r.setSeed(seed);
            } else if (this.preprocessor.getVarReference("RandomSeed") != null) {
                String tmpString = (String)((DefineBlock)this.preprocessor.getVarReference("RandomSeed")).evaluate(ht);
                try {
                    Long tmplong = new Long(tmpString);
                    r.setSeed(tmplong);
                    System.err.println("Warning, I used the seed defined in the PTAEMS file");
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Sorry I can't convert " + tmpString + " in a seed for the random generator is it normal ?");
                    System.err.println("Warning, I don't have a seed for the random engine, (not DETERMINISTIC)");
                }
            } else {
                System.err.println("Warning, I don't have a seed for the random engine, (not DETERMINISTIC)");
            }
        }
        if (this.type.equals(FLOAT)) {
            answer = fh - fl != 0.0f ? new Float(Math.abs(r.nextFloat() * 100000.0f) % (fh - fl) + fl) : new Float(ih);
        }
        if (this.type.equals(INT)) {
            answer = ih - il != 0 ? new Integer(Math.abs(r.nextInt()) % (ih - il) + il) : new Integer(ih);
        }
        return answer;
    }

    public static class RandomValue
    implements Serializable {
        private int _value;

        private RandomValue(int value) {
            this._value = value;
        }

        private int asInt() {
            return this._value;
        }

        public int hashCode() {
            return this.asInt();
        }

        public boolean equals(Object obj) {
            boolean ret;
            boolean bl = ret = obj == this;
            if (!ret && obj != null && obj instanceof RandomValue) {
                ret = ((RandomValue)obj).asInt() == this.asInt();
            }
            return ret;
        }
    }
}

