/*
 * Decompiled with CFR 0.152.
 */
package taems.parser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JFrame;
import taems.Taems;
import taems.parser.ReadTTaems;
import utilities.Log;

public class ParserTest {
    private ReadTTaems reader = null;
    private static final int INITIAL_WIDTH = 500;
    private static final int INITIAL_HEIGHT = 400;

    public ParserTest(Log log) {
        this.reader = new ReadTTaems(log);
    }

    public static void main(String[] argv) {
        String input_script = null;
        String output_file = null;
        String log_file = null;
        Object file_name = null;
        boolean display = false;
        boolean silent = false;
        boolean nooutput = false;
        Taems task = null;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-if")) {
                input_script = argv[++i];
                continue;
            }
            if (argv[i].equals("-of")) {
                output_file = argv[++i];
                continue;
            }
            if (argv[i].equals("-lf")) {
                log_file = argv[++i];
                continue;
            }
            if (argv[i].equals("-no")) {
                nooutput = true;
                continue;
            }
            if (argv[i].equals("-display")) {
                display = true;
                continue;
            }
            if (argv[i].equals("-silent")) {
                silent = true;
                continue;
            }
            if (argv[i].equals("-verbose")) {
                silent = false;
                continue;
            }
            if (argv[i].startsWith("-")) continue;
            input_script = argv[i];
            break;
        }
        Log genlog = null;
        try {
            if (log_file == null) {
                if (silent) {
                    try {
                        genlog = new Log((OutputStream)new FileOutputStream("/dev/null"), 0);
                    }
                    catch (Exception ex) {
                        System.err.println("Error using silent mode, reverting to verbose");
                        ex.printStackTrace();
                        silent = false;
                    }
                }
                if (!silent) {
                    genlog = new Log((OutputStream)System.err, 5);
                }
            } else {
                genlog = new Log((OutputStream)new FileOutputStream(log_file), 5);
            }
            Log.setDefault(genlog);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex);
        }
        ParserTest pt = new ParserTest(genlog);
        if (input_script == null) {
            ParserTest.showTaems(new Taems());
        } else {
            genlog.log("Reading textual taems file");
            try {
                task = pt.reader.readTTaems(input_script);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println(e);
            }
            if (task == null) {
                System.err.println("Error reading structure from " + input_script);
            }
            task.retargetAttributes();
            genlog.log("Textual taems file read!");
            if (!nooutput) {
                FileOutputStream f2;
                try {
                    if (output_file == null) {
                        f2 = new FileOutputStream("ttaems_read-1.0");
                        genlog.log("Textual taems file re-printed in ttaems_read-1.0");
                    } else {
                        f2 = new FileOutputStream(output_file + "-1.0");
                        genlog.log("Textual taems file re-printed in " + output_file + "-1.0");
                    }
                    if (f2 != null) {
                        if (task != null) {
                            f2.write(task.toTTaems(1.0f).getBytes());
                        } else {
                            System.out.println("Read_in is null :(");
                        }
                    }
                    f2.close();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    System.err.println(exc);
                }
                try {
                    if (output_file == null) {
                        f2 = new FileOutputStream("ttaems_read-1.0A");
                        genlog.log("Textual taems file re-printed in ttaems_read-1.0A");
                    } else {
                        f2 = new FileOutputStream(output_file + "-1.0A");
                        genlog.log("Textual taems file re-printed in " + output_file + "-1.0A");
                    }
                    if (f2 != null) {
                        if (task != null) {
                            f2.write(task.toTTaems(1.01f).getBytes());
                        } else {
                            System.out.println("Read_in is null :(");
                        }
                    }
                    f2.close();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    System.err.println(exc);
                }
                try {
                    if (output_file == null) {
                        f2 = new FileOutputStream("ttaems_read-1.1");
                        genlog.log("Textual taems file re-printed in ttaems_read-1.1");
                    } else {
                        f2 = new FileOutputStream(output_file + "-1.1");
                        genlog.log("Textual taems file re-printed in " + output_file + "-1.1");
                    }
                    if (f2 != null) {
                        if (task != null) {
                            f2.write(task.toTTaems(1.1f).getBytes());
                        } else {
                            System.out.println("Read_in is null :(");
                        }
                    }
                    f2.close();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    System.err.println(exc);
                }
            }
            if (display) {
                ParserTest.showTaems(task);
            } else {
                System.exit(0);
            }
        }
    }

    public static void showTaems(Taems t) {
        JFrame frame = new JFrame("Taems");
        frame.setSize(500, 400);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2 - 250, screenSize.height / 2 - 200);
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().add((Component)t, "Center");
        frame.setVisible(true);
    }
}

