/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import taems.Agent;
import taems.Commitment;
import taems.ConsumableResource;
import taems.ConsumesInterrelationship;
import taems.Criteria;
import taems.DisablesInterrelationship;
import taems.EnablesInterrelationship;
import taems.FacilitatesInterrelationship;
import taems.HindersInterrelationship;
import taems.Interrelationship;
import taems.LimitsInterrelationship;
import taems.MLCSchedule;
import taems.Method;
import taems.Node;
import taems.NodeFinderEnumeration;
import taems.NodeUpdateEvent;
import taems.NodeUpdateEventListener;
import taems.NonConsumableResource;
import taems.Outcome;
import taems.PrecedencePrecondition;
import taems.Precondition;
import taems.ProducesInterrelationship;
import taems.QAF;
import taems.Resource;
import taems.Schedule;
import taems.ScheduleElement;
import taems.SumQAF;
import taems.Task;
import taems.TaskBase;
import taems.VirtualMethod;
import taems.VirtualNode;
import taems.VirtualResource;
import taems.VirtualTaskBase;
import taems.parser.ReadTTaems;
import utilities.Converter;
import utilities.Distribution;
import utilities.Log;
import utilities.SafeEnumeration;
import utilities.VFlowLayout;

public class Taems
extends JPanel
implements Serializable,
Cloneable,
NodeUpdateEventListener {
    public static final float V1 = 1.0f;
    public static final float V1_0 = 1.0f;
    public static final float V1_0A = 1.01f;
    public static final float V1_1 = 1.1f;
    public static final float VCUR = 1.1f;
    public static final String EXHAUSTIVE_PRUNED_ALTERNATIVES = "exhaustive_from_pruned_alternatives";
    public static final String EXHAUSTIVE_ALTERNATIVES = "exhaustive_from_alternatives";
    public static final String EXHAUSTIVE = "pure_exhaustive";
    public static final String HEURISTIC = "heuristic";
    protected Vector nodes = new Vector();
    protected Vector agents = new Vector(1);
    protected Hashtable attributes = new Hashtable();
    protected Vector schedules = null;
    protected Vector commitments = new Vector();
    protected Criteria criteria;
    protected Log log = Log.getDefault();
    protected transient Vector listeners = new Vector();
    protected transient boolean replace = true;
    protected transient boolean revalue = true;
    protected static transient boolean printing = false;
    private Integer addLock = new Integer(0);
    private Object last_attrib;
    private Outcome last_outcome;
    private String last_selectnode;
    protected static final int H_SPACE = 50;
    protected static final int V_SPACE = 50;
    protected static final int H_MARGIN = 50;
    protected static final int V_MARGIN = 50;
    TaemsCanvas display;
    JScrollPane scroll;

    public Taems(String l, Agent a) {
        this.initGraphics();
        this.setLabel(l);
        this.setAgent(a);
        this.addNodeUpdateEventListener(this);
    }

    public Taems(String l) {
        this(l, null);
    }

    public Taems() {
        this((String)null);
    }

    public String getLabel() {
        return (String)this.getAttribute("label");
    }

    public void setLabel(String l) {
        if (this.getLabel() != null && this.getLabel().equals(l)) {
            return;
        }
        this.setAttribute("label", l);
        if (l == null) {
            l = "";
        }
    }

    public void setSchedulingMode(String s) {
        this.setAttribute("scheduling_mode", s);
    }

    public String getSchedulingMode() {
        return (String)this.getAttribute("scheduling_mode");
    }

    public void setPruningSetting(String s) {
        this.setAttribute("pruning_setting", s);
    }

    public String getPruningSetting() {
        return (String)this.getAttribute("pruning_setting");
    }

    public Agent getAgent() {
        if (this.numAgents() > 0) {
            return (Agent)this.agents.firstElement();
        }
        return null;
    }

    public void setAgent(Agent a) {
        if (this.numAgents() > 0) {
            this.removeAgent(this.getAgent());
        }
        if (a != null) {
            this.agents.insertElementAt(a, 0);
        }
    }

    public Enumeration getAgents() {
        return this.agents.elements();
    }

    public void addAgent(Agent a) {
        if (a != null && this.findAgent(a) == null) {
            this.agents.addElement(a);
            this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
        }
    }

    public void removeAgent(Agent a) {
        if (a != null) {
            this.agents.removeElement(a);
            this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
        }
    }

    public int numAgents() {
        return this.agents.size();
    }

    public Agent findAgent(Agent a) {
        Enumeration e = this.getAgents();
        while (e.hasMoreElements()) {
            Agent agent = (Agent)e.nextElement();
            if (!agent.matches(a)) continue;
            return agent;
        }
        return null;
    }

    public void setScheduleCriteria(Criteria v) {
        this.criteria = v;
    }

    public Criteria getScheduleCriteria() {
        if (this.criteria != null) {
            return this.criteria;
        }
        return null;
    }

    public void setSchedule(Schedule s) {
        Vector<Schedule> v = new Vector<Schedule>();
        if (s != null) {
            v.addElement(s);
        }
        this.setScheduleVector(v);
    }

    public void setScheduleVector(Vector sv) {
        if (this.numSchedules() > 0 && sv != this.schedules) {
            this.removeAllSchedules();
        }
        this.schedules = sv;
        this.retargetSchedules();
        this.setDisplayedSchedule(this.getFirstSchedule());
    }

    public Vector getScheduleVector() {
        if (this.schedules == null) {
            this.schedules = new Vector();
        }
        return this.schedules;
    }

    public Enumeration getSchedules() {
        return this.getScheduleVector().elements();
    }

    public Schedule getFirstSchedule() {
        if (this.numSchedules() < 1) {
            return null;
        }
        return (Schedule)this.getScheduleVector().firstElement();
    }

    public void setFirstSchedule(Schedule s) {
        if (this.numSchedules() < 1) {
            this.setSchedule(s);
        } else {
            if (!this.schedules.contains(s)) {
                this.addSchedule(s);
            }
            Vector v = this.getScheduleVector();
            v.remove(s);
            v.insertElementAt(s, 0);
            this.setDisplayedSchedule(this.getFirstSchedule());
        }
    }

    public void addSchedule(Schedule s) {
        Vector v = this.getScheduleVector();
        v.addElement(s);
        this.retargetSchedules();
        if (this.numSchedules() <= 1) {
            this.setDisplayedSchedule(this.getFirstSchedule());
        }
    }

    public int numSchedules() {
        return this.getScheduleVector().size();
    }

    public void removeSchedule(Schedule s) {
        if (this.schedules.contains(s)) {
            this.schedules.remove(s);
            Enumeration e = s.getElements();
            while (e.hasMoreElements()) {
                ScheduleElement se = (ScheduleElement)e.nextElement();
                Method m = se.getMethod();
                se.setMethod(new VirtualMethod(m.getLabel(), m.getAgent()));
            }
        }
    }

    public void removeAllSchedules() {
        SafeEnumeration e = new SafeEnumeration(this.getSchedules());
        while (e.hasMoreElements()) {
            Schedule s = (Schedule)e.nextElement();
            this.removeSchedule(s);
        }
    }

    public void setDisplayedSchedule(Schedule s) {
        Enumeration e = this.findNodes(new Method());
        while (e.hasMoreElements()) {
            Method m = (Method)e.nextElement();
            m.setScheduleNumber(-1);
        }
        if (s != null) {
            ScheduleElement old = null;
            e = s.getElements();
            int num = 1;
            while (e.hasMoreElements()) {
                ScheduleElement se = (ScheduleElement)e.nextElement();
                if (old != null && old.getStartTime() != null && se.getStartTime() != null && !se.getStartTime().containsValue(-1.0f, 0.0f) && old.getStartTime().equals(se.getStartTime())) {
                    --num;
                }
                se.getMethod().setScheduleNumber(num);
                old = se;
                ++num;
            }
        }
    }

    public void addCommitment(Commitment c) {
        this.commitments.addElement(c);
        this.retargetCommitments();
    }

    public void removeCommitment(Commitment c) {
        if (this.commitments.contains(c)) {
            this.commitments.removeElement(c);
            Vector<VirtualTaskBase> v = new Vector<VirtualTaskBase>();
            Enumeration e = c.getTasks();
            while (e.hasMoreElements()) {
                TaskBase t = (TaskBase)e.nextElement();
                v.addElement(new VirtualTaskBase(t.getLabel(), t.getAgent()));
            }
            c.setTaskVector(v);
        }
    }

    public void removeAllCommitments() {
        SafeEnumeration e = new SafeEnumeration(this.getCommitments());
        while (e.hasMoreElements()) {
            Commitment c = (Commitment)e.nextElement();
            this.removeCommitment(c);
        }
    }

    public Enumeration getCommitments() {
        return this.commitments.elements();
    }

    public Commitment getCommitment() {
        if (this.numCommitments() > 0) {
            return (Commitment)this.commitments.firstElement();
        }
        return null;
    }

    public Vector getCommitmentVector() {
        return this.commitments;
    }

    public void setCommitmentVector(Vector v) {
        if (this.numCommitments() > 0 && v != this.commitments) {
            this.removeAllCommitments();
        }
        this.commitments = v;
        this.retargetCommitments();
    }

    public int numCommitments() {
        return this.commitments.size();
    }

    public void addNodeUpdateEventListener(NodeUpdateEventListener o) {
        this.listeners.addElement(o);
    }

    public void removeNodeUpdateEventListener(NodeUpdateEventListener o) {
        this.listeners.removeElement(o);
    }

    protected void fireNodeUpdateEvent(NodeUpdateEvent ev) {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            NodeUpdateEventListener l = (NodeUpdateEventListener)e.nextElement();
            switch (ev.getID()) {
                case 0: {
                    l.valueUpdate(ev);
                    break;
                }
                case 1: {
                    l.graphicUpdate(ev);
                    break;
                }
                case 2: {
                    l.placementUpdate(ev);
                    break;
                }
                case 3: {
                    l.placementUpdate(ev);
                }
            }
        }
    }

    public void valueUpdate(NodeUpdateEvent e) {
        if (this.display != null) {
            this.revalue = true;
            this.display.repaint();
        }
    }

    public void graphicUpdate(NodeUpdateEvent e) {
        if (this.display != null) {
            this.display.repaint();
            this.display.updatePreferredSize();
        }
    }

    public void placementUpdate(NodeUpdateEvent e) {
        if (this.display != null) {
            this.replace = true;
            this.display.repaint();
        }
    }

    public void structureUpdate(NodeUpdateEvent e) {
        if (this.display != null) {
            this.retargetVirtuals();
            this.replace = true;
            this.revalue = true;
            this.display.repaint();
        }
    }

    public Object getAttribute(Object k) {
        return this.attributes.get(k.toString());
    }

    public void setAttribute(Object k, Object d) {
        if (d == null) {
            this.removeAttribute(k);
        } else {
            this.attributes.put(k.toString(), d);
        }
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
    }

    public void removeAttribute(Object k) {
        this.attributes.remove(k.toString());
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
    }

    public Enumeration getAttributes() {
        return this.attributes.keys();
    }

    public boolean hasAttribute(Object k) {
        return this.attributes.containsKey(k.toString());
    }

    protected Hashtable getAttributesTable() {
        return this.attributes;
    }

    public void addNode(Node n) {
        if (n == null) {
            return;
        }
        if (this.nodes.contains(n)) {
            this.log.log("Warning: You just addded the node " + n.getLabel() + " to a Taems object that already had it", 1);
        }
        this.nodes.addElement(n);
        n.addNodeUpdateEventListener(this);
        if (n instanceof Interrelationship) {
            this.log.log("***************************************************************", 1);
            this.log.log("Warning: You just addded an Interrelationship to a Taems object", 1);
            this.log.log("While you can technically do this, you will experience wierdness", 1);
            this.log.log("if you do so.  Instead, we recommend you add the from and to", 1);
            this.log.log("nodes to the structure, which will make it much happier. E.g.", 1);
            this.log.log("   BAD: Taems.addNode(Interrelationship);", 1);
            this.log.log("  GOOD: Taems.addNode(Interrelationship.getTo());", 1);
            this.log.log("        Taems.addNode(Interrelationship.getFrom());", 1);
            this.log.log("***************************************************************", 1);
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 2));
    }

    public void removeNode(Node n) {
        this.nodes.removeElement(n);
        n.removeNodeUpdateEventListener(this);
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 2));
    }

    public Node exciseNode(Node n) {
        this.removeNode(n);
        return n.excise();
    }

    public int numResources() {
        int n = 0;
        Enumeration e = this.getNodes();
        while (e.hasMoreElements()) {
            if (!(e.nextElement() instanceof Resource)) continue;
            ++n;
        }
        return n;
    }

    public int numTaskGroups() {
        int n = 0;
        Enumeration e = this.getNodes();
        while (e.hasMoreElements()) {
            Node node = (Node)e.nextElement();
            if (!(node instanceof Task) || !((Task)node).isTaskGroup()) continue;
            ++n;
        }
        return n;
    }

    public Enumeration getNodes() {
        return this.nodes.elements();
    }

    public Enumeration getAllNodes() {
        return this.findNodes(new Node());
    }

    public Task getNode() {
        Enumeration e = this.getNodes();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            if (!(n instanceof Task) || !((Task)n).isTaskGroup()) continue;
            return (Task)n;
        }
        return null;
    }

    public Enumeration findNodes(Node n) {
        return new NodeFinderEnumeration(this.getNodes(), n);
    }

    public Node findNode(Node n) {
        Enumeration e = this.findNodes(n);
        if (e.hasMoreElements()) {
            return (Node)e.nextElement();
        }
        return null;
    }

    public void unionTaems(Taems t) {
        this.unionTaems(t, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unionTaems(Taems t, boolean clone) {
        if (clone) {
            t = (Taems)t.clone();
        }
        Integer n = this.addLock;
        synchronized (n) {
            this.smash();
            t.smash();
            SafeEnumeration oe = new SafeEnumeration(this.getNodes());
            block3: while (oe.hasMoreElements()) {
                Node on = (Node)oe.nextElement();
                if (on.hasInInterrelationships()) continue;
                SafeEnumeration ne = new SafeEnumeration(t.getNodes());
                while (ne.hasMoreElements()) {
                    Node nn = (Node)ne.nextElement();
                    if (on.hasOutInterrelationships()) {
                        Interrelationship ni;
                        if (!nn.hasOutInterrelationships()) continue;
                        Interrelationship oi = (Interrelationship)on.getOutInterrelationships().nextElement();
                        if (oi.matches(ni = (Interrelationship)nn.getOutInterrelationships().nextElement())) {
                            t.removeNode(ni.getTo());
                            t.removeNode(ni.getFrom());
                            continue block3;
                        }
                        if (!Node.matches(ni.getLabel(), oi.getLabel()) || !Node.matches(ni.getAgent(), oi.getAgent())) continue;
                        this.removeNode(oi.getTo());
                        this.removeNode(oi.getFrom());
                        continue block3;
                    }
                    if (nn.hasOutInterrelationships() || nn.hasInInterrelationships()) continue;
                    if (on.matches(nn)) {
                        t.removeNode(nn);
                        continue block3;
                    }
                    if (!Node.matches(nn.getLabel(), on.getLabel()) || !Node.matches(nn.getAgent(), on.getAgent())) continue;
                    this.removeNode(on);
                    continue block3;
                }
            }
            this.addTaems(t, false);
            this.removeOrphans();
        }
    }

    public void importTaems(Taems t) {
        this.importTaems(t, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importTaems(Taems t, boolean clone) {
        if (clone) {
            t = (Taems)t.clone();
        }
        Integer n = this.addLock;
        synchronized (n) {
            this.smash();
            t.smash();
            SafeEnumeration oe = new SafeEnumeration(this.getNodes());
            while (oe.hasMoreElements()) {
                Node on = (Node)oe.nextElement();
                boolean found = false;
                if (on.hasInInterrelationships()) continue;
                SafeEnumeration ne = new SafeEnumeration(t.getNodes());
                while (ne.hasMoreElements()) {
                    Node nn = (Node)ne.nextElement();
                    if (on.hasOutInterrelationships()) {
                        Interrelationship ni;
                        Interrelationship oi;
                        if (!nn.hasOutInterrelationships() || !(oi = (Interrelationship)on.getOutInterrelationships().nextElement()).matches(ni = (Interrelationship)nn.getOutInterrelationships().nextElement())) continue;
                        t.removeNode(ni.getTo());
                        t.removeNode(ni.getFrom());
                        found = true;
                        break;
                    }
                    if (nn.hasOutInterrelationships() || nn.hasInInterrelationships() || !on.matches(nn)) continue;
                    t.removeNode(nn);
                    found = true;
                    break;
                }
                if (found) continue;
                if (on.hasOutInterrelationships()) {
                    Interrelationship oi = (Interrelationship)on.getOutInterrelationships().nextElement();
                    this.removeNode(oi.getTo());
                    this.removeNode(oi.getFrom());
                    continue;
                }
                this.removeNode(on);
            }
            this.addTaems(t, false);
        }
    }

    public synchronized void addTaems(Taems t) {
        this.addTaems(t, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addTaems(Taems t, boolean clone) {
        if (clone) {
            t = (Taems)t.clone();
        }
        Integer n = this.addLock;
        synchronized (n) {
            Enumeration e = t.getAgents();
            while (e.hasMoreElements()) {
                Agent a = (Agent)e.nextElement();
                if (this.findAgent(a) != null) continue;
                this.addAgent(a);
            }
            e = t.findNodes(new Resource());
            while (e.hasMoreElements()) {
                Resource r = (Resource)e.nextElement();
                if (t.nodes.contains(r)) continue;
                t.addNode(r);
            }
            e = t.getNodes();
            while (e.hasMoreElements()) {
                this.mergeNode((Node)e.nextElement());
            }
            e = new SafeEnumeration(t.getSchedules());
            while (e.hasMoreElements()) {
                Schedule s = (Schedule)e.nextElement();
                t.removeSchedule(s);
                this.addSchedule(s);
            }
            if (t.getScheduleCriteria() != null) {
                this.setScheduleCriteria(t.getScheduleCriteria());
            }
            e = new SafeEnumeration(t.getCommitments());
            while (e.hasMoreElements()) {
                Commitment c = (Commitment)e.nextElement();
                t.removeCommitment(c);
                this.addCommitment(c);
            }
            e = t.getAttributes();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object data = t.getAttribute(key);
                if (data instanceof Node) {
                    Node n2 = (Node)data;
                    data = new VirtualNode(n2.getLabel(), n2.getAgent());
                }
                this.setAttribute(key, data);
            }
            this.retargetVirtuals();
        }
    }

    private void mergeNode(Node n) {
        if (n == null) {
            return;
        }
        if (n instanceof Resource) {
            this.mergeResource((Resource)n);
        } else {
            this.addNode(n);
        }
    }

    private void mergeResource(Resource r) {
        Resource or = null;
        Enumeration e = this.getNodes();
        Resource matcher = new Resource(r.getLabel(), null);
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            if (!n.matches(matcher)) continue;
            or = (Resource)n;
            break;
        }
        if (or != null) {
            r.transferInterrelationships(or);
            this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 2));
        } else {
            this.addNode(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Taems removeTaems(Taems t) {
        Taems removed = new Taems();
        Vector toremove = new Vector();
        Integer n = this.addLock;
        synchronized (n) {
            Node n2;
            Enumeration e = t.getAllNodes();
            while (e.hasMoreElements()) {
                toremove.addElement(e.nextElement());
            }
            e = new SafeEnumeration(toremove.elements());
            while (e.hasMoreElements()) {
                n2 = (Node)e.nextElement();
                if (!(n2 instanceof Interrelationship)) continue;
                toremove.removeElement(n2);
                Node matcher = new Node(n2.getLabel(), n2.getAgent());
                Interrelationship i = (Interrelationship)this.unmergeNode(this.findNode(matcher));
                if (i == null) continue;
                removed.addNode(i.getFrom());
                removed.addNode(i.getTo());
            }
            while (!toremove.isEmpty()) {
                e = new SafeEnumeration(toremove.elements());
                while (e.hasMoreElements()) {
                    n2 = (Node)e.nextElement();
                    if (n2 instanceof Task) {
                        boolean ignore = false;
                        Enumeration te = ((Task)n2).getSubtasks();
                        while (te.hasMoreElements()) {
                            TaskBase st = (TaskBase)te.nextElement();
                            if (!toremove.contains(st)) continue;
                            ignore = true;
                            break;
                        }
                        if (ignore) continue;
                    }
                    toremove.removeElement(n2);
                    Node matcher = n2.isVirtual() ? n2 : new Node(n2.getLabel(), n2.getAgent());
                    Node matched = this.findNode(matcher);
                    if (n2 instanceof TaskBase && ((TaskBase)n2).isNonLocal() && matched instanceof TaskBase && !((TaskBase)matched).isNonLocal()) continue;
                    removed.addNode(this.unmergeNode(matched));
                }
            }
        }
        removed.retargetVirtuals();
        return removed;
    }

    private Node unmergeNode(Node n) {
        if (n == null) {
            return n;
        }
        if (n instanceof Resource) {
            return (Node)n.clone();
        }
        this.removeNode(n);
        if (n.hasInterrelationships()) {
            this.addNode(n.excise());
        } else {
            n.excise();
        }
        return n;
    }

    public Object clone() {
        Taems cloned = new Taems(this.getLabel(), this.getAgent());
        this.log.log("Starting Taems clone...", 3);
        cloned.listeners = (Vector)this.listeners.clone();
        if (this.getLabel() != null) {
            cloned.setLabel(new String(this.getLabel()));
        } else {
            cloned.setLabel(null);
        }
        Enumeration e = this.getAgents();
        cloned.agents = new Vector();
        while (e.hasMoreElements()) {
            cloned.addAgent((Agent)((Agent)e.nextElement()).clone());
        }
        e = this.getNodes();
        cloned.nodes = new Vector();
        while (e.hasMoreElements()) {
            cloned.addNode((Node)((Node)e.nextElement()).clone());
        }
        e = this.getSchedules();
        cloned.schedules = new Vector();
        while (e.hasMoreElements()) {
            cloned.addSchedule((Schedule)((Schedule)e.nextElement()).clone());
        }
        if (this.getScheduleCriteria() != null) {
            cloned.setScheduleCriteria((Criteria)this.getScheduleCriteria().clone());
        }
        e = this.getCommitments();
        cloned.commitments = new Vector();
        while (e.hasMoreElements()) {
            cloned.addCommitment((Commitment)((Commitment)e.nextElement()).clone());
        }
        if (this.attributes != null) {
            cloned.attributes = (Hashtable)this.attributes.clone();
        }
        cloned.retargetVirtuals();
        this.log.log("Taems clone finished...", 4);
        return cloned;
    }

    public void copy(Taems t) {
        Enumeration e = this.getAllNodes();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            Node matcher = new Node(n.getLabel(), n.getAgent());
            Node matched = t.findNode(matcher);
            if (matched == null) continue;
            n.copy(matched);
        }
        if (this.attributes != null) {
            t.attributes = (Hashtable)this.attributes.clone();
        }
        t.setLabel(this.getLabel());
    }

    public synchronized void retargetVirtuals() {
        Node matcher;
        Vector<Node> allnodes = new Vector<Node>();
        Vector<Node> virtuals = new Vector<Node>();
        this.log.log("Starting retarget...", 3);
        Enumeration e = new SafeEnumeration(this.getAllNodes());
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            if (n.isVirtual() || n instanceof TaskBase && ((TaskBase)n).isNonLocal()) {
                boolean found = false;
                matcher = new Node(n.getLabel(), n.getAgent());
                Enumeration ve = virtuals.elements();
                while (ve.hasMoreElements()) {
                    Node vn = (Node)ve.nextElement();
                    if (!vn.matches(matcher) && !matcher.matches(vn)) continue;
                    boolean replace = false;
                    found = true;
                    if (n instanceof TaskBase && ((TaskBase)n).isNonLocal()) {
                        if (!(vn instanceof TaskBase) || !((TaskBase)vn).isNonLocal()) {
                            replace = true;
                        }
                    } else if (n instanceof VirtualMethod) {
                        if (vn instanceof VirtualNode || vn instanceof VirtualTaskBase) {
                            replace = true;
                        }
                        if (vn instanceof TaskBase && ((TaskBase)vn).isNonLocal()) {
                            replace = false;
                        }
                    } else if (n instanceof VirtualTaskBase) {
                        if (vn instanceof VirtualNode) {
                            replace = true;
                        }
                    } else if (n instanceof VirtualResource && vn instanceof VirtualNode) {
                        replace = true;
                    }
                    if (replace) {
                        vn.transferInterrelationships(n);
                        if (vn instanceof TaskBase && n instanceof TaskBase) {
                            ((TaskBase)vn).transferSupertasks((TaskBase)n);
                        } else if (vn instanceof Interrelationship && n instanceof Interrelationship) {
                            ((Interrelationship)n).replace((Interrelationship)vn);
                        }
                        virtuals.removeElement(vn);
                        this.removeNode(vn);
                        virtuals.addElement(n);
                        if (this.nodes.contains(n)) break;
                        this.addNode(n);
                        break;
                    }
                    n.transferInterrelationships(vn);
                    if (n instanceof TaskBase && vn instanceof TaskBase) {
                        ((TaskBase)n).transferSupertasks((TaskBase)vn);
                    } else if (vn instanceof Interrelationship && n instanceof Interrelationship) {
                        ((Interrelationship)vn).replace((Interrelationship)n);
                    }
                    this.removeNode(n);
                    if (this.nodes.contains(vn)) break;
                    this.addNode(vn);
                    break;
                }
                if (found) continue;
                virtuals.addElement(n);
                continue;
            }
            allnodes.addElement(n);
        }
        Enumeration ve = virtuals.elements();
        while (ve.hasMoreElements()) {
            Node vn = (Node)ve.nextElement();
            matcher = new Node(vn.getLabel(), vn.getAgent());
            boolean found = false;
            e = allnodes.elements();
            while (e.hasMoreElements()) {
                Node n = (Node)e.nextElement();
                if (!n.matches(matcher)) continue;
                found = true;
                vn.transferInterrelationships(n);
                if (vn instanceof TaskBase) {
                    if (n instanceof TaskBase) {
                        ((TaskBase)vn).transferSupertasks((TaskBase)n);
                    } else {
                        System.err.println("Warning, " + n.getLabel() + " is not a TaskBase as expected");
                    }
                } else if (vn instanceof Interrelationship) {
                    if (n instanceof Interrelationship) {
                        ((Interrelationship)n).replace((Interrelationship)vn);
                    } else {
                        System.err.println("Warning, " + n.getLabel() + " is not an Interrlationship as expected");
                    }
                }
                this.removeNode(vn);
                if (!(n instanceof TaskBase) || !((TaskBase)n).hasSupertasks()) break;
                this.removeNode(n);
                break;
            }
            if (found || !(vn instanceof TaskBase) || !((TaskBase)vn).hasSupertasks()) continue;
            this.removeNode(vn);
        }
        this.retargetSchedules();
        this.retargetCommitments();
        this.log.log("Retarget finished", 4);
    }

    public synchronized void retargetSchedules() {
        this.retargetSchedules(null);
    }

    public synchronized void retargetSchedules(Enumeration schede) {
        Enumeration e;
        Enumeration enumeration = e = schede == null ? this.getSchedules() : schede;
        while (e.hasMoreElements()) {
            Schedule s = (Schedule)e.nextElement();
            if (s instanceof MLCSchedule) {
                this.retargetSchedules(((MLCSchedule)s).getSchedules());
            }
            Enumeration e2 = s.getElements();
            while (e2.hasMoreElements()) {
                ScheduleElement se = (ScheduleElement)e2.nextElement();
                if (se.getMethod() != null && se.getMethod().isVirtual()) {
                    Node temp;
                    Enumeration ne = this.findNodes(new Method(se.getMethod().getLabel(), se.getMethod().getAgent()));
                    while (ne.hasMoreElements()) {
                        temp = (Method)ne.nextElement();
                        if (temp.isVirtual()) continue;
                        se.setMethod((Method)temp);
                    }
                    while (ne.hasMoreElements()) {
                        temp = (Node)ne.nextElement();
                        if (temp.isVirtual()) continue;
                        this.log.log("Warning: Duplicate match(es) found for ScheduleElement " + temp.getLabel() + "\n" + temp, 1);
                        break;
                    }
                }
                if (se.numPreconditions() <= 0) continue;
                Enumeration en = se.getPreconditionsElement();
                while (en.hasMoreElements()) {
                    Precondition p = (Precondition)en.nextElement();
                    if (!(p instanceof PrecedencePrecondition)) continue;
                    PrecedencePrecondition pp = (PrecedencePrecondition)p;
                    if (pp.getInterrelationship() == null) {
                        if (pp.isArtificialIR()) continue;
                        this.log.log("Warning: No interrelationship found on precedence precondition on element " + se.getLabel(), 1);
                        continue;
                    }
                    if (!pp.getInterrelationship().isVirtual()) continue;
                    Interrelationship i = pp.getInterrelationship();
                    Node n = this.findNode(new Interrelationship(i.getLabel(), i.getAgent()));
                    if (n != null && n instanceof Interrelationship) {
                        pp.setInterrelationship((Interrelationship)n);
                        continue;
                    }
                    System.err.println("Nuts, can't find the ir");
                }
            }
        }
    }

    public synchronized void retargetAttributes() {
        this.retargetAttributes(this.getAttributesTable());
        Enumeration e = this.getAllNodes();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            this.retargetAttributes(n.getAttributesTable());
        }
        e = this.getAgents();
        while (e.hasMoreElements()) {
            Agent a = (Agent)e.nextElement();
            this.retargetAttributes(a.getAttributesTable());
        }
        e = this.getCommitments();
        while (e.hasMoreElements()) {
            Commitment c = (Commitment)e.nextElement();
            this.retargetAttributes(c.getAttributesTable());
        }
        e = this.getSchedules();
        while (e.hasMoreElements()) {
            Schedule s = (Schedule)e.nextElement();
            Enumeration en = s.getElements();
            while (en.hasMoreElements()) {
                ScheduleElement se = (ScheduleElement)en.nextElement();
                this.retargetAttributes(se.getAttributesTable());
            }
        }
    }

    protected synchronized void retargetAttributes(Hashtable table) {
        Enumeration e = table.keys();
        block0: while (e.hasMoreElements()) {
            Node temp;
            Node n;
            Object key = e.nextElement();
            Object value = table.get(key);
            if (!(value instanceof Node) || !(n = (Node)value).isVirtual()) continue;
            Enumeration ne = this.findNodes(new Node(n.getLabel(), n.getAgent()));
            while (ne.hasMoreElements()) {
                temp = (Method)ne.nextElement();
                if (temp.isVirtual()) continue;
                table.put(key, temp);
            }
            while (ne.hasMoreElements()) {
                temp = (Node)ne.nextElement();
                if (temp.isVirtual()) continue;
                this.log.log("Warning: Duplicate match(es) found for attribute " + temp.getLabel() + "\n" + temp, 1);
                continue block0;
            }
        }
    }

    public synchronized void retargetCommitments() {
        Enumeration e = this.getCommitments();
        while (e.hasMoreElements()) {
            Commitment c = (Commitment)e.nextElement();
            Enumeration e2 = c.getTasks();
            Vector<TaskBase> v = new Vector<TaskBase>();
            while (e2.hasMoreElements()) {
                TaskBase t = (TaskBase)e2.nextElement();
                if (t.isVirtual() || t.isNonLocal()) {
                    TaskBase temp;
                    Enumeration ne = this.findNodes(new TaskBase(t.getLabel(), t.getAgent()));
                    boolean added = false;
                    TaskBase nl = null;
                    while (ne.hasMoreElements()) {
                        temp = (TaskBase)ne.nextElement();
                        if (temp.isVirtual()) continue;
                        if (temp.isNonLocal()) {
                            nl = temp;
                            continue;
                        }
                        added = true;
                        v.addElement(temp);
                    }
                    while (ne.hasMoreElements()) {
                        temp = (TaskBase)ne.nextElement();
                        if (temp.isVirtual() || temp.isNonLocal()) continue;
                        this.log.log("Warning: Duplicate match(es) found for Commitment " + temp.getLabel() + "\n" + temp, 1);
                        break;
                    }
                    if (added) continue;
                    if (nl != null) {
                        v.addElement(nl);
                        continue;
                    }
                    v.addElement(t);
                    continue;
                }
                v.addElement(t);
            }
            c.setTaskVector(v);
        }
    }

    public void smash() {
        Enumeration e = new SafeEnumeration(this.getAllNodes());
        this.nodes = new Vector();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            if (n instanceof Task) {
                Task t = (Task)n;
                SafeEnumeration te = new SafeEnumeration(t.getSubtasks());
                while (te.hasMoreElements()) {
                    TaskBase tb = (TaskBase)te.nextElement();
                    t.replaceSubtask(tb, new VirtualTaskBase(tb.getLabel(), tb.getAgent()));
                }
                this.addNode(n);
            } else if (n instanceof TaskBase) {
                this.addNode(n);
            } else if (n instanceof Interrelationship) {
                Interrelationship i = (Interrelationship)n;
                i.setEndpoints(new VirtualNode(i.getFrom().getLabel(), i.getFrom().getAgent()), i.getFromOutcome(), new VirtualNode(i.getTo().getLabel(), i.getTo().getAgent()));
                this.addNode(i.getFrom());
                this.addNode(i.getTo());
            } else if (n instanceof Resource) {
                this.addNode(n);
            }
            if (!n.isVirtual()) continue;
            this.removeNode(n);
        }
        e = this.getSchedules();
        while (e.hasMoreElements()) {
            Schedule s = (Schedule)e.nextElement();
            Enumeration se = s.getElements();
            while (se.hasMoreElements()) {
                ScheduleElement sem = (ScheduleElement)se.nextElement();
                if (sem.getMethod() == null) continue;
                sem.setMethod(new VirtualMethod(sem.getMethod().getLabel(), sem.getMethod().getAgent()));
            }
        }
        e = this.getCommitments();
        while (e.hasMoreElements()) {
            Commitment c = (Commitment)e.nextElement();
            Enumeration ce = c.getTasks();
            Vector<VirtualTaskBase> v = new Vector<VirtualTaskBase>();
            while (ce.hasMoreElements()) {
                TaskBase t = (TaskBase)ce.nextElement();
                v.addElement(new VirtualTaskBase(t.getLabel(), t.getAgent()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOrphans() {
        Integer n = this.addLock;
        synchronized (n) {
            SafeEnumeration e = new SafeEnumeration(this.getNodes());
            while (e.hasMoreElements()) {
                Task t;
                boolean remove;
                Node n2 = (Node)e.nextElement();
                boolean bl = remove = !(n2 instanceof Resource);
                if (remove && n2 instanceof Task && (t = (Task)n2).hasSubtasks()) {
                    Enumeration te = t.getSubtasks();
                    while (te.hasMoreElements()) {
                        Node st = (Node)te.nextElement();
                        if (st.isVirtual()) continue;
                        remove = false;
                        break;
                    }
                }
                if (remove) {
                    if (n2.hasOutInterrelationships()) {
                        remove = false;
                    }
                    if (n2.hasInInterrelationships()) {
                        remove = false;
                    }
                }
                if (n2 instanceof TaskBase && ((TaskBase)n2).hasSupertasks()) {
                    remove = true;
                }
                if (!remove) continue;
                this.removeNode(n2);
            }
        }
    }

    public String toTTaems(float v) {
        StringBuffer sb = new StringBuffer("");
        Vector<Node> seen = new Vector<Node>();
        sb.append(";;;;\n;; Begin Task Structure " + this.getLabel() + " (Output v." + v + ")\n;;;;\n\n");
        Enumeration e = this.getAgents();
        while (e.hasMoreElements()) {
            Agent a = (Agent)e.nextElement();
            sb.append(a.toTTaems(v));
            sb.append("\n");
        }
        e = this.getNodes();
        while (e.hasMoreElements()) {
            Node cn;
            Node n = (Node)e.nextElement();
            if (n instanceof Task) {
                if (!((Task)n).isTaskGroup()) {
                    this.log.log("Warning: High level task is not a task group.", 1);
                }
                Enumeration ne = n.findNodes(new Node(null, null));
                while (ne.hasMoreElements()) {
                    cn = (Node)ne.nextElement();
                    if (seen.contains(cn)) {
                        sb.append("; Node " + cn.getLabel() + " previously defined\n");
                    } else {
                        seen.addElement(cn);
                        sb.append(cn.toTTaems(v));
                    }
                    sb.append("\n");
                }
                continue;
            }
            if (!seen.contains(n)) {
                seen.addElement(n);
                sb.append(n.toTTaems(v));
                Enumeration irs = n.getOutInterrelationships();
                while (irs.hasMoreElements()) {
                    cn = (Node)irs.nextElement();
                    if (seen.contains(cn)) {
                        sb.append("; Node " + cn.getLabel() + " previously defined\n");
                        continue;
                    }
                    seen.addElement(cn);
                    sb.append("\n");
                    sb.append(cn.toTTaems(v));
                }
            }
            sb.append("\n");
        }
        if (this.criteria != null) {
            sb.append(this.criteria.toTTaems(v));
            sb.append("\n");
        }
        if (this.schedules != null) {
            e = this.getSchedules();
            while (e.hasMoreElements()) {
                Schedule s = (Schedule)e.nextElement();
                sb.append(s.toTTaems(v));
                sb.append("\n");
            }
        }
        if (this.commitments != null) {
            e = this.getCommitments();
            while (e.hasMoreElements()) {
                Commitment c = (Commitment)e.nextElement();
                sb.append(c.toTTaems(v));
                sb.append("\n");
            }
        }
        sb.append(Node.attributesToString(this.attributes, v));
        return sb.toString();
    }

    public String toString() {
        return this.toTTaems(1.1f);
    }

    public JPanel getDisplay() {
        return this.display;
    }

    protected void initGraphics() {
        this.setLayout(new BorderLayout());
        this.scroll = new JScrollPane();
        this.scroll.setHorizontalScrollBarPolicy(32);
        this.scroll.setVerticalScrollBarPolicy(22);
        this.display = new TaemsCanvas();
        this.scroll.setViewportView(this.display);
        this.display.setVisible(true);
        this.add((Component)this.scroll, "Center");
    }

    public int calculateWidth(FontMetrics fm) {
        int width = 0;
        Enumeration e = this.getNodes();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            width += n.calculateTreeWidth(fm) + 50;
        }
        if (width > 0) {
            width -= 50;
        }
        return width;
    }

    public int calculateTreeWidth(FontMetrics fm) {
        return this.calculateWidth(fm);
    }

    public int calculateHeight(FontMetrics fm) {
        int height = 0;
        Enumeration e = this.getNodes();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            height = Math.max(height, n.calculateTreeHeight(fm));
        }
        return height;
    }

    public int calculateTreeHeight(FontMetrics fm) {
        int sheight = 0;
        int rsrc = 0;
        Enumeration e = this.getNodes();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            if (n instanceof Resource) {
                rsrc = Math.max(rsrc, n.calculateTreeHeight(fm));
                continue;
            }
            sheight = Math.max(sheight, n.calculateTreeHeight(fm));
        }
        int height = sheight;
        return height += rsrc + 50;
    }

    public Node findNode(Point p) {
        Enumeration e = this.getAllNodes();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            if (!n.contains(p)) continue;
            return n;
        }
        return null;
    }

    public Dimension getMinimumSize() {
        return new Dimension(25, 25);
    }

    public boolean isOpaque() {
        return true;
    }

    static /* synthetic */ String access$202(Taems x0, String x1) {
        x0.last_selectnode = x1;
        return x0.last_selectnode;
    }

    protected class TaemsCanvas
    extends JPanel
    implements Printable,
    ClipboardOwner {
        private boolean shownles = true;
        private boolean showqcds = false;
        private JFrame info;
        private File file = null;
        private float vers;
        PageFormat pageformat = new PageFormat();
        private JPopupMenu popupmenu;
        private JMenuItem copyitem;
        private JMenuItem pasteitem;
        protected Properties props = new Properties();
        Dimension d = new Dimension(500, 500);
        Dimension dim = this.getMinimumSize();
        boolean placeLock = false;
        Node selected = null;
        Point popuppoint = null;

        public TaemsCanvas() {
            this.popupmenu = this.generateMenu();
            this.addMouseListener(new MouseListener(this){
                private final /* synthetic */ TaemsCanvas this$1;
                {
                    this.this$1 = this$1;
                }

                public void mouseClicked(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                    this.this$1.handleMouseEvent(e);
                }

                public void mouseReleased(MouseEvent e) {
                }
            });
            this.addMouseMotionListener(new MouseMotionListener(this){
                private final /* synthetic */ TaemsCanvas this$1;
                {
                    this.this$1 = this$1;
                }

                public void mouseDragged(MouseEvent e) {
                    this.this$1.handleMouseEvent(e);
                }

                public void mouseMoved(MouseEvent e) {
                }
            });
        }

        public void updateMenu() {
            if (this.getSelected() == null) {
                this.copyitem.setEnabled(false);
            } else {
                this.copyitem.setEnabled(true);
            }
            if (this.getClipboardContents() == null || this.getClipboardContents().equals("")) {
                this.pasteitem.setEnabled(false);
            } else {
                this.pasteitem.setEnabled(true);
            }
        }

        public JPopupMenu generateMenu() {
            JPopupMenu menu = new JPopupMenu();
            JMenuItem m = this.info == null || !this.info.isVisible() ? new JMenuItem("Show Information Window") : new JMenuItem("Hide Information Window");
            m.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsCanvas this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    if (TaemsCanvas.access$400(this.this$1) == null) {
                        TaemsCanvas.access$402(this.this$1, TaemsCanvas.access$500(this.this$1).new TaemsInformation());
                    }
                    if (TaemsCanvas.access$400(this.this$1).isVisible()) {
                        TaemsCanvas.access$400(this.this$1).setVisible(false);
                        ((JMenuItem)e.getSource()).setText("Show Information Window");
                    } else {
                        TaemsCanvas.access$400(this.this$1).setVisible(true);
                        ((JMenuItem)e.getSource()).setText("Hide Information Window");
                    }
                }
            });
            menu.add(m);
            menu.addSeparator();
            this.copyitem = new JMenuItem("Copy Node");
            this.copyitem.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsCanvas this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.copyNode(this.this$1.getSelected());
                }
            });
            this.copyitem.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            menu.add(this.copyitem);
            this.pasteitem = new JMenuItem("Paste Node");
            this.pasteitem.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsCanvas this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.pasteNode(this.this$1.popuppoint);
                }
            });
            this.pasteitem.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            menu.add(this.pasteitem);
            menu.addSeparator();
            m = new JMenuItem("Revert Node Placement");
            m.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsCanvas this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    TaemsCanvas.access$500(this.this$1).fireNodeUpdateEvent(new NodeUpdateEvent(new Integer(0), 2));
                }
            });
            menu.add(m);
            m = this.shownles ? new JMenuItem("Hide Interrelationships") : new JMenuItem("Show Interrelationships");
            m.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsCanvas this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    TaemsCanvas.access$602(this.this$1, !TaemsCanvas.access$600(this.this$1));
                    TaemsCanvas.access$700(this.this$1, TaemsCanvas.access$500(this.this$1).findNodes(new Interrelationship()), !TaemsCanvas.access$600(this.this$1));
                    if (TaemsCanvas.access$600(this.this$1)) {
                        ((JMenuItem)e.getSource()).setText("Hide Interrelationships");
                    } else {
                        ((JMenuItem)e.getSource()).setText("Show Interrelationships");
                    }
                }
            });
            menu.add(m);
            m = this.showqcds ? new JMenuItem("Hide Distributions") : new JMenuItem("Show Distributions");
            m.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsCanvas this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    TaemsCanvas.access$802(this.this$1, !TaemsCanvas.access$800(this.this$1));
                    TaemsCanvas.access$900(this.this$1, TaemsCanvas.access$500(this.this$1).findNodes(new Method()), TaemsCanvas.access$800(this.this$1));
                    if (TaemsCanvas.access$800(this.this$1)) {
                        ((JMenuItem)e.getSource()).setText("Hide Distributions");
                    } else {
                        ((JMenuItem)e.getSource()).setText("Show Distributions");
                    }
                }
            });
            menu.add(m);
            m = new JMenuItem("Refresh");
            m.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsCanvas this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    TaemsCanvas.access$500(this.this$1).fireNodeUpdateEvent(new NodeUpdateEvent(new Integer(0), 1));
                }
            });
            menu.add(m);
            menu.addSeparator();
            m = new JMenuItem("Save");
            m.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsCanvas this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.save(false);
                }
            });
            menu.add(m);
            m = new JMenuItem("Save As...");
            m.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsCanvas this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.save(true);
                }
            });
            menu.add(m);
            m = new JMenuItem("Page Setup...");
            m.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsCanvas this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    PrinterJob job = PrinterJob.getPrinterJob();
                    this.this$1.pageformat = job.pageDialog(this.this$1.pageformat);
                }
            });
            menu.add(m);
            m = new JMenuItem("Print...");
            m.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsCanvas this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.printToPrinter();
                }
            });
            menu.add(m);
            return menu;
        }

        public synchronized void save(boolean as) {
            if (as || this.file == null) {
                String dir = System.getProperty("user.dir");
                if (dir == null) {
                    dir = ".";
                }
                JFileChooser save = new JFileChooser(dir);
                save.removeChoosableFileFilter(save.getAcceptAllFileFilter());
                FileFilter v11 = new FileFilter(this){
                    private final /* synthetic */ TaemsCanvas this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public boolean accept(File f) {
                        return true;
                    }

                    public String getDescription() {
                        return "Version 1.1";
                    }
                };
                save.addChoosableFileFilter(v11);
                FileFilter v10 = new FileFilter(this){
                    private final /* synthetic */ TaemsCanvas this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public boolean accept(File f) {
                        return true;
                    }

                    public String getDescription() {
                        return "Version 1.0";
                    }
                };
                save.addChoosableFileFilter(v10);
                FileFilter v10a = new FileFilter(this){
                    private final /* synthetic */ TaemsCanvas this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public boolean accept(File f) {
                        return true;
                    }

                    public String getDescription() {
                        return "Version 1.0a";
                    }
                };
                save.addChoosableFileFilter(v10a);
                save.setFileFilter(v11);
                save.setDialogTitle("Save Taems structure as...");
                int ret = save.showSaveDialog(this);
                if (ret == 0) {
                    this.file = save.getSelectedFile();
                    if (!this.file.getPath().endsWith(".ttaems") && !this.file.getPath().endsWith(".taems")) {
                        this.file = new File(this.file.getPath() + ".ttaems");
                    }
                    FileFilter f = save.getFileFilter();
                    this.vers = 1.1f;
                    if (f == v11) {
                        this.vers = 1.1f;
                    } else if (f == v10) {
                        this.vers = 1.0f;
                    } else if (f == v10a) {
                        this.vers = 1.01f;
                    }
                } else {
                    return;
                }
            }
            try {
                FileWriter writer = new FileWriter(this.file);
                writer.write(Taems.this.toTTaems(this.vers));
                writer.flush();
                writer.close();
            }
            catch (IOException ex) {
                System.err.println(ex);
            }
        }

        public synchronized void printToPrinter() {
            PrinterJob job = PrinterJob.getPrinterJob();
            if (job.printDialog()) {
                printing = true;
                job.setPrintable(this, this.pageformat);
                try {
                    job.print();
                }
                catch (PrinterException e) {
                    System.err.println(e);
                }
                printing = false;
            }
        }

        public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
            if (pageIndex == 0) {
                Graphics2D g2 = (Graphics2D)g;
                double pageHeight = pageFormat.getImageableHeight();
                double pageWidth = pageFormat.getImageableWidth();
                Dimension d = this.getPreferredSize();
                Rectangle bounds = this.updatePreferredSize();
                double xScale = Math.min(1.0, pageWidth / bounds.getWidth());
                double yScale = Math.min(1.0, pageHeight / bounds.getHeight());
                AffineTransform SAF = g2.getTransform();
                AffineTransform AF = new AffineTransform(SAF);
                double scale = Math.min(xScale, yScale);
                AF.translate(pageFormat.getImageableX() - bounds.getX() * scale, pageFormat.getImageableY() - bounds.getY() * scale);
                AF.scale(scale, scale);
                g2.setBackground(Color.white);
                g2.setTransform(AF);
                this.paintComponent(g2);
                g2.setTransform(SAF);
                return 0;
            }
            return 1;
        }

        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }

        public void copyNode(Node n) {
            Object clone = null;
            if (n != null) {
                Taems taems = new Taems();
                taems.addNode((Node)n.clone());
                StringSelection data = new StringSelection(taems.toString());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(data, this);
            }
        }

        public void pasteNode(Point point) {
            this.selectNode(null);
            String data = this.getClipboardContents();
            ReadTTaems reader = new ReadTTaems(null);
            Taems taems = null;
            try {
                taems = reader.readTTaems(new StringReader(data));
            }
            catch (Exception e) {
                System.err.println("Error, clipboard contents do not appear to be a Taems structure.");
            }
            if (taems == null) {
                return;
            }
            Enumeration e = taems.findNodes(new Node());
            while (e.hasMoreElements()) {
                Node src = (Node)e.nextElement();
                if (src.isVirtual() || Taems.this.findNode(new Node(src.getLabel())) == null) continue;
                int index = 1;
                while (Taems.this.findNode(new Node(src.getLabel() + "_" + index)) != null) {
                    ++index;
                }
                src.setLabel(src.getLabel() + "_" + index);
            }
            this.placeLock = true;
            Taems.this.addTaems(taems, false);
        }

        public String getClipboardContents() {
            boolean hasTransferableText;
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = clipboard.getContents(null);
            boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
            if (hasTransferableText) {
                try {
                    return (String)contents.getTransferData(DataFlavor.stringFlavor);
                }
                catch (UnsupportedFlavorException ex) {
                    System.out.println(ex);
                }
                catch (IOException ex) {
                    System.out.println(ex);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics g) {
            Integer n = Taems.this.addLock;
            synchronized (n) {
                if (this.info != null && Taems.this.revalue) {
                    this.info.repaint();
                    Taems.this.revalue = false;
                }
                if (Taems.this.replace) {
                    this.placeNodes(g);
                    Taems.this.replace = false;
                    this.revalidate();
                }
                if (!printing) {
                    this.d = this.getSize();
                    g.clearRect(0, 0, this.d.width, this.d.height);
                }
                this.paintNodes(g);
            }
        }

        public void paintNodes(Graphics g) {
            Node n;
            Enumeration e = Taems.this.getNodes();
            while (e.hasMoreElements()) {
                n = (Node)e.nextElement();
                n.paintLines(g);
            }
            e = Taems.this.getNodes();
            while (e.hasMoreElements()) {
                n = (Node)e.nextElement();
                if (n.getLocation() == null) {
                    Taems.this.log.log("Warning, node " + n.getLabel() + " has null location", 0);
                    continue;
                }
                if (n.getLocation().x == Integer.MIN_VALUE) {
                    Taems.this.log.log("Warning, node " + n.getLabel() + " is unplaced", 0);
                    continue;
                }
                n.paint(g);
            }
        }

        public void placeNodes(Graphics g) {
            int width;
            Node n;
            Dimension d;
            int twidth = 0;
            boolean theight = false;
            int nrsrc = 0;
            this.dim = d = new Dimension(0, 0);
            Enumeration e = Taems.this.getAllNodes();
            Point none = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
            while (e.hasMoreElements()) {
                n = (Node)e.nextElement();
                if (!this.placeLock || n.getLocation() == null) {
                    n.setLocation(none);
                }
                n.updateBounds(g.getFontMetrics());
                if (!this.shownles && n instanceof Interrelationship) {
                    n.setHidden(true);
                    continue;
                }
                n.setHidden(false);
            }
            this.placeLock = false;
            int curwidth = 50;
            int curheight = 50;
            e = Taems.this.getNodes();
            while (e.hasMoreElements()) {
                n = (Node)e.nextElement();
                if (n instanceof Resource) {
                    ++nrsrc;
                    continue;
                }
                width = n.calculateTreeWidth(g.getFontMetrics());
                if (n.getLocation() != none) {
                    this.dim.width = curwidth = (int)Math.max((double)curwidth, n.getLocation().getX() + (double)(width / 2) + 50.0);
                    continue;
                }
                n.setLocation(new Point(curwidth + width / 2, curheight + n.calculateHeight(g.getFontMetrics()) / 2));
                this.dim.width = curwidth += width + 50;
                if (n instanceof Task) {
                    Task t = (Task)n;
                    if (!t.isTaskGroup()) continue;
                    t.setSubLocations(g.getFontMetrics());
                }
                n.updateBounds(g.getFontMetrics());
            }
            twidth = curwidth += 0;
            curwidth = 50;
            curwidth += (twidth - 100) / (nrsrc + 1);
            curheight = 50 + Taems.this.calculateTreeHeight(g.getFontMetrics());
            e = Taems.this.findNodes(new Resource());
            while (e.hasMoreElements()) {
                n = (Node)e.nextElement();
                if (!(n instanceof Resource) || n.getLocation() != none) continue;
                width = n.calculateTreeWidth(g.getFontMetrics());
                n.setLocation(new Point(curwidth, curheight - n.calculateHeight(g.getFontMetrics()) / 2));
                curwidth += twidth / (nrsrc + 1);
                n.updateBounds(g.getFontMetrics());
                this.dim.height = curheight;
            }
            e = Taems.this.findNodes(new Interrelationship());
            while (e.hasMoreElements()) {
                Interrelationship i = (Interrelationship)e.nextElement();
                if (i.getLocation() != none) continue;
                Node f = i.getFrom();
                if (f == null) {
                    Taems.this.log.log("Warning, interrelationship " + i.getLabel() + " has null from link", 0);
                    continue;
                }
                if (f.getLocation() == null) {
                    Taems.this.log.log("Warning, ir from node " + f.getLabel() + " has null location", 0);
                    continue;
                }
                if (f.getLocation() == none) {
                    Taems.this.log.log("Warning, ir from node " + f.getLabel() + " has none location", 0);
                    continue;
                }
                Node t = i.getTo();
                if (t == null) {
                    Taems.this.log.log("Warning, interrelationship " + i.getLabel() + " has null to link", 0);
                    continue;
                }
                if (t.getLocation() == null) {
                    Taems.this.log.log("Warning, ir to node " + t.getLabel() + " has null location", 0);
                    continue;
                }
                if (t.getLocation() == none) {
                    Taems.this.log.log("Warning, ir to node " + t.getLabel() + " has none location", 0);
                    continue;
                }
                Point p = new Point((f.getLocation().x + t.getLocation().x) / 2, (f.getLocation().y + t.getLocation().y) / 2 - 25);
                int search = 1;
                while (Taems.this.findNode(p) != null) {
                    p = new Point(p.x, p.y - search * 50 / 2);
                    if (p.y >= 0) continue;
                    search = -1;
                    p = new Point(p.x, p.y - search * 50 / 2);
                }
                i.setLocation(p);
                i.updateBounds(g.getFontMetrics());
            }
            this.updatePreferredSize();
        }

        public void selectNode(Node n) {
            if (this.selected != n) {
                if (this.selected != null) {
                    if (!this.shownles) {
                        this.hideNodes(this.selected.getOutInterrelationships(), true);
                        this.hideNodes(this.selected.getInInterrelationships(), true);
                    }
                    this.selected.setSelected(false);
                    if (!this.shownles && this.selected instanceof Interrelationship) {
                        this.selected.setHidden(true);
                    }
                }
                this.selected = this.selected == null || this.selected.isVisible() ? n : null;
                if (this.selected != null) {
                    this.selected.setSelected(true);
                    this.selected.setHidden(false);
                    if (!this.shownles) {
                        this.hideNodes(this.selected.getOutInterrelationships(), false);
                        this.hideNodes(this.selected.getInInterrelationships(), false);
                    }
                }
                Taems.this.revalue = true;
            }
        }

        public Node getSelected() {
            return this.selected;
        }

        public void handleMouseEvent(MouseEvent e) {
            if (e.getID() == 501) {
                Node n;
                if (e.getClickCount() == 1) {
                    this.selectNode(Taems.this.findNode(e.getPoint()));
                } else if (e.getClickCount() == 2 && (n = Taems.this.findNode(e.getPoint())) != null) {
                    n.toggleCollapsed();
                }
            }
            if (e.isPopupTrigger() && !this.popupmenu.isVisible()) {
                this.updateMenu();
                this.popupmenu.show(this, e.getX(), e.getY());
                this.popuppoint = e.getPoint();
            }
            if (e.getID() == 506 && !this.popupmenu.isVisible() && this.selected != null) {
                Point offset = new Point(e.getPoint().x - this.selected.getLocation().x, e.getPoint().y - this.selected.getLocation().y);
                Point halfoffseto = new Point((int)Math.ceil((float)offset.x / 2.0f), (int)Math.ceil((float)offset.y / 2.0f));
                Point halfoffseti = new Point((int)Math.floor((float)offset.x / 2.0f), (int)Math.floor((float)offset.y / 2.0f));
                this.selected.offsetLocation(offset);
                if (e.isControlDown()) {
                    Interrelationship i;
                    Enumeration en2 = this.selected.getOutInterrelationships();
                    while (en2.hasMoreElements()) {
                        i = (Interrelationship)en2.nextElement();
                        i.offsetLocation(halfoffseto);
                    }
                    en2 = this.selected.getInInterrelationships();
                    while (en2.hasMoreElements()) {
                        i = (Interrelationship)en2.nextElement();
                        i.offsetLocation(halfoffseti);
                    }
                    if (this.selected instanceof Task) {
                        Enumeration en = ((Task)this.selected).getAllSubtasks();
                        while (en.hasMoreElements()) {
                            Node n = (Node)en.nextElement();
                            n.offsetLocation(offset);
                            en2 = n.getOutInterrelationships();
                            while (en2.hasMoreElements()) {
                                i = (Interrelationship)en2.nextElement();
                                i.offsetLocation(halfoffseto);
                            }
                            en2 = n.getInInterrelationships();
                            while (en2.hasMoreElements()) {
                                i = (Interrelationship)en2.nextElement();
                                i.offsetLocation(halfoffseti);
                            }
                        }
                    }
                }
            }
        }

        public Dimension getMinimumSize() {
            return new Dimension(25, 25);
        }

        public Rectangle updatePreferredSize() {
            Enumeration e = Taems.this.getAllNodes();
            int t = Integer.MAX_VALUE;
            int l = Integer.MAX_VALUE;
            int r = Integer.MIN_VALUE;
            int b = Integer.MIN_VALUE;
            while (e.hasMoreElements()) {
                Node n = (Node)e.nextElement();
                Rectangle bounds = n.getBounds();
                if (bounds == null) continue;
                if (bounds.y < t) {
                    t = bounds.y;
                }
                if (bounds.x < l) {
                    l = bounds.x;
                }
                if (bounds.x + bounds.width > r) {
                    r = bounds.x + bounds.width;
                }
                if (bounds.y + bounds.height <= b) continue;
                b = bounds.y + bounds.height;
            }
            this.dim.height = 100 + b;
            this.dim.width = 100 + r;
            Dimension min = this.getMinimumSize();
            if (this.dim.height < min.height) {
                this.dim.height = min.height;
            }
            if (this.dim.width < min.width) {
                this.dim.width = min.width;
            }
            return new Rectangle(l, t, r - l, b - t);
        }

        public Dimension getPreferredSize() {
            return this.dim;
        }

        private void hideNodes(Enumeration e, boolean h) {
            while (e.hasMoreElements()) {
                Node n = (Node)e.nextElement();
                if (n.isSelected()) continue;
                n.setHidden(h);
            }
        }

        private void hideQCDs(Enumeration e, boolean h) {
            while (e.hasMoreElements()) {
                Node n = (Node)e.nextElement();
                if (!(n instanceof Method)) continue;
                ((Method)n).setShowQCDs(h);
            }
        }

        static /* synthetic */ JFrame access$400(TaemsCanvas x0) {
            return x0.info;
        }

        static /* synthetic */ JFrame access$402(TaemsCanvas x0, JFrame x1) {
            x0.info = x1;
            return x0.info;
        }

        static /* synthetic */ Taems access$500(TaemsCanvas x0) {
            return x0.Taems.this;
        }

        static /* synthetic */ boolean access$602(TaemsCanvas x0, boolean x1) {
            x0.shownles = x1;
            return x0.shownles;
        }

        static /* synthetic */ boolean access$600(TaemsCanvas x0) {
            return x0.shownles;
        }

        static /* synthetic */ void access$700(TaemsCanvas x0, Enumeration x1, boolean x2) {
            x0.hideNodes(x1, x2);
        }

        static /* synthetic */ boolean access$802(TaemsCanvas x0, boolean x1) {
            x0.showqcds = x1;
            return x0.showqcds;
        }

        static /* synthetic */ boolean access$800(TaemsCanvas x0) {
            return x0.showqcds;
        }

        static /* synthetic */ void access$900(TaemsCanvas x0, Enumeration x1, boolean x2) {
            x0.hideQCDs(x1, x2);
        }
    }

    protected class TaemsInformation
    extends JFrame {
        JTabbedPane tabs;
        JTextPane ttaems;
        JTextPane summary;
        JTextPane schedules;
        JPanel edit;

        public TaemsInformation() {
            super("Taems Information");
            JMenuBar mbar = new JMenuBar();
            JMenu menu = new JMenu(this, "Edit"){
                private final /* synthetic */ TaemsInformation this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean isFocusable() {
                    return false;
                }
            };
            JMenuItem mitem = new JMenuItem("Copy");
            mitem.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsInformation this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                }
            });
            menu.add(mitem);
            mitem = new JMenuItem("Paste");
            menu.add(mitem);
            mitem = new JMenuItem("Cut");
            menu.add(mitem);
            mbar.add(menu);
            this.setJMenuBar(mbar);
            this.getContentPane().setLayout(new BorderLayout());
            this.tabs = new JTabbedPane();
            this.getContentPane().add((Component)this.tabs, "Center");
            JScrollPane scroll = new JScrollPane();
            this.edit = new JPanel();
            scroll.getViewport().add(this.edit);
            scroll.setVerticalScrollBarPolicy(22);
            this.tabs.add("Edit", scroll);
            scroll = new JScrollPane();
            this.summary = new JTextPane();
            scroll.getViewport().add(this.summary);
            this.tabs.add("Summary", scroll);
            this.summary.setBackground(this.getBackground());
            this.summary.setEditable(false);
            scroll = new JScrollPane();
            this.ttaems = new JTextPane();
            scroll.getViewport().add(this.ttaems);
            scroll.setVerticalScrollBarPolicy(22);
            this.tabs.add("TTaems", scroll);
            this.ttaems.setBackground(this.getBackground());
            this.ttaems.setEditable(false);
            scroll = new JScrollPane();
            this.schedules = new JTextPane();
            scroll.getViewport().add(this.schedules);
            scroll.setVerticalScrollBarPolicy(22);
            this.tabs.add("Schedules", scroll);
            this.schedules.setBackground(this.getBackground());
            this.schedules.setEditable(false);
            this.updateInformation();
            this.setSize(400, 450);
        }

        public void repaint() {
            this.updateInformation();
            super.repaint();
        }

        public void updateInformation() {
            Node selected = Taems.this.display != null ? Taems.this.display.selected : null;
            int rt = 0;
            int d = 0;
            int r = 0;
            int i = 0;
            int m = 0;
            int t = 0;
            int tg = 0;
            int n = 0;
            Enumeration e = Taems.this.getAllNodes();
            while (e.hasMoreElements()) {
                Node node = (Node)e.nextElement();
                ++n;
                if (node instanceof Task) {
                    if (((Task)node).isTaskGroup()) {
                        ++tg;
                        continue;
                    }
                    ++t;
                    continue;
                }
                if (node instanceof Method) {
                    d = Math.max(d, ((Method)node).calculateTreeDepth());
                    ++m;
                    continue;
                }
                if (node instanceof Interrelationship) {
                    ++i;
                    continue;
                }
                if (!(node instanceof Resource)) continue;
                ++r;
            }
            StringBuffer buffer = new StringBuffer("");
            buffer.append("  Structure: " + Taems.this.getLabel() + "\n");
            buffer.append("     Height: " + d + "\n");
            buffer.append("\n");
            buffer.append("      Nodes: " + n + "\n");
            buffer.append("Task Groups: " + tg + "\n");
            buffer.append("      Tasks: " + t + "\n");
            buffer.append("    Methods: " + m + "\n");
            buffer.append("       NLEs: " + i + "\n");
            buffer.append("  Resources: " + r + "\n");
            buffer.append("\n");
            e = Taems.this.getNodes();
            String roots = "";
            while (e.hasMoreElements()) {
                Node node = (Node)e.nextElement();
                ++rt;
                roots = roots + node.getLabel() + " ";
            }
            buffer.append(" Root Nodes: " + rt + " (includes resources)\n");
            buffer.append("Root Labels: " + roots + "\n");
            buffer.append("\n");
            buffer.append("     Agents: " + Taems.this.numAgents() + "\n");
            buffer.append("  Schedules: " + Taems.this.numSchedules() + "\n");
            this.summary.setText(buffer.toString());
            if (selected != null) {
                this.ttaems.setText(selected.toString());
            } else {
                this.ttaems.setText(Taems.this.toString());
            }
            buffer = new StringBuffer("");
            Enumeration en = Taems.this.getSchedules();
            while (en.hasMoreElements()) {
                buffer.append(en.nextElement().toString());
            }
            this.schedules.setText(buffer.toString());
            this.edit.removeAll();
            this.edit.add(new TaemsEdit(selected));
        }
    }

    class TaemsEdit
    extends JPanel {
        Node node;
        JComponent c;
        JComboBox cb;
        JButton b;
        GridBagLayout grid = new GridBagLayout();
        GridBagConstraints cons = new GridBagConstraints();
        String none = "<none specified>";
        boolean start = true;
        Outcome outcome;
        JTextField outq;
        JTextField outc;
        JTextField outd;
        JTextField outl;
        JTextField outdn;
        JList sl;
        Object attrib;
        JTextField atl;
        JTextField att;
        JTextField atd;
        Agent agent = null;
        JTextField al;

        public TaemsEdit(Node n) {
            this.node = n;
            this.generatePanel();
        }

        public void generatePanel() {
            this.setLayout(this.grid);
            this.cons.fill = 1;
            this.cons.weightx = 1.0;
            if (this.node == null) {
                this.generateTaemsEdits();
            } else if (this.node instanceof Task) {
                this.generateNodeEdits();
                this.generateTaskBaseEdits();
                this.generateTaskEdits();
                this.generateOtherNodeEdits();
            } else if (this.node instanceof Method) {
                this.generateNodeEdits();
                this.generateTaskBaseEdits();
                this.generateMethodEdits();
                this.generateOtherNodeEdits();
            } else if (this.node instanceof Interrelationship) {
                this.generateNodeEdits();
                this.generateInterrelationshipEdits();
                this.generateOtherNodeEdits();
            } else if (this.node instanceof Resource) {
                this.generateNodeEdits();
                this.generateResourceEdits();
                this.generateOtherNodeEdits();
            } else {
                this.generateNodeEdits();
            }
        }

        public Component add(Component c) {
            this.cons.gridwidth = this.start ? 1 : 0;
            this.grid.setConstraints(c, this.cons);
            c = super.add(c);
            if (this.start) {
                JLabel l = new JLabel(" ");
                this.grid.setConstraints(l, this.cons);
                super.add(l);
            }
            this.start = !this.start;
            return c;
        }

        public void generateInterrelationshipEdits() {
            Node n;
            Interrelationship ir = (Interrelationship)this.node;
            String[] names = new String[]{"Enables", "Disables", "Facilitates", "Hinders", "Produces", "Consumes", "Limits"};
            Interrelationship[] types = new Interrelationship[]{new EnablesInterrelationship(), new DisablesInterrelationship(), new FacilitatesInterrelationship(), new HindersInterrelationship(), new ProducesInterrelationship(), new ConsumesInterrelationship(), new LimitsInterrelationship()};
            this.add(new JLabel("Type", 4));
            this.cb = new JComboBox();
            this.add(this.cb);
            for (int i = 0; i < names.length; ++i) {
                this.cb.addItem(names[i]);
                if (!ir.getClass().isInstance(types[i])) continue;
                this.cb.setSelectedIndex(i);
            }
            this.cb.addActionListener(new ActionListener(this, names, types){
                private final /* synthetic */ String[] val$names;
                private final /* synthetic */ Interrelationship[] val$types;
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                    this.val$names = val$names;
                    this.val$types = val$types;
                }

                public void actionPerformed(ActionEvent e) {
                    Interrelationship ir = (Interrelationship)this.this$1.node;
                    Interrelationship n = null;
                    String s = ((JComboBox)e.getSource()).getSelectedItem().toString();
                    for (int i = 0; i < this.val$names.length; ++i) {
                        if (!s.equals(this.val$names[i])) continue;
                        if (ir.getClass().isInstance(this.val$types[i])) break;
                        n = (Interrelationship)this.val$types[i].clone();
                        break;
                    }
                    if (n != null) {
                        n.replace(ir);
                        ir.copy(n);
                        this.this$1.selectNode(n);
                    }
                }
            });
            TreeSet<Node> nodes = new TreeSet<Node>();
            Enumeration e = Taems.this.getAllNodes();
            while (e.hasMoreElements()) {
                nodes.add((Node)e.nextElement());
            }
            this.add(new JLabel("From Node", 4));
            this.cb = new JComboBox();
            this.add(this.cb);
            Iterator it = nodes.iterator();
            if (ir.getFrom() == null) {
                this.cb.addItem(this.none);
            }
            int i = 0;
            while (it.hasNext()) {
                n = (Node)it.next();
                if (n instanceof Interrelationship) {
                    --i;
                } else {
                    this.cb.addItem(n.getLabel());
                    if (n.matches(ir.getFrom())) {
                        this.cb.setSelectedIndex(i);
                    }
                }
                ++i;
            }
            if (ir.getFrom() == null) {
                this.cb.setSelectedIndex(0);
            }
            this.cb.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    String s = ((JComboBox)e.getSource()).getSelectedItem().toString();
                    if (s.equals(this.this$1.none)) {
                        return;
                    }
                    Node n = TaemsEdit.access$000(this.this$1).findNode(new Node(s));
                    n.addInterrelationship((Interrelationship)this.this$1.node, ((Interrelationship)this.this$1.node).getTo());
                }
            });
            this.add(new JLabel("To Node", 4));
            this.cb = new JComboBox();
            this.add(this.cb);
            it = nodes.iterator();
            if (ir.getTo() == null) {
                this.cb.addItem(this.none);
            }
            i = 0;
            while (it.hasNext()) {
                n = (Node)it.next();
                if (n instanceof Interrelationship) {
                    --i;
                } else {
                    this.cb.addItem(n.getLabel());
                    if (n.matches(ir.getTo())) {
                        this.cb.setSelectedIndex(i);
                    }
                }
                ++i;
            }
            if (ir.getTo() == null) {
                this.cb.setSelectedIndex(0);
            }
            this.cb.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    String s = ((JComboBox)e.getSource()).getSelectedItem().toString();
                    if (s.equals(this.this$1.none)) {
                        return;
                    }
                    Node n = TaemsEdit.access$000(this.this$1).findNode(new Node(s));
                    ((Interrelationship)this.this$1.node).getFrom().addInterrelationship((Interrelationship)this.this$1.node, n);
                }
            });
            if (ir.hasModel()) {
                this.add(new JLabel("Model", 4));
                this.cb = new JComboBox();
                this.add(this.cb);
                if (ir.getModel() == null) {
                    this.cb.addItem(this.none);
                    this.cb.setSelectedIndex(0);
                }
                this.cb.addItem("Per Time Unit");
                if (ir.getModel() == "per_time_unit") {
                    this.cb.setSelectedIndex(0);
                }
                this.cb.addItem("Duration Independent");
                if (ir.getModel() == "duration_independent") {
                    this.cb.setSelectedIndex(1);
                }
                this.cb.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TaemsEdit this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent e) {
                        String s = ((JComboBox)e.getSource()).getSelectedItem().toString();
                        if (s.equals(this.this$1.none)) {
                            return;
                        }
                        if (s.startsWith("P")) {
                            ((Interrelationship)this.this$1.node).setModel("per_time_unit");
                        }
                        if (s.startsWith("D")) {
                            ((Interrelationship)this.this$1.node).setModel("duration_independent");
                        }
                    }
                });
            }
            if (ir instanceof ConsumesInterrelationship) {
                this.add(new JLabel("Consumes", 4));
                String s = ((ConsumesInterrelationship)ir).getConsumes() == null ? "" : ((ConsumesInterrelationship)ir).getConsumes().output();
                this.c = new JTextField(s);
                this.add(this.c);
                this.setTextActor(this.c, new TextActor(this){
                    private final /* synthetic */ TaemsEdit this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void handleText(String s) {
                        ((ConsumesInterrelationship)this.this$1.node).setConsumes(this.this$1.parseDistribution(s));
                    }
                });
            } else if (ir instanceof ProducesInterrelationship) {
                this.add(new JLabel("Produces", 4));
                String s = ((ProducesInterrelationship)ir).getProduces() == null ? "" : ((ProducesInterrelationship)ir).getProduces().output();
                this.c = new JTextField(s);
                this.add(this.c);
                this.setTextActor(this.c, new TextActor(this){
                    private final /* synthetic */ TaemsEdit this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void handleText(String s) {
                        ((ProducesInterrelationship)this.this$1.node).setProduces(this.this$1.parseDistribution(s));
                    }
                });
            } else {
                this.add(new JLabel("Quality Power", 4));
                String s = ir.getQuality() == null ? "" : ir.getQuality().output();
                this.c = new JTextField(s);
                this.add(this.c);
                this.setTextActor(this.c, new TextActor(this){
                    private final /* synthetic */ TaemsEdit this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void handleText(String s) {
                        ((Interrelationship)this.this$1.node).setQuality(this.this$1.parseDistribution(s));
                    }
                });
                this.add(new JLabel("Cost Power", 4));
                s = ir.getCost() == null ? "" : ir.getCost().output();
                this.c = new JTextField(s);
                this.add(this.c);
                this.setTextActor(this.c, new TextActor(this){
                    private final /* synthetic */ TaemsEdit this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void handleText(String s) {
                        ((Interrelationship)this.this$1.node).setCost(this.this$1.parseDistribution(s));
                    }
                });
                this.add(new JLabel("Duration Power", 4));
                s = ir.getDuration() == null ? "" : ir.getDuration().output();
                this.c = new JTextField(s);
                this.add(this.c);
                this.setTextActor(this.c, new TextActor(this){
                    private final /* synthetic */ TaemsEdit this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void handleText(String s) {
                        ((Interrelationship)this.this$1.node).setDuration(this.this$1.parseDistribution(s));
                    }
                });
                if (!(ir instanceof LimitsInterrelationship)) {
                    this.add(new JLabel("Delay", 4));
                    s = ir.getDelay() == null ? "" : ir.getDelay().output();
                    this.c = new JTextField(s);
                    this.add(this.c);
                    this.setTextActor(this.c, new TextActor(this){
                        private final /* synthetic */ TaemsEdit this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void handleText(String s) {
                            ((Interrelationship)this.this$1.node).setDelay(this.this$1.parseDistribution(s));
                        }
                    });
                }
            }
        }

        public void generateMethodEdits() {
            Method method = (Method)this.node;
            this.add(new JLabel("Nonlocal", 4));
            this.c = new JCheckBox("", method.isNonLocal());
            this.add(this.c);
            ((JCheckBox)this.c).addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    ((TaskBase)this.this$1.node).setNonLocal(((JCheckBox)e.getSource()).isSelected());
                }
            });
            this.add(new JLabel("Outcomes", 4));
            this.cb = new JComboBox();
            this.add(this.cb);
            Enumeration e = method.getOutcomes();
            if (!e.hasMoreElements()) {
                this.cb.addItem(this.none);
                this.cb.setSelectedIndex(0);
            }
            int i = 0;
            while (e.hasMoreElements()) {
                Outcome o = (Outcome)e.nextElement();
                this.cb.addItem(o.getLabel());
                if (i == 0) {
                    this.outcome = o;
                }
                if (o == Taems.this.last_outcome) {
                    this.outcome = Taems.this.last_outcome;
                    this.cb.setSelectedIndex(i);
                }
                ++i;
            }
            Taems.this.last_outcome = this.outcome;
            this.cb.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    String s = ((JComboBox)e.getSource()).getSelectedItem().toString();
                    if (s.equals(this.this$1.none)) {
                        return;
                    }
                    Outcome o = ((Method)this.this$1.node).getOutcome(s);
                    if (o == null) {
                        return;
                    }
                    this.this$1.outcome = o;
                    Taems.access$102(TaemsEdit.access$000(this.this$1), this.this$1.outcome);
                    this.this$1.outl.setText(this.this$1.outcome.getLabel() == null ? "" : this.this$1.outcome.getLabel());
                    this.this$1.outdn.setText(this.this$1.outcome.getQuality() == null ? "" : String.valueOf(this.this$1.outcome.getDensity()));
                    this.this$1.outq.setText(this.this$1.outcome.getQuality() == null ? "" : this.this$1.outcome.getQuality().output());
                    this.this$1.outc.setText(this.this$1.outcome.getCost() == null ? "" : this.this$1.outcome.getCost().output());
                    this.this$1.outd.setText(this.this$1.outcome.getDuration() == null ? "" : this.this$1.outcome.getDuration().output());
                }
            });
            this.add(new JLabel("Outcome Label", 4));
            String s = this.outcome == null ? "" : this.outcome.getLabel();
            this.outl = new JTextField(s);
            this.c = this.outl;
            this.add(this.outl);
            this.setTextActor(this.c, new TextActor(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleText(String s) {
                    if (this.this$1.outcome == null) {
                        return;
                    }
                    this.this$1.outcome.setLabel(this.this$1.parseLabel(s));
                }
            });
            this.add(new JLabel("Outcome Density", 4));
            s = this.outcome == null ? "" : String.valueOf(this.outcome.getDensity());
            this.outdn = new JTextField(s);
            this.c = this.outdn;
            this.add(this.outdn);
            this.setTextActor(this.c, new TextActor(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleText(String s) {
                    if (this.this$1.outcome == null) {
                        return;
                    }
                    this.this$1.outcome.setDensity(this.this$1.parseFloat(s));
                }
            });
            this.add(new JLabel("Outcome Quality", 4));
            s = this.outcome == null || this.outcome.getQuality() == null ? "" : this.outcome.getQuality().output();
            this.outq = new JTextField(s);
            this.c = this.outq;
            this.add(this.outq);
            this.setTextActor(this.c, new TextActor(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleText(String s) {
                    if (this.this$1.outcome == null) {
                        return;
                    }
                    this.this$1.outcome.setQuality(this.this$1.parseDistribution(s));
                }
            });
            this.add(new JLabel("Outcome Cost", 4));
            s = this.outcome == null || this.outcome.getCost() == null ? "" : this.outcome.getCost().output();
            this.outc = new JTextField(s);
            this.c = this.outc;
            this.add(this.outc);
            this.setTextActor(this.c, new TextActor(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleText(String s) {
                    if (this.this$1.outcome == null) {
                        return;
                    }
                    this.this$1.outcome.setCost(this.this$1.parseDistribution(s));
                }
            });
            this.add(new JLabel("Outcome Duration", 4));
            s = this.outcome == null || this.outcome.getDuration() == null ? "" : this.outcome.getDuration().output();
            this.outd = new JTextField(s);
            this.c = this.outd;
            this.add(this.outd);
            this.setTextActor(this.c, new TextActor(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleText(String s) {
                    if (this.this$1.outcome == null) {
                        return;
                    }
                    this.this$1.outcome.setDuration(this.this$1.parseDistribution(s));
                }
            });
            this.b = new JButton("Delete Outcome");
            this.add(this.b);
            this.b.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    if (this.this$1.outcome == null) {
                        return;
                    }
                    ((Method)this.this$1.node).removeOutcome(this.this$1.outcome);
                }
            });
            this.b = new JButton("Add new Outcome");
            this.add(this.b);
            this.b.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    String name = this.this$1.askString("Enter the new Outcome's label:", "Outcome_" + (((Method)this.this$1.node).numOutcomes() + 1));
                    if (name == null) {
                        return;
                    }
                    Outcome o = new Outcome(name, new Distribution(1.0f, 1.0f), new Distribution(1.0f, 1.0f), new Distribution(1.0f, 1.0f), 1.0f);
                    Taems.access$102(TaemsEdit.access$000(this.this$1), o);
                    ((Method)this.this$1.node).addOutcome(o);
                }
            });
            this.add(new JLabel(" "));
            this.add(new JLabel(" "));
            this.add(new JLabel("Start Time", 4));
            s = method.getStartTime() == Integer.MIN_VALUE ? "" : String.valueOf(method.getStartTime());
            this.c = new JTextField(s);
            this.add(this.c);
            this.setTextActor(this.c, new TextActor(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleText(String s) {
                    ((Method)this.this$1.node).setStartTime(this.this$1.parseInteger(s));
                }
            });
            this.add(new JLabel("Finish Time", 4));
            s = method.getFinishTime() == Integer.MIN_VALUE ? "" : String.valueOf(method.getFinishTime());
            this.c = new JTextField(s);
            this.add(this.c);
            this.setTextActor(this.c, new TextActor(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleText(String s) {
                    ((Method)this.this$1.node).setFinishTime(this.this$1.parseInteger(s));
                }
            });
            this.add(new JLabel("Accrued Time", 4));
            s = method.getAccruedTime() == Integer.MIN_VALUE ? "" : String.valueOf(method.getAccruedTime());
            this.c = new JTextField(s);
            this.add(this.c);
            this.setTextActor(this.c, new TextActor(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleText(String s) {
                    ((Method)this.this$1.node).setAccruedTime(this.this$1.parseInteger(s));
                }
            });
            this.add(new JLabel(" "));
            this.add(new JLabel(" "));
        }

        public void generateTaskBaseEdits() {
            TaskBase taskbase = (TaskBase)this.node;
            TreeSet<Node> nodes = new TreeSet<Node>();
            Enumeration e = Taems.this.getAllNodes();
            while (e.hasMoreElements()) {
                nodes.add((Node)e.nextElement());
            }
            this.add(new JLabel("Supertasks", 4));
            this.cb = new JComboBox();
            this.add(this.cb);
            Iterator it = nodes.iterator();
            if (!taskbase.hasSupertasks() || taskbase instanceof Task) {
                this.cb.addItem(this.none);
            }
            int i = 0;
            while (it.hasNext()) {
                Node n = (Node)it.next();
                if (!(n instanceof Task)) {
                    --i;
                } else if (n == this.node) {
                    --i;
                } else {
                    this.cb.addItem(n.getLabel());
                    if (taskbase.hasSupertasks() && n.matches(taskbase.firstSupertask())) {
                        this.cb.setSelectedIndex(i);
                    }
                }
                ++i;
            }
            if (!taskbase.hasSupertasks()) {
                this.cb.setSelectedIndex(0);
            }
            this.cb.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    String s = ((JComboBox)e.getSource()).getSelectedItem().toString();
                    if (s.equals(this.this$1.none)) {
                        ((TaskBase)this.this$1.node).removeAllSupertasks();
                        TaemsEdit.access$000(this.this$1).addNode(this.this$1.node);
                    } else {
                        Node n = TaemsEdit.access$000(this.this$1).findNode(new Node(s));
                        if (n instanceof Task) {
                            ((TaskBase)this.this$1.node).removeAllSupertasks();
                            TaemsEdit.access$000(this.this$1).removeNode(this.this$1.node);
                            ((Task)n).addSubtask((TaskBase)this.this$1.node);
                        }
                    }
                }
            });
            this.add(new JLabel("Earliest Start Time", 4));
            String s = taskbase.getEarliestStartTime() == Integer.MIN_VALUE ? "" : String.valueOf(taskbase.getEarliestStartTime());
            this.c = new JTextField(s);
            this.add(this.c);
            this.setTextActor(this.c, new TextActor(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleText(String s) {
                    ((TaskBase)this.this$1.node).setEarliestStartTime(this.this$1.parseInteger(s));
                }
            });
            this.add(new JLabel("Deadline", 4));
            s = taskbase.getDeadline() == Integer.MIN_VALUE ? "" : String.valueOf(taskbase.getDeadline());
            this.c = new JTextField(s);
            this.add(this.c);
            this.setTextActor(this.c, new TextActor(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleText(String s) {
                    ((TaskBase)this.this$1.node).setDeadline(this.this$1.parseInteger(s));
                }
            });
            this.add(new JLabel("Arrival Time", 4));
            s = taskbase.getArrivalTime() == Integer.MIN_VALUE ? "" : String.valueOf(taskbase.getArrivalTime());
            this.c = new JTextField(s);
            this.add(this.c);
            this.setTextActor(this.c, new TextActor(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleText(String s) {
                    ((TaskBase)this.this$1.node).setArrivalTime(this.this$1.parseInteger(s));
                }
            });
        }

        public void generateTaskEdits() {
            Task task = (Task)this.node;
            this.add(new JLabel("QAF", 4));
            this.cb = new JComboBox();
            this.add(this.cb);
            Enumeration e = QAF.getQAFs();
            if (task.getQAF() == null) {
                this.cb.addItem(this.none);
            }
            int i = 0;
            while (e.hasMoreElements()) {
                QAF q = (QAF)e.nextElement();
                this.cb.addItem(q.getLabel());
                if (q.matches(task.getQAF())) {
                    this.cb.setSelectedIndex(i);
                }
                ++i;
            }
            if (task.getQAF() == null) {
                this.cb.setSelectedIndex(0);
            }
            this.cb.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    String s = ((JComboBox)e.getSource()).getSelectedItem().toString();
                    if (s.equals(this.this$1.none)) {
                        return;
                    }
                    QAF q = QAF.getQAF(s);
                    ((Task)this.this$1.node).setQAF(q);
                }
            });
            this.add(new JLabel(" "));
            this.add(new JLabel(" "));
            JPanel panel = new JPanel();
            panel.setLayout(new VFlowLayout(0, true));
            panel.add(new JLabel("Subtask Ordering", 4));
            this.b = new JButton("Move Up");
            panel.add(this.b);
            this.b.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    Task task = (Task)this.this$1.node;
                    if (this.this$1.sl == null) {
                        return;
                    }
                    if (!task.hasSubtasks()) {
                        return;
                    }
                    String n = (String)this.this$1.sl.getSelectedValue();
                    if (n == null) {
                        return;
                    }
                    TaskBase tb = (TaskBase)task.findNode(new TaskBase(n, null));
                    int i = task.getSubtaskPosition(tb);
                    if (i > 0) {
                        Taems.access$202(TaemsEdit.access$000(this.this$1), n);
                        task.removeSubtask(tb);
                        task.insertSubtask(tb, i - 1);
                    }
                }
            });
            this.b = new JButton("Move Down");
            panel.add(this.b);
            this.b.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    Task task = (Task)this.this$1.node;
                    if (this.this$1.sl == null) {
                        return;
                    }
                    if (!task.hasSubtasks()) {
                        return;
                    }
                    String n = (String)this.this$1.sl.getSelectedValue();
                    if (n == null) {
                        return;
                    }
                    TaskBase tb = (TaskBase)task.findNode(new TaskBase(n, null));
                    int i = task.getSubtaskPosition(tb);
                    if (i >= 0 && i < task.numSubtasks() - 1) {
                        Taems.access$202(TaemsEdit.access$000(this.this$1), n);
                        task.removeSubtask(tb);
                        task.insertSubtask(tb, i + 1);
                    }
                }
            });
            this.add(panel);
            Vector<String> v = new Vector<String>();
            e = task.getSubtasks();
            int select = 0;
            int i2 = 0;
            while (e.hasMoreElements()) {
                String n = ((Node)e.nextElement()).getLabel();
                v.addElement(n);
                if (n.equals(Taems.this.last_selectnode)) {
                    select = i2;
                }
                ++i2;
            }
            this.c = this.sl = new JList(v);
            this.add(this.sl);
            this.sl.setSelectedIndex(select);
            this.add(new JLabel(" "));
            this.add(new JLabel(" "));
            this.add(new JLabel(" "));
            this.b = new JButton("Add new sub-Task");
            this.add(this.b);
            this.b.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    String name = this.this$1.askString("Enter the new Task's label:", this.this$1.node.getLabel() + "_T" + (((Task)this.this$1.node).numSubtasks() + 1));
                    if (name == null) {
                        return;
                    }
                    Task t = new Task(this.this$1.parseLabel(name), this.this$1.node.getAgent(), new SumQAF());
                    ((Task)this.this$1.node).addSubtask(t);
                    this.this$1.selectNode(t);
                }
            });
            this.add(new JLabel(" "));
            this.b = new JButton("Add new sub-Method");
            this.add(this.b);
            this.b.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    String name = this.this$1.askString("Enter the new Method's label:", this.this$1.node.getLabel() + "_M" + (((Task)this.this$1.node).numSubtasks() + 1));
                    if (name == null) {
                        return;
                    }
                    Method m = new Method(this.this$1.parseLabel(name), this.this$1.node.getAgent());
                    m.addOutcome(new Outcome("Outcome_1", new Distribution(1.0f, 1.0f), new Distribution(1.0f, 1.0f), new Distribution(1.0f, 1.0f), 1.0f));
                    ((Task)this.this$1.node).addSubtask(m);
                    this.this$1.selectNode(m);
                }
            });
        }

        public void generateResourceEdits() {
            Resource resource = (Resource)this.node;
            this.add(new JLabel("Model", 4));
            this.cb = new JComboBox();
            this.add(this.cb);
            this.cb.addItem("Consumable");
            if (resource instanceof ConsumableResource) {
                this.cb.setSelectedIndex(0);
            }
            this.cb.addItem("Non-Consumable");
            if (resource instanceof NonConsumableResource) {
                this.cb.setSelectedIndex(1);
            }
            this.cb.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    Resource r = (Resource)this.this$1.node;
                    Resource n = null;
                    String s = ((JComboBox)e.getSource()).getSelectedItem().toString();
                    if (s.equals(this.this$1.none)) {
                        return;
                    }
                    if (s.startsWith("C") && !(r instanceof ConsumableResource)) {
                        n = new ConsumableResource(r.getLabel(), r.getAgent(), r.getState(), r.getDepletedAt(), r.getOverloadedAt());
                    }
                    if (s.startsWith("N") && !(r instanceof NonConsumableResource)) {
                        n = new NonConsumableResource(r.getLabel(), r.getAgent(), r.getState(), r.getDepletedAt(), r.getOverloadedAt());
                    }
                    if (n != null) {
                        r.copy(n);
                        TaemsEdit.access$000(this.this$1).addNode(n);
                        r.transferInterrelationships(n);
                        TaemsEdit.access$000(this.this$1).removeNode(r);
                        if (TaemsEdit.access$000((TaemsEdit)this.this$1).display != null) {
                            TaemsEdit.access$000((TaemsEdit)this.this$1).display.selectNode(n);
                        }
                    }
                }
            });
            this.add(new JLabel("State", 4));
            String s = resource.getState() == Double.NEGATIVE_INFINITY ? "" : String.valueOf(resource.getState());
            this.c = new JTextField(s);
            this.add(this.c);
            this.setTextActor(this.c, new TextActor(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleText(String s) {
                    ((Resource)this.this$1.node).setState(this.this$1.parseDouble(s));
                }
            });
            this.add(new JLabel("Depleted At", 4));
            s = resource.getDepletedAt() == Double.NEGATIVE_INFINITY ? "" : String.valueOf(resource.getDepletedAt());
            this.c = new JTextField(s);
            this.add(this.c);
            this.setTextActor(this.c, new TextActor(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleText(String s) {
                    ((Resource)this.this$1.node).setDepletedAt(this.this$1.parseDouble(s));
                }
            });
            this.add(new JLabel("Overloaded At", 4));
            s = resource.getOverloadedAt() == Double.NEGATIVE_INFINITY ? "" : String.valueOf(resource.getOverloadedAt());
            this.c = new JTextField(s);
            this.add(this.c);
            this.setTextActor(this.c, new TextActor(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleText(String s) {
                    ((Resource)this.this$1.node).setOverloadedAt(this.this$1.parseDouble(s));
                }
            });
            this.add(new JLabel(" "));
            this.add(new JLabel(" "));
        }

        public void generateNodeEdits() {
            this.add(new JLabel("Label", 4));
            this.c = new JTextField(this.node.getLabel());
            this.add(this.c);
            this.setTextActor(this.c, new TextActor(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleText(String s) {
                    this.this$1.node.setLabel(this.this$1.parseLabel(s));
                }
            });
            this.add(new JLabel("Agent", 4));
            this.cb = new JComboBox();
            this.add(this.cb);
            if (this.node.getAgent() == null) {
                this.cb.addItem(this.none);
            }
            Enumeration e = Taems.this.getAgents();
            int i = 0;
            while (e.hasMoreElements()) {
                Agent a = (Agent)e.nextElement();
                this.cb.addItem(a.getLabel());
                if (a.matches(this.node.getAgent())) {
                    this.cb.setSelectedIndex(i);
                }
                ++i;
            }
            if (this.node.getAgent() == null) {
                this.cb.setSelectedIndex(0);
            }
            this.cb.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == null) {
                        return;
                    }
                    String s = ((JComboBox)e.getSource()).getSelectedItem().toString();
                    if (s.equals(this.this$1.none)) {
                        return;
                    }
                    Agent a = new Agent(s);
                    this.this$1.node.setAgent(a);
                }
            });
        }

        public void generateOtherNodeEdits() {
            if (!(this.node instanceof Interrelationship)) {
                this.add(new JLabel(" "));
                this.b = new JButton("Add new Interrelationship");
                this.add(this.b);
                this.b.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TaemsEdit this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent e) {
                        String name = this.this$1.askString("Enter the new Interrelationship's label:", "IR_" + this.this$1.node.getLabel());
                        if (name == null) {
                            return;
                        }
                        TreeSet<String> v = new TreeSet<String>();
                        Enumeration en = TaemsEdit.access$000(this.this$1).getAllNodes();
                        while (en.hasMoreElements()) {
                            Node n = (Node)en.nextElement();
                            if (n instanceof Interrelationship) continue;
                            v.add(n.getLabel());
                        }
                        String dest = (String)JOptionPane.showInputDialog(this.this$1, "Choose a destination node:", "Input", 3, null, v.toArray(), v.toArray()[0]);
                        if (dest == null) {
                            return;
                        }
                        Node d = TaemsEdit.access$000(this.this$1).findNode(new Node(dest));
                        if (d == null) {
                            System.err.println("Error, node " + dest + " not found");
                        }
                        EnablesInterrelationship i = new EnablesInterrelationship(this.this$1.parseLabel(name), this.this$1.node.getAgent(), new Distribution(0.0f, 1.0f));
                        i.setCost(new Distribution(0.0f, 1.0f));
                        i.setQuality(new Distribution(0.0f, 1.0f));
                        i.setDuration(new Distribution(0.0f, 1.0f));
                        this.this$1.node.addInterrelationship(i, d);
                        this.this$1.selectNode(i);
                    }
                });
            }
            this.add(new JLabel(" "));
            this.add(new JLabel(" "));
            this.add(new JLabel("Attributes", 4));
            this.cb = new JComboBox();
            this.add(this.cb);
            if (this.node.numAttributes() == 0) {
                this.cb.addItem(this.none);
            }
            Enumeration e = this.node.getAttributes();
            int i = 0;
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                this.cb.addItem(o);
                if (i == 0) {
                    this.attrib = o;
                    this.cb.setSelectedIndex(0);
                }
                if (o.equals(Taems.this.last_attrib)) {
                    this.attrib = o;
                    this.cb.setSelectedIndex(i);
                }
                ++i;
            }
            Taems.this.last_attrib = this.attrib;
            if (this.node.numAttributes() == 0) {
                this.cb.setSelectedIndex(0);
            }
            this.cb.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    String s = ((JComboBox)e.getSource()).getSelectedItem().toString();
                    if (s.equals(this.this$1.none)) {
                        return;
                    }
                    this.this$1.attrib = s;
                    Taems.access$302(TaemsEdit.access$000(this.this$1), this.this$1.attrib);
                    Object o = this.this$1.node.getAttribute(this.this$1.attrib);
                    if (o == null) {
                        return;
                    }
                    this.this$1.atl.setText(this.this$1.attrib.toString());
                    s = Converter.getPropertyType(o);
                    if (s == null) {
                        s = "Unknown";
                    }
                    this.this$1.att.setText(s);
                    this.this$1.atd.setText(Converter.unTypeProperty(o.toString(), null));
                }
            });
            this.add(new JLabel("Attribute Label", 4));
            String s = this.attrib == null ? "" : this.attrib.toString();
            this.atl = new JTextField(s);
            this.c = this.atl;
            this.add(this.atl);
            this.setTextActor(this.c, new TextActor(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleText(String s) {
                    if (this.this$1.attrib == null) {
                        return;
                    }
                    Object o = this.this$1.node.getAttribute(this.this$1.attrib);
                    if (o == null) {
                        return;
                    }
                    if (s.equals(this.this$1.attrib.toString())) {
                        return;
                    }
                    Object save = this.this$1.attrib;
                    this.this$1.node.setAttribute(s, o);
                    this.this$1.node.removeAttribute(save);
                }
            });
            this.add(new JLabel("Attribute Type", 4));
            if (this.attrib != null && this.node.hasAttribute(this.attrib)) {
                s = Converter.getPropertyType(this.node.getAttribute(this.attrib));
                if (s == null) {
                    s = "Unknown";
                }
            } else {
                s = "";
            }
            this.att = new JTextField(s);
            this.add(this.att);
            this.add(new JLabel("Attribute Data", 4));
            s = this.attrib == null || !this.node.hasAttribute(this.attrib) ? "" : this.node.getAttribute(this.attrib).toString();
            this.atd = new JTextField(s);
            this.c = this.atd;
            this.add(this.atd);
            this.setTextActor(this.c, new TextActor(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleText(String s) {
                    if (this.this$1.attrib == null) {
                        return;
                    }
                    Object o = this.this$1.node.getAttribute(this.this$1.attrib);
                    String type = this.this$1.att.getText();
                    if (type != null) {
                        try {
                            o = Converter.reTypeProperty(s, type);
                        }
                        catch (Exception e) {
                            o = null;
                        }
                        if (o != null) {
                            this.this$1.node.setAttribute(this.this$1.attrib, o);
                        } else {
                            System.err.println("Error parsing " + type + " attribute data");
                        }
                    }
                }
            });
            this.b = new JButton("Delete Attribute");
            this.add(this.b);
            this.b.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    if (this.this$1.attrib == null) {
                        return;
                    }
                    this.this$1.node.removeAttribute(this.this$1.attrib);
                }
            });
            this.b = new JButton("Add new Attribute");
            this.add(this.b);
            this.b.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    String name = this.this$1.askString("Enter the new attributes's name:", "Attribute_" + (this.this$1.node.numAttributes() + 1));
                    if (name == null) {
                        return;
                    }
                    Taems.access$302(TaemsEdit.access$000(this.this$1), name);
                    String o = new String("data");
                    this.this$1.node.setAttribute(name, o);
                }
            });
            this.add(new JLabel(" "));
            this.add(new JLabel(" "));
            this.add(new JLabel(" "));
            this.b = new JButton("Delete Node");
            this.add(this.b);
            this.b.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.node.delete();
                    TaemsEdit.access$000(this.this$1).removeNode(this.this$1.node);
                    this.this$1.selectNode(null);
                }
            });
        }

        public void generateTaemsEdits() {
            this.add(new JLabel("Label", 4));
            this.c = new JTextField(Taems.this.getLabel());
            this.add(this.c);
            this.setTextActor(this.c, new TextActor(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleText(String s) {
                    TaemsEdit.access$000(this.this$1).setLabel(this.this$1.parseLabel(s));
                }
            });
            this.add(new JLabel(" "));
            this.add(new JLabel(" "));
            this.add(new JLabel("Agents", 4));
            this.cb = new JComboBox();
            this.add(this.cb);
            Enumeration e = Taems.this.getAgents();
            if (!e.hasMoreElements()) {
                this.cb.addItem(this.none);
                this.cb.setSelectedIndex(0);
            }
            int i = 0;
            while (e.hasMoreElements()) {
                Agent a = (Agent)e.nextElement();
                this.cb.addItem(a.getLabel());
                if (i == 0) {
                    this.agent = a;
                }
                ++i;
            }
            this.cb.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    String s = ((JComboBox)e.getSource()).getSelectedItem().toString();
                    if (s.equals(this.this$1.none)) {
                        return;
                    }
                    Agent a = TaemsEdit.access$000(this.this$1).findAgent(new Agent(s));
                    if (a == null) {
                        return;
                    }
                    this.this$1.agent = a;
                    this.this$1.al.setText(this.this$1.agent.getLabel() == null ? "" : this.this$1.agent.getLabel());
                }
            });
            this.add(new JLabel("Agent Label", 4));
            String s = this.agent == null ? "" : this.agent.getLabel();
            this.al = new JTextField(s);
            this.c = this.al;
            this.add(this.al);
            this.setTextActor(this.c, new TextActor(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleText(String s) {
                    if (this.this$1.agent == null) {
                        return;
                    }
                    this.this$1.agent.setLabel(this.this$1.parseLabel(s));
                }
            });
            this.b = new JButton("Delete Agent");
            this.add(this.b);
            this.b.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    if (this.this$1.agent == null) {
                        return;
                    }
                    TaemsEdit.access$000(this.this$1).removeAgent(this.this$1.agent);
                }
            });
            this.b = new JButton("Add new Agent");
            this.add(this.b);
            this.b.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    String name = this.this$1.askString("Enter the new agent's name", "Agent_" + (TaemsEdit.access$000(this.this$1).numAgents() + 1));
                    if (name == null) {
                        return;
                    }
                    Agent a = new Agent(this.this$1.parseLabel(name));
                    TaemsEdit.access$000(this.this$1).addAgent(a);
                }
            });
            this.add(new JLabel(" "));
            this.add(new JLabel(" "));
            this.add(new JLabel(" "));
            this.b = new JButton("Add new Task Group");
            this.add(this.b);
            this.b.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    String name = this.this$1.askString("Enter the new Task Group's label:", "Goal_" + (TaemsEdit.access$000(this.this$1).numTaskGroups() + 1));
                    if (name == null) {
                        return;
                    }
                    Task t = new Task(this.this$1.parseLabel(name), TaemsEdit.access$000(this.this$1).getAgent(), new SumQAF());
                    TaemsEdit.access$000(this.this$1).addNode(t);
                    this.this$1.selectNode(t);
                }
            });
            this.add(new JLabel(" "));
            this.b = new JButton("Add new Resource");
            this.add(this.b);
            this.b.addActionListener(new ActionListener(this){
                private final /* synthetic */ TaemsEdit this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    String name = this.this$1.askString("Enter the new Resource's label:", "Rsrc_" + (TaemsEdit.access$000(this.this$1).numResources() + 1));
                    if (name == null) {
                        return;
                    }
                    ConsumableResource r = new ConsumableResource(this.this$1.parseLabel(name), TaemsEdit.access$000(this.this$1).getAgent(), 0.0, 0.0, 100.0);
                    TaemsEdit.access$000(this.this$1).addNode(r);
                    this.this$1.selectNode(r);
                }
            });
        }

        public void setTextActor(JComponent c, TextActor a) {
            c.addKeyListener(new MyKeyAdapter(a));
            c.addFocusListener(new MyFocusAdapter(a));
        }

        public String askString(String message, String def) {
            JOptionPane pane = new JOptionPane(message, 3, 2);
            pane.setWantsInput(true);
            pane.setInitialValue(def);
            pane.setInitialSelectionValue(def);
            JDialog dialog = pane.createDialog(this, "Input");
            dialog.setVisible(true);
            if (pane.getValue() != null && pane.getValue() instanceof Integer && (Integer)pane.getValue() == 0) {
                return (String)pane.getInputValue();
            }
            return null;
        }

        public Distribution parseDistribution(String s) {
            if (s == null) {
                return null;
            }
            if ((s = s.trim()).equals("")) {
                return null;
            }
            try {
                return new Distribution(s);
            }
            catch (Exception e) {
                System.err.println("Incorrectly formatted distribution specified");
                return null;
            }
        }

        public float parseFloat(String s) {
            if (s == null) {
                return Float.NEGATIVE_INFINITY;
            }
            if ((s = s.trim()).equals("")) {
                return Float.NEGATIVE_INFINITY;
            }
            try {
                return Float.parseFloat(s);
            }
            catch (Exception e) {
                System.err.println("Incorrectly formatted float specified");
                return Float.NEGATIVE_INFINITY;
            }
        }

        public double parseDouble(String s) {
            if (s == null) {
                return Double.NEGATIVE_INFINITY;
            }
            if ((s = s.trim()).equals("")) {
                return Double.NEGATIVE_INFINITY;
            }
            try {
                return Double.parseDouble(s);
            }
            catch (Exception e) {
                System.err.println("Incorrectly formatted double specified");
                return Double.NEGATIVE_INFINITY;
            }
        }

        public int parseInteger(String s) {
            if (s == null) {
                return Integer.MIN_VALUE;
            }
            if ((s = s.trim()).equals("")) {
                return Integer.MIN_VALUE;
            }
            try {
                return Integer.parseInt(s);
            }
            catch (Exception e) {
                System.err.println("Incorrectly formatted integer specified");
                return Integer.MIN_VALUE;
            }
        }

        public String parseLabel(String s) {
            if (s == null) {
                return null;
            }
            if ((s = s.trim()).equals("")) {
                return null;
            }
            s = s.replace(' ', '_');
            return s;
        }

        public void selectNode(Node n) {
            if (Taems.this.display != null) {
                Taems.this.display.selectNode(n);
            }
        }

        static /* synthetic */ Taems access$000(TaemsEdit x0) {
            return x0.Taems.this;
        }

        class MyFocusAdapter
        extends FocusAdapter {
            TextActor actor;

            public MyFocusAdapter(TextActor a) {
                this.actor = a;
            }

            public void focusLost(FocusEvent e) {
                if (e.getSource() == null) {
                    return;
                }
                String s = ((JTextField)e.getSource()).getText();
                this.actor.handleText(s);
            }
        }

        class MyKeyAdapter
        extends KeyAdapter {
            TextActor actor;

            public MyKeyAdapter(TextActor a) {
                this.actor = a;
            }

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    String s = ((JTextField)e.getSource()).getText();
                    this.actor.handleText(s);
                }
            }
        }

        abstract class TextActor {
            TextActor() {
            }

            public abstract void handleText(String var1);
        }
    }
}

