/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import taems.ScheduleElement;

public class ScheduleElementDisplay
implements MouseListener {
    protected ScheduleElement scheduleElement;
    protected Point localization;

    public ScheduleElementDisplay(ScheduleElement l) {
        this.scheduleElement = l;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public String getPaintLabel() {
        return this.getPaintLabel(2048);
    }

    public String getPaintLabel(int max) {
        String label = this.scheduleElement.getLabel();
        return label;
    }

    public void paint(Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int x = this.localization.x;
        int y = this.localization.y;
        Dimension d = this.getSize(g);
        int w = d.width;
        int h = d.height;
        g.fillRect(x - w / 2, y - h / 2, w, h);
        g.setColor(Color.black);
        g.drawRect(x - w / 2, y - h / 2, w - 1, h - 1);
        try {
            int numMaxOfCharToDisplay = (d.width + this.getPaintLabel().length()) / (fm.stringWidth(this.getPaintLabel()) + 10);
            g.drawString(this.getPaintLabel(numMaxOfCharToDisplay), x - (w - 10) / 2, y - (h - 4) / 2 + fm.getAscent());
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            System.err.println("God damn it, again an error: This is NOT OUR FAULT ");
        }
    }

    public int getTimeIncrement() {
        return this.scheduleElement.getSchedule().getTimeIncrement();
    }

    public void setLocation(Point i) {
        this.localization = i;
    }

    public Dimension getSize(Graphics g) {
        Dimension d = new Dimension();
        try {
            FontMetrics fm = g.getFontMetrics();
            d.width = this.scheduleElement.getDuration() != -1 ? this.getTimeIncrement() * this.scheduleElement.getDuration() : 0;
            d.height = fm.getHeight() + 4;
            return d;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            System.err.println("God damn it, again an error: This is NOT OUR FAULT ");
            return new Dimension(60, 30);
        }
    }
}

