/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import taems.ExactlyOneQAF;
import taems.LastQAF;
import taems.MaxQAF;
import taems.MinQAF;
import taems.Node;
import taems.SeqLastQAF;
import taems.SeqMaxQAF;
import taems.SeqMinQAF;
import taems.SeqSumQAF;
import taems.SumAllQAF;
import taems.SumQAF;

public abstract class QAF
implements Serializable,
Cloneable {
    protected String label = "";
    protected static final Vector qafs = new Vector();

    public QAF(String l) {
        this.label = l;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String l) {
        this.label = l;
    }

    public static Enumeration getQAFs() {
        return qafs.elements();
    }

    protected static void registerQAF(QAF q) {
        qafs.addElement(q);
    }

    public static QAF getQAF(String s) {
        Enumeration e = QAF.getQAFs();
        while (e.hasMoreElements()) {
            QAF q = (QAF)e.nextElement();
            if (!q.getLabel().equals(s)) continue;
            return q;
        }
        return null;
    }

    public float calculateQuality(Enumeration e) {
        System.err.println("Warning: QAF " + this.getLabel() + " is not functional");
        return 0.0f;
    }

    public float calculateMaximumQuality(Enumeration e) {
        System.err.println("Warning: QAF " + this.getLabel() + " is not functional");
        return 0.0f;
    }

    public boolean matches(QAF q) {
        return q == null || Node.matches(q.getLabel(), this.getLabel());
    }

    public Object clone() {
        QAF cloned = null;
        try {
            cloned = (QAF)super.clone();
        }
        catch (Exception e) {
            System.out.println("Clone Error: " + e);
        }
        cloned.setLabel(new String(this.label));
        return cloned;
    }

    static {
        QAF.registerQAF(new MinQAF());
        QAF.registerQAF(new MaxQAF());
        QAF.registerQAF(new SumQAF());
        QAF.registerQAF(new SumAllQAF());
        QAF.registerQAF(new ExactlyOneQAF());
        QAF.registerQAF(new LastQAF());
        QAF.registerQAF(new SeqMinQAF());
        QAF.registerQAF(new SeqMaxQAF());
        QAF.registerQAF(new SeqSumQAF());
        QAF.registerQAF(new SeqLastQAF());
    }
}

