/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.io.Serializable;
import taems.Interrelationship;
import taems.MLCSchedule;
import taems.Precondition;
import taems.ScheduleElement;
import taems.VirtualScheduleElement;
import utilities.Log;

public class PrecedencePrecondition
extends Precondition
implements Serializable,
Cloneable {
    protected Interrelationship ir;
    protected Log log = Log.getDefault();
    protected boolean fake = false;

    public PrecedencePrecondition(MLCSchedule p, ScheduleElement se, Interrelationship i) {
        this.parentMLC = p;
        this.setScheduleElement(se);
        if (i != null) {
            this.setInterrelationship(i);
        }
    }

    public PrecedencePrecondition(MLCSchedule p, ScheduleElement se, boolean SEQ) {
        this.parentMLC = p;
        this.setScheduleElement(se);
        this.fake = SEQ;
    }

    public Interrelationship getInterrelationship() {
        return this.ir;
    }

    public void setInterrelationship(Interrelationship i) {
        this.ir = i;
    }

    public boolean isArtificialIR() {
        return this.fake;
    }

    public void setArtificialIR() {
        this.fake = true;
    }

    public boolean check(int time) {
        boolean answer = true;
        String reason = "";
        if (this.optional) {
            return true;
        }
        if (!this.conditioningSE.hasFinished()) {
            answer = false;
            reason = "Method not yet finished";
        } else if (this.ir != null && !this.ir.getActive()) {
            answer = false;
            reason = "Delay not yet activated";
        }
        this.log.log("#### Checking : " + this.output() + " is " + answer + " [" + reason + "]", 2);
        return answer;
    }

    public void completed(int time) {
    }

    public void clear() {
    }

    public String output() {
        StringBuffer sb = new StringBuffer();
        sb.append("Precedence : Method " + this.conditioningSE.getMethod().getLabel());
        if (this.ir != null) {
            sb.append(" IR " + this.ir.getLabel());
        }
        return sb.toString();
    }

    public Object clone() {
        PrecedencePrecondition cloned = new PrecedencePrecondition(null, (ScheduleElement)new VirtualScheduleElement(this.conditioningSE.getID()), this.getInterrelationship());
        cloned.setOptional(this.isOptional());
        cloned.fake = this.isArtificialIR();
        return cloned;
    }

    public String toTTaems(float v) {
        StringBuffer sb = new StringBuffer("           (spec_precedence_precondition\n");
        if (this.getScheduleElement() instanceof VirtualScheduleElement) {
            sb.append("             (virtual_schedule_element " + this.getScheduleElement().getID() + ")\n");
        } else {
            sb.append("              (schedule_element " + this.getScheduleElement().getLabel() + ")\n");
            sb.append("; Reference " + this.getScheduleElement().getID() + "\n");
            if (this.getScheduleElement().getStartTime() == null && this.getScheduleElement().getDurationDistribution() == null) {
                sb.append(";             ** Note: schedule_element may be virtual\n");
            }
        }
        if (this.ir != null) {
            sb.append("              (interrelationship " + this.getInterrelationship().getLabel() + ")\n");
        }
        if (this.fake) {
            sb.append(";             ** Note: interrelationship is virtual\n;              ** from SEQuence QAF\n");
        }
        if (this.isOptional()) {
            sb.append(";; Optional Precedence relation");
        }
        sb.append("           )\n");
        return sb.toString();
    }
}

