/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import taems.Agent;
import taems.Interrelationship;
import taems.Method;
import taems.NodeFinderEnumeration;
import taems.NodeUpdateEvent;
import taems.NodeUpdateEventListener;
import taems.Outcome;
import taems.VirtualNode;
import utilities.Converter;
import utilities.Distribution;
import utilities.EnumerationEnumeration;

public class Node
implements Serializable,
Cloneable,
NodeUpdateEventListener,
Comparable {
    public static final int NORMAL = 0;
    public static final int EXECUTING = 1;
    public static final int COMPLETED = 2;
    public static final int ACTIVE = 3;
    public static final int OVERLOADED = 4;
    public static final int UNDERLOADED = 5;
    public static final int DISABLED = 6;
    public static final int HIDDEN = 1;
    public static final int SELECTED = 2;
    public static final int COLLAPSED = 3;
    protected String label = "";
    protected Agent agent = null;
    protected Vector outirs = new Vector();
    protected Vector inirs = new Vector();
    protected Hashtable attributes = new Hashtable();
    protected int status;
    protected transient long flags = 0L;
    protected transient Vector listeners = new Vector();
    protected static final int H_MARGIN = 5;
    protected static final int V_MARGIN = 2;
    protected transient Rectangle rect = null;
    protected transient Point loc = null;
    protected static Font normalFont = new Font("SansSerif", 0, 12);
    protected static Font mediumFont = new Font("SansSerif", 0, 10);
    protected static Font smallFont = new Font("SansSerif", 0, 8);
    protected static Stroke normalstroke = new BasicStroke();
    protected static Stroke collapsedstroke = new BasicStroke(2.0f);
    private FontMetrics wsavefm;
    private FontMetrics hsavefm;

    public Node(String l, Agent a) {
        this.label = l;
        this.agent = a;
    }

    public Node(String l) {
        this(l, null);
    }

    public Node() {
        this(null, null);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String l) {
        if (this.getLabel() != null && this.getLabel().equals(l)) {
            return;
        }
        this.label = l;
        this.rect = null;
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
    }

    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent a) {
        if (this.getAgent() != null && a != null && this.getAgent().matches(a)) {
            return;
        }
        this.agent = a;
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
    }

    public boolean isVirtual() {
        return false;
    }

    public void addNodeUpdateEventListener(NodeUpdateEventListener o) {
        if (o == this) {
            System.err.println("Warning: Node " + this.getLabel() + " just started listening to itself");
        }
        this.listeners.addElement(o);
    }

    public void removeNodeUpdateEventListener(NodeUpdateEventListener o) {
        this.listeners.removeElement(o);
    }

    protected void fireNodeUpdateEvent(NodeUpdateEvent ev) {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            NodeUpdateEventListener l = (NodeUpdateEventListener)e.nextElement();
            switch (ev.getID()) {
                case 0: {
                    l.valueUpdate(ev);
                    break;
                }
                case 1: {
                    l.graphicUpdate(ev);
                    break;
                }
                case 2: {
                    l.placementUpdate(ev);
                    break;
                }
                case 3: {
                    l.structureUpdate(ev);
                }
            }
        }
    }

    public void valueUpdate(NodeUpdateEvent e) {
        this.fireNodeUpdateEvent(e);
    }

    public void graphicUpdate(NodeUpdateEvent e) {
        this.fireNodeUpdateEvent(e);
    }

    public void placementUpdate(NodeUpdateEvent e) {
        this.fireNodeUpdateEvent(e);
    }

    public void structureUpdate(NodeUpdateEvent e) {
        this.fireNodeUpdateEvent(e);
    }

    public Object getAttribute(Object k) {
        return this.attributes.get(k.toString());
    }

    public void setAttribute(Object k, Object d) {
        if (d == null) {
            this.removeAttribute(k);
        } else {
            Object o = this.getAttribute(k);
            if (o == null || !o.toString().equals(d.toString())) {
                this.attributes.put(k.toString(), d);
                this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
            }
        }
    }

    public void removeAttribute(Object k) {
        if (this.attributes.remove(k.toString()) != null) {
            this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
        }
    }

    public Enumeration getAttributes() {
        return this.attributes.keys();
    }

    public boolean hasAttribute(Object k) {
        return this.attributes.containsKey(k.toString());
    }

    protected Hashtable getAttributesTable() {
        return this.attributes;
    }

    public int numAttributes() {
        return this.attributes.size();
    }

    public void addInterrelationship(Interrelationship i, Outcome o, Node t) {
        i.setEndpoints(this, o, t);
    }

    public void addInterrelationship(Interrelationship i, Node t) {
        i.setEndpoints(this, null, t);
    }

    public void removeInterrelationship(Interrelationship i) {
        if (this.outirs.contains(i) || this.inirs.contains(i)) {
            i.excise();
        }
    }

    public Enumeration getOutInterrelationships() {
        Vector v = new Vector();
        v.addElement(this.outirs.elements());
        return new EnumerationEnumeration(v, true);
    }

    public Enumeration getOutInterrelationships(Interrelationship i) {
        return new NodeFinderEnumeration(this.outirs.elements(), (Node)i);
    }

    protected void addOutInterrelationship(Interrelationship i) {
        if (this instanceof Interrelationship) {
            System.err.println("Error: Cannot attach an IR to another IR");
            return;
        }
        this.outirs.addElement(i);
        i.addNodeUpdateEventListener(this);
    }

    protected void removeOutInterrelationship(Interrelationship i) {
        this.outirs.removeElement(i);
        i.removeNodeUpdateEventListener(this);
    }

    public boolean hasOutInterrelationships() {
        return this.outirs.size() > 0;
    }

    public int numOutInterrelationships() {
        return this.outirs.size();
    }

    public Enumeration getInInterrelationships() {
        Vector v = new Vector();
        v.addElement(this.inirs.elements());
        return new EnumerationEnumeration(v, true);
    }

    public Enumeration getInInterrelationships(Interrelationship i) {
        return new NodeFinderEnumeration(this.inirs.elements(), (Node)i);
    }

    protected void addInInterrelationship(Interrelationship i) {
        if (this instanceof Interrelationship) {
            System.err.println("Error: Cannot attach an IR to another IR");
            return;
        }
        this.inirs.addElement(i);
    }

    protected void removeInInterrelationship(Interrelationship i) {
        this.inirs.removeElement(i);
    }

    public boolean hasInInterrelationships() {
        return this.inirs.size() > 0;
    }

    public int numInInterrelationships() {
        return this.inirs.size();
    }

    public boolean hasInterrelationships() {
        return this.hasInInterrelationships() || this.hasOutInterrelationships();
    }

    public Node excise() {
        VirtualNode vme = new VirtualNode(this.getLabel());
        this.transferInterrelationships(vme);
        return vme;
    }

    public void delete() {
        Interrelationship i;
        while (this.hasInInterrelationships()) {
            i = (Interrelationship)this.inirs.firstElement();
            i.delete();
        }
        while (this.hasOutInterrelationships()) {
            i = (Interrelationship)this.outirs.firstElement();
            i.delete();
        }
    }

    public void transferInterrelationships(Node n) {
        Interrelationship i;
        if (this == n) {
            return;
        }
        while (this.hasInInterrelationships()) {
            i = (Interrelationship)this.inirs.firstElement();
            i.setTo(n);
        }
        while (this.hasOutInterrelationships()) {
            i = (Interrelationship)this.outirs.firstElement();
            if (i.getFromOutcome() != null && n instanceof Method) {
                i.setFrom(n, ((Method)n).getOutcome(i.getFromOutcome().getLabel()));
                continue;
            }
            i.setFrom(n);
        }
    }

    public Enumeration getAffectingInterrelationships() {
        return this.getInInterrelationships();
    }

    public Enumeration getAffectedInterrelationships() {
        return this.getOutInterrelationships();
    }

    public boolean matches(Node n) {
        if (!Node.matches(n.getLabel(), this.getLabel())) {
            return false;
        }
        return Node.matches(n.getAgent(), this.getAgent());
    }

    protected static boolean matches(String check, String current) {
        if (check != null) {
            if (current == null) {
                return false;
            }
            if (!current.equals(check)) {
                return false;
            }
        }
        return true;
    }

    protected static boolean matches(Agent check, Agent current) {
        if (check != null) {
            if (current == null) {
                return false;
            }
            if (!current.matches(check)) {
                return false;
            }
        }
        return true;
    }

    protected static boolean matches(int check, int current) {
        return check == Integer.MIN_VALUE || current == check;
    }

    protected static boolean matches(long check, long current) {
        return check == Long.MIN_VALUE || current == check;
    }

    protected static boolean matches(float check, float current) {
        return check == Float.NEGATIVE_INFINITY || current == check;
    }

    protected static boolean matches(double check, double current) {
        return check == Double.NEGATIVE_INFINITY || current == check;
    }

    protected static boolean matches(Boolean check, Boolean current) {
        if (check != null) {
            if (current == null) {
                return false;
            }
            if (current.booleanValue() != check.booleanValue()) {
                return false;
            }
        }
        return true;
    }

    protected static boolean matches(Distribution check, Distribution current) {
        if (check != null) {
            if (current == null) {
                return false;
            }
            if (!current.equals(check)) {
                return false;
            }
        }
        return true;
    }

    public Enumeration findNodes(Node n) {
        return new NodeFinderEnumeration(this, n);
    }

    public Node findNode(Node n) {
        Enumeration e = this.findNodes(n);
        if (e.hasMoreElements()) {
            return (Node)e.nextElement();
        }
        return null;
    }

    public void copy(Node n) {
        if (this.label != null) {
            n.setLabel(new String(this.label));
        } else {
            n.setLabel("");
        }
        if (this.agent != null) {
            n.agent = (Agent)this.agent.clone();
        } else {
            n.setAgent(null);
        }
        if (this.attributes != null) {
            n.attributes = (Hashtable)this.attributes.clone();
        }
        n.setStatus(this.getStatus());
    }

    public Object clone() {
        Node cloned = null;
        try {
            cloned = (Node)super.clone();
            cloned.listeners = new Vector();
        }
        catch (Exception e) {
            System.out.println("Clone Error: " + e);
        }
        this.copy(cloned);
        cloned.outirs = new Vector();
        Enumeration e = this.getOutInterrelationships();
        while (e.hasMoreElements()) {
            Interrelationship i = (Interrelationship)((Interrelationship)e.nextElement()).clone();
            i.setFrom(cloned, null);
        }
        cloned.inirs = new Vector();
        return cloned;
    }

    public static String attributesToString(Hashtable attrs, float v) {
        StringBuffer sb = new StringBuffer("");
        if (v > 1.0f) {
            Enumeration e = attrs.keys();
            boolean gotsome = e.hasMoreElements();
            if (gotsome) {
                sb.append("   (spec_attributes\n");
            }
            while (e.hasMoreElements()) {
                Object k = e.nextElement();
                String key = k.toString();
                if (key.indexOf(" ") != -1 || key.indexOf("\t") != -1 || key.indexOf("\n") != -1 || key.indexOf("\r") != -1) {
                    sb.append(";     (<multi-line key ommitted>)\n");
                    continue;
                }
                Object d = attrs.get(k);
                String type = null;
                String data = Converter.unTypeProperty(d, null);
                if (data == null) {
                    if (d instanceof Node) {
                        data = ((Node)d).getLabel();
                        type = "Node ";
                        if (((Node)d).isVirtual()) {
                            sb.append(";   ** Note: Node " + data + " is virtual\n");
                        }
                    } else {
                        sb.append(";     (" + key + " <un-convertible " + d.getClass().toString() + " ommitted>)\n");
                        continue;
                    }
                }
                if (data.indexOf("\n") != -1 || data.indexOf("\r") != -1) {
                    sb.append(";     (" + key + " <multi-line data ommitted>)\n");
                    continue;
                }
                if (v >= 1.1f) {
                    if (type == null) {
                        type = d.getClass().getName();
                        type = type.substring(type.lastIndexOf(".") + 1) + " ";
                    }
                } else {
                    type = "";
                }
                sb.append("      (");
                sb.append(key);
                sb.append(" ");
                sb.append(type);
                sb.append(data);
                sb.append(")\n");
            }
            if (gotsome) {
                sb.append("   )\n");
            }
        }
        return sb.toString();
    }

    public String toTTaems(float v) {
        StringBuffer sb = new StringBuffer("");
        sb.append(Node.attributesToString(this.attributes, v));
        if (this.getLabel() != null) {
            sb.append("   (label " + this.getLabel() + ")\n");
        }
        if (this.getAgent() != null) {
            sb.append("   (agent " + this.agent.getLabel() + ")\n");
        }
        sb.append(";  ** In IRs: ");
        sb.append(this.numInInterrelationships());
        sb.append("\n");
        sb.append(";  ** Out IRs: ");
        sb.append(this.numOutInterrelationships());
        sb.append("\n");
        return sb.toString();
    }

    public String toString() {
        return this.toTTaems(1.1f);
    }

    public int compareTo(Object o) {
        return this.getLabel().compareTo(((Node)o).getLabel());
    }

    protected void setLocation(Point p) {
        this.loc = p;
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 1));
    }

    protected void offsetLocation(Point p) {
        Point np = new Point(this.getLocation().x + p.x, this.getLocation().y + p.y);
        this.setLocation(np);
    }

    public Point getLocation() {
        return this.loc;
    }

    public void setStatus(int s) {
        if (this.status != s) {
            this.status = s;
            this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 1));
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setSelected(boolean s) {
        if (s) {
            this.setFlag(2);
        } else {
            this.unsetFlag(2);
        }
    }

    public boolean isSelected() {
        return this.getFlag(2);
    }

    public void setHidden(boolean s) {
        if (s) {
            this.setFlag(1);
        } else {
            this.unsetFlag(1);
        }
    }

    public boolean isHidden() {
        return this.getFlag(1);
    }

    public void setCollapsed(boolean s) {
        if (s) {
            this.setFlag(3);
        } else {
            this.unsetFlag(3);
        }
    }

    public boolean isCollapsed() {
        return this.getFlag(3);
    }

    public void toggleCollapsed() {
        this.setCollapsed(!this.isCollapsed());
    }

    public boolean isVisible() {
        return !this.isHidden();
    }

    public void setFlag(int f) {
        if (!this.getFlag(f)) {
            this.flags |= (long)(1 << f);
            this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 1));
        }
    }

    public void unsetFlag(int f) {
        if (this.getFlag(f)) {
            this.flags &= (long)(~(1 << f));
            this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 1));
        }
    }

    public boolean getFlag(int f) {
        int mask = 1 << f;
        return (this.flags & (long)mask) == (long)mask;
    }

    public Rectangle getBounds() {
        return this.rect;
    }

    public boolean contains(Point p) {
        if (this.isHidden()) {
            return false;
        }
        if (this.rect != null) {
            return this.rect.contains(p);
        }
        return false;
    }

    public int calculateWidth(FontMetrics fm) {
        if (this.getLabel() == null) {
            return 0;
        }
        if (fm == this.wsavefm && this.rect != null) {
            return this.rect.width;
        }
        this.wsavefm = fm;
        return fm.stringWidth(this.getLabel()) + 10;
    }

    public int calculateTreeWidth(FontMetrics fm) {
        return this.calculateWidth(fm);
    }

    public int calculateHeight(FontMetrics fm) {
        if (this.getLabel() == null) {
            return 0;
        }
        if (fm == this.hsavefm && this.rect != null) {
            return this.rect.height;
        }
        this.hsavefm = fm;
        return fm.getHeight() + 4;
    }

    public int calculateTreeHeight(FontMetrics fm) {
        int height = this.calculateHeight(fm);
        return height;
    }

    public void paintLines(Graphics g) {
        Enumeration e = this.getOutInterrelationships();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            n.paintLines(g);
        }
    }

    public void updateBounds(FontMetrics fm) {
        if (this.getLocation() == null) {
            System.err.println("Warning, updateBounds for node " + this.getLabel() + " ran into null location");
            this.rect = new Rectangle(0, 0, 1, 1);
            return;
        }
        int x = this.loc.x;
        int y = this.loc.y;
        int w = this.calculateWidth(fm);
        int h = this.calculateHeight(fm);
        this.rect = new Rectangle(x - w / 2, y - h / 2, w, h);
    }

    public void paint(Graphics g) {
        g.setFont(normalFont);
        FontMetrics fm = g.getFontMetrics();
        this.updateBounds(fm);
        if (!this.isHidden()) {
            g.setColor(this.getBackground());
            g.fillRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
            g.setColor(Color.black);
            g.drawRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
            try {
                g.setColor(this.getForeground());
                g.drawString(this.getLabel(), this.rect.x + 5, this.rect.y + this.rect.height - (2 + fm.getDescent()));
            }
            catch (NullPointerException e) {
                System.err.println("Error drawing label");
                e.printStackTrace();
            }
        }
        Enumeration e = this.getOutInterrelationships();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            n.paint(g);
        }
    }

    public Dimension getSize(Graphics g) {
        return new Dimension(this.calculateWidth(g.getFontMetrics()), this.calculateHeight(g.getFontMetrics()));
    }

    protected Color getBackground() {
        Color c = Color.white;
        Object o = null;
        if (this.isSelected()) {
            o = this.getAttribute("Color_SELECTED");
            c = Color.yellow;
        } else {
            switch (this.getStatus()) {
                case 5: {
                    o = this.getAttribute("Color_UNDERLOADED");
                    c = Color.cyan;
                    break;
                }
                case 1: {
                    o = this.getAttribute("Color_EXECUTING");
                    c = Color.green;
                    break;
                }
                case 3: {
                    o = this.getAttribute("Color_ACTIVE");
                    c = Color.green;
                    break;
                }
                case 2: {
                    o = this.getAttribute("Color_COMPLETED");
                    c = Color.pink;
                    break;
                }
                case 4: {
                    o = this.getAttribute("Color_OVERLOADED");
                    c = Color.pink;
                    break;
                }
                case 6: {
                    o = this.getAttribute("Color_DISABLED");
                    c = Color.lightGray;
                    break;
                }
                case 0: {
                    o = this.getAttribute("Color_NORMAL");
                    c = Color.white;
                }
            }
        }
        if (o != null && o instanceof Vector) {
            Vector v = (Vector)o;
            String r = (String)v.elementAt(0);
            String g = (String)v.elementAt(1);
            String b = (String)v.elementAt(2);
            c = new Color(Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b));
        }
        return c;
    }

    protected Color getForeground() {
        return Color.black;
    }
}

