/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.io.Serializable;
import java.util.Enumeration;
import taems.QAF;
import taems.TaskBase;

public class MinQAF
extends QAF
implements Serializable,
Cloneable {
    public MinQAF() {
        super("q_min");
    }

    public float calculateQuality(Enumeration e) {
        float q = Float.MAX_VALUE;
        while (e.hasMoreElements()) {
            TaskBase t = (TaskBase)e.nextElement();
            float weight = 1.0f;
            if (!(t.getCurrentQuality() < q)) continue;
            if (t.getAttribute("weighting_factor") != null) {
                weight = ((Float)t.getAttribute("weighting_factor")).floatValue();
            }
            q = weight * t.getCurrentQuality();
        }
        if (q == Float.MAX_VALUE) {
            q = 0.0f;
        }
        return q;
    }

    public float calculateMaximumQuality(Enumeration e) {
        float q = Float.MAX_VALUE;
        while (e.hasMoreElements()) {
            TaskBase t = (TaskBase)e.nextElement();
            float weight = 1.0f;
            if (!(t.getMaximumQuality() < q)) continue;
            if (t.getAttribute("weighting_factor") != null) {
                weight = ((Float)t.getAttribute("weighting_factor")).floatValue();
            }
            q = weight * t.getMaximumQuality();
        }
        if (q == Float.MAX_VALUE) {
            q = 0.0f;
        }
        return q;
    }
}

