/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import taems.Agent;
import taems.Interrelationship;
import taems.Node;
import taems.NodeUpdateEvent;
import taems.Outcome;
import taems.SortedEnumerationByTimeStamp;
import taems.TaskBase;
import utilities.Distribution;
import utilities.TaemsRandom;

public class Method
extends TaskBase
implements Serializable,
Cloneable {
    Vector outcomes = new Vector();
    protected int start_time = Integer.MIN_VALUE;
    protected int finish_time = Integer.MIN_VALUE;
    protected int accrued_time = Integer.MIN_VALUE;
    protected boolean showqcds = false;
    protected int earlieststarttime = Integer.MIN_VALUE;
    protected int lateststarttime = Integer.MIN_VALUE;
    protected int earliestfinishtime = Integer.MAX_VALUE;
    protected int latestfinishtime = Integer.MAX_VALUE;
    public static final String EARLIER_WEAK = "earlier_weak";
    public static final String EARLIER_STRONG = "earlier_strong";
    public static final String LATER_WEAK = "later_weak";
    public static final String LATER_STRONG = "later_strong";
    Rectangle bigbounds = new Rectangle(0, 0, 0, 0);

    public Method(String l, Agent a, int at, int est, int dl, int s, int f, int ac) {
        super(l, a, at, est, dl);
        this.start_time = s;
        this.finish_time = f;
        this.accrued_time = ac;
    }

    public Method(String l, Agent a) {
        this(l, a, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public Method() {
        this(null, null);
    }

    public boolean getShowQCDs() {
        return this.showqcds;
    }

    public void setShowQCDs(boolean s) {
        this.showqcds = s;
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 1));
    }

    public int getStartTime() {
        return this.start_time;
    }

    public void setStartTime(int s) {
        this.start_time = s;
        super.setStartTime(s);
    }

    public int getFinishTime() {
        return this.finish_time;
    }

    public void setFinishTime(int f) {
        this.finish_time = f;
        super.setFinishTime(f);
    }

    public int getActualEarliestStartTime() {
        return this.earlieststarttime;
    }

    public void setActualEarliestStartTime(int e) {
        this.earlieststarttime = e;
        this.earliestfinishtime = e + (int)this.getGlobalOutcome().getDuration().calculateMin();
    }

    public void setActualEarliestFinishTime(int e) {
        this.earliestfinishtime = e;
        this.earlieststarttime = e - (int)this.getGlobalOutcome().getDuration().calculateMin();
    }

    public int getActualEarliestFinishTime() {
        return this.earliestfinishtime;
    }

    public int getActualLatestStartTime() {
        return this.lateststarttime;
    }

    public int getActualLatestFinishTime() {
        return this.latestfinishtime;
    }

    public void setActualLatestFinishTime(int time) {
        this.latestfinishtime = time;
        this.lateststarttime = time - (int)this.getGlobalOutcome().getDuration().calculateMax();
    }

    public void setActualLatestStartTime(int time) {
        this.lateststarttime = time;
        this.latestfinishtime = time + (int)this.getGlobalOutcome().getDuration().calculateMax();
    }

    public void resetActualTiming() {
        this.lateststarttime = Integer.MIN_VALUE;
        this.latestfinishtime = Integer.MAX_VALUE;
        this.earlieststarttime = Integer.MIN_VALUE;
        this.earliestfinishtime = Integer.MAX_VALUE;
    }

    public int getAccruedTime() {
        return this.accrued_time;
    }

    public void setAccruedTime(int a) {
        this.accrued_time = a;
    }

    public float getMaximumQuality() {
        if (this.hasAttribute("max_quality")) {
            return ((Float)this.getAttribute("max_quality")).floatValue();
        }
        Outcome c = this.getGlobalOutcome();
        Distribution dQ = c.quality;
        float maximumQuality = dQ.calculateMax();
        this.setMaximumQuality(maximumQuality);
        return maximumQuality;
    }

    public int getScheduleNumber() {
        if (this.hasAttribute("sched_num")) {
            Object n = this.getAttribute("sched_num");
            if (n instanceof Integer) {
                return (Integer)n;
            }
            return Integer.parseInt(n.toString());
        }
        return -1;
    }

    public void setScheduleNumber(int s) {
        this.setAttribute("sched_num", new Integer(s));
    }

    public boolean hasScheduleNumber() {
        return this.getScheduleNumber() != -1;
    }

    public void setPlacementPreference(String s) {
        this.setAttribute("placement_preference", s);
    }

    public String getPlacementPreference() {
        return (String)this.getAttribute("placement_preference");
    }

    public void setWeightingFactor(float f) {
        this.setAttribute("weighting_factor", new Float(f));
    }

    public float getWeightingFactor() {
        return ((Float)this.getAttribute("weighting_factor")).floatValue();
    }

    public void setTimeToScheduleFor(float f) {
        this.setAttribute("time_to_schedule_for", new Float(f));
    }

    public float getTimeToScheduleFor() {
        return ((Float)this.getAttribute("time_to_schedule_for")).floatValue();
    }

    public void addOutcome(Outcome o) {
        this.outcomes.addElement(o);
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
    }

    public void removeOutcome(Outcome o) {
        this.outcomes.removeElement(o);
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
    }

    public void removeAllOutcomes() {
        this.outcomes.removeAllElements();
    }

    public Enumeration getOutcomes() {
        return this.outcomes.elements();
    }

    public int numOutcomes() {
        return this.outcomes.size();
    }

    /*
     * WARNING - void declaration
     */
    public Outcome chooseOutcome(boolean complex, TaemsRandom tr) {
        void var7_8;
        int count = 0;
        int i = 0;
        Enumeration e = this.getOutcomes();
        if (this.numOutcomes() != 0) {
            Outcome o;
            if (this.numOutcomes() != 1) {
                float[] dist = new float[this.numOutcomes() * 2];
                while (e.hasMoreElements()) {
                    dist[count] = ((Outcome)e.nextElement()).getDensity();
                    dist[count + 1] = i;
                    count += 2;
                    ++i;
                }
                tr.setDistribution(dist);
                float choice = tr.nextValue();
                tr.unsetDistribution();
                o = (Outcome)this.outcomes.elementAt((int)choice);
            } else {
                o = (Outcome)this.outcomes.elementAt(0);
            }
        } else {
            return null;
        }
        return this.applyNLEsOnOutcome((Outcome)var7_8, complex, tr);
    }

    protected Outcome applyNLEsOnOutcome(Outcome o, boolean complex, TaemsRandom tr) {
        Outcome outcome = (Outcome)o.clone();
        SortedEnumerationByTimeStamp e = new SortedEnumerationByTimeStamp(this.getAffectingInterrelationships());
        while (e.hasMoreElements()) {
            Interrelationship NLE = (Interrelationship)e.nextElement();
            outcome = NLE.applyNLEonOutcome(outcome, complex, tr);
        }
        return outcome;
    }

    public Outcome getOutcome(String s) {
        Enumeration e = this.getOutcomes();
        while (e.hasMoreElements()) {
            Outcome o = (Outcome)e.nextElement();
            if (!o.getLabel().equalsIgnoreCase(s)) continue;
            return o;
        }
        return null;
    }

    public Outcome getGlobalOutcome() {
        float[] results = new float[6];
        Distribution dQ = new Distribution();
        Distribution dC = new Distribution();
        Distribution dD = new Distribution();
        if (this.numOutcomes() > 0) {
            Enumeration e = this.outcomes.elements();
            while (e.hasMoreElements()) {
                Outcome out = (Outcome)e.nextElement();
                dD = dD.appendDistribution(out.getDuration().applyDensity(out.getDensity()));
                dQ = dQ.appendDistribution(out.getQuality().applyDensity(out.getDensity()));
                dC = dC.appendDistribution(out.getCost().applyDensity(out.getDensity()));
            }
        } else {
            return null;
        }
        Outcome o = (Outcome)this.outcomes.elementAt(0);
        o = (Outcome)o.clone();
        o.setDuration(dD);
        o.setCost(dC);
        o.setQuality(dQ);
        o.setDensity(1.0f);
        return o;
    }

    public Outcome getMostLikelyOutcome() {
        Enumeration e = this.getOutcomes();
        Outcome o = null;
        while (e.hasMoreElements()) {
            Outcome to = (Outcome)e.nextElement();
            if (o != null && !(to.getDensity() > o.getDensity())) continue;
            o = to;
        }
        return o;
    }

    public void updateNLEs(int time) {
        Enumeration e = this.getAffectedInterrelationships();
        while (e.hasMoreElements()) {
            ((Interrelationship)e.nextElement()).update(time);
        }
    }

    public String toTTaems(float v) {
        StringBuffer sb = new StringBuffer("");
        sb.append("(spec_method\n");
        sb.append(super.toTTaems(v));
        if (this.earlieststarttime != Integer.MIN_VALUE) {
            sb.append(";        (est " + this.earlieststarttime + ")\n");
        }
        if (this.lateststarttime != Integer.MIN_VALUE) {
            sb.append(";        (lst " + this.lateststarttime + ")\n");
        }
        if (this.earliestfinishtime != Integer.MAX_VALUE) {
            sb.append(";        (eft " + this.earliestfinishtime + ")\n");
        }
        if (this.latestfinishtime != Integer.MAX_VALUE) {
            sb.append(";        (lft " + this.latestfinishtime + ")\n");
        }
        if (this.numOutcomes() > 0) {
            sb.append("   (outcomes\n");
            Enumeration e = this.getOutcomes();
            while (e.hasMoreElements()) {
                Outcome o = (Outcome)e.nextElement();
                sb.append(o.toTTaems(v));
            }
            sb.append("   )\n");
        } else {
            System.err.println("Warning: Method has no outcomes");
        }
        if (this.start_time != Integer.MIN_VALUE) {
            sb.append("   (start_time " + this.start_time + ")\n");
        }
        if (this.finish_time != Integer.MIN_VALUE) {
            sb.append("   (finish_time " + this.finish_time + ")\n");
        }
        if (this.accrued_time != Integer.MIN_VALUE) {
            sb.append("   (accrued_time " + this.accrued_time + ")\n");
        }
        sb.append(")\n");
        return sb.toString();
    }

    public boolean matches(Node n) {
        if (n.getClass().isInstance(this)) {
            if (!super.matches(n)) {
                return false;
            }
        } else {
            return false;
        }
        if (n instanceof Method) {
            if (!Method.matches(((Method)n).getStartTime(), this.getStartTime())) {
                return false;
            }
            if (!Method.matches(((Method)n).getFinishTime(), this.getFinishTime())) {
                return false;
            }
            if (!Method.matches(((Method)n).getAccruedTime(), this.getAccruedTime())) {
                return false;
            }
            if (!Method.matches(((Method)n).nonlocal, this.nonlocal)) {
                return false;
            }
            if (((Method)n).numOutcomes() > 1) {
                if (((Method)n).numOutcomes() != this.numOutcomes()) {
                    return false;
                }
                Enumeration me = ((Method)n).getOutcomes();
                while (me.hasMoreElements()) {
                    Outcome mo = (Outcome)me.nextElement();
                    boolean found = false;
                    Enumeration oe = this.getOutcomes();
                    while (oe.hasMoreElements()) {
                        Outcome oo = (Outcome)oe.nextElement();
                        if (!oo.matches(mo)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Object clone() {
        Method cloned = null;
        try {
            cloned = (Method)super.clone();
        }
        catch (Exception e) {
            System.out.println("Clone Error: " + e);
        }
        cloned.setStartTime(this.getStartTime());
        cloned.setFinishTime(this.getFinishTime());
        cloned.setAccruedTime(this.getAccruedTime());
        cloned.outcomes = new Vector();
        Enumeration e = this.getOutcomes();
        while (e.hasMoreElements()) {
            Outcome o = (Outcome)e.nextElement();
            cloned.addOutcome((Outcome)o.clone());
        }
        return cloned;
    }

    public void copy(Node n) {
        if (n instanceof Method) {
            Method m = (Method)n;
            m.setStartTime(this.getStartTime());
            m.setFinishTime(this.getFinishTime());
            m.setAccruedTime(this.getAccruedTime());
            m.outcomes = new Vector();
            Enumeration e = this.getOutcomes();
            while (e.hasMoreElements()) {
                Outcome o = (Outcome)e.nextElement();
                m.addOutcome((Outcome)o.clone());
            }
        }
        super.copy(n);
    }

    public Rectangle getBounds() {
        return this.bigbounds;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.isVisible()) {
            g.setFont(smallFont);
            FontMetrics fm = g.getFontMetrics();
            try {
                String num;
                this.bigbounds.setBounds(this.rect);
                if (this.status == 2 || this.getCurrentQuality() != 0.0f) {
                    num = String.valueOf(this.getCurrentQuality());
                    g.setColor(Color.red);
                    g.drawString(num, this.rect.x - (fm.stringWidth(num) + 5), this.rect.y + this.rect.height - (2 + fm.getDescent()));
                }
                if (this.getShowQCDs()) {
                    g.setColor(Color.black);
                    if (this.numOutcomes() > 0) {
                        StringBuffer sb = new StringBuffer("");
                        Enumeration e = this.getOutcomes();
                        while (e.hasMoreElements()) {
                            Outcome o = (Outcome)e.nextElement();
                            sb.append(o.getLabel() + " (" + o.getDensity() * 100.0f + "%)\n");
                            sb.append("Q: " + o.getQuality() + "\n");
                            sb.append("C: " + o.getCost() + "\n");
                            sb.append("D: " + o.getDuration() + "\n");
                            sb.append("\n");
                        }
                        char[] str = sb.toString().toCharArray();
                        int y = this.rect.y + this.rect.height + 2 + fm.getAscent();
                        int h = -1;
                        int i = 0;
                        while (i < str.length) {
                            int next;
                            for (next = i + 1; next < str.length && str[next] != '\n'; ++next) {
                            }
                            String piece = new String(str, i, next - i);
                            if (piece.startsWith("\n")) {
                                piece = piece.substring(1, piece.length());
                            }
                            if (h < 0) {
                                h = fm.stringWidth(piece) / 2;
                            }
                            g.drawString(piece, this.getLocation().x - h, y);
                            y += 2 + fm.getDescent() + fm.getAscent();
                            i = next;
                        }
                        this.bigbounds.height = y - this.bigbounds.y;
                        this.bigbounds.x = Math.min(this.bigbounds.x, this.getLocation().x - h);
                        this.bigbounds.width = Math.max(this.bigbounds.width, h * 2);
                    }
                }
                if (this.hasScheduleNumber()) {
                    num = String.valueOf(this.getScheduleNumber());
                    g.setColor(Color.gray);
                    if (this.getShowQCDs()) {
                        g.drawString(num, this.rect.x + this.rect.width + 5, this.rect.y + this.rect.height - (2 + fm.getDescent()));
                        this.bigbounds.width += 5 + fm.stringWidth(num);
                    } else {
                        g.drawString(num, this.getLocation().x - fm.stringWidth(num) / 2, this.rect.y + this.rect.height + 2 + fm.getAscent());
                        this.bigbounds.height += 2 + fm.getAscent();
                    }
                }
            }
            catch (NullPointerException ex) {
                System.err.println("Error drawing label");
                ex.printStackTrace();
            }
        }
        g.setFont(normalFont);
    }

    protected Color getBackground() {
        if (this.hasScheduleNumber() && this.getStatus() == 0 && !this.isSelected()) {
            return Color.cyan;
        }
        return super.getBackground();
    }
}

