/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.io.Serializable;
import taems.Agent;
import taems.Interrelationship;
import taems.Method;
import taems.Outcome;
import taems.Resource;
import utilities.Distribution;
import utilities.Log;
import utilities.TaemsRandom;

public class LimitsInterrelationship
extends Interrelationship
implements Serializable,
Cloneable {
    public LimitsInterrelationship(String l, Agent a, Distribution q, Distribution d, Distribution c, String m) {
        this(l, a, q, d, c);
        this.setModel(m);
    }

    public LimitsInterrelationship(String l, Agent a, Distribution q, Distribution d, Distribution c) {
        super(l, a, q, d, c, null);
    }

    public LimitsInterrelationship() {
    }

    public Outcome applyNLEonOutcome(Outcome o, boolean complex, TaemsRandom tr) {
        return o;
    }

    public boolean hasModel() {
        return true;
    }

    public String toTTaems(float v) {
        StringBuffer sb = new StringBuffer("");
        if (this.getFrom() != null && !this.getFrom().isVirtual() && !(this.getFrom() instanceof Resource)) {
            Log.getDefault().log("Warning: From node on IR " + this.getLabel() + " is not a Resource", 1);
        }
        if (this.getTo() != null && !this.getTo().isVirtual() && !(this.getTo() instanceof Method)) {
            Log.getDefault().log("Warning: From node on IR " + this.getLabel() + " is not a Method", 1);
        }
        sb.append("(spec_limits\n");
        sb.append(super.toTTaems(v));
        if (this.getQuality() != null) {
            sb.append("   (quality_power " + this.getQuality().output() + ")\n");
        }
        if (this.getDuration() != null) {
            sb.append("   (duration_power " + this.getDuration().output() + ")\n");
        }
        if (this.getCost() != null) {
            sb.append("   (cost_power " + this.getCost().output() + ")\n");
        }
        sb.append(")\n");
        return sb.toString();
    }
}

