/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.io.Serializable;
import java.util.Enumeration;
import taems.QAF;
import taems.TaskBase;

public class LastQAF
extends QAF
implements Serializable,
Cloneable {
    public LastQAF() {
        super("q_last");
    }

    public float calculateQuality(Enumeration e) {
        float q = 0.0f;
        int f = Integer.MIN_VALUE;
        while (e.hasMoreElements()) {
            TaskBase t = (TaskBase)e.nextElement();
            float weight = 1.0f;
            if (t.getAttribute("weighting_factor") != null) {
                weight = ((Float)t.getAttribute("weighting_factor")).floatValue();
            }
            float cq = weight * t.getCurrentQuality();
            if (t.getFinishTime() <= f) continue;
            f = t.getFinishTime();
            q = cq;
        }
        return q;
    }

    public float calculateMaximumQuality(Enumeration e) {
        float q = 0.0f;
        while (e.hasMoreElements()) {
            TaskBase t = (TaskBase)e.nextElement();
            float weight = 1.0f;
            if (!(t.getMaximumQuality() > q)) continue;
            if (t.getAttribute("weighting_factor") != null) {
                weight = ((Float)t.getAttribute("weighting_factor")).floatValue();
            }
            q = weight * t.getMaximumQuality();
        }
        return q;
    }
}

