/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import taems.Agent;
import taems.Node;
import taems.NodeUpdateEvent;
import taems.Outcome;
import taems.Taems;
import taems.TaskBase;
import taems.VirtualNode;
import utilities.Arrow;
import utilities.Distribution;
import utilities.Spline;
import utilities.TaemsRandom;

public class Interrelationship
extends Node
implements Serializable,
Cloneable {
    protected Node from = null;
    protected Outcome from_outcome = null;
    protected Node to = null;
    protected String model = null;
    protected Distribution quality;
    protected Distribution duration;
    protected Distribution cost;
    protected Distribution delay;
    protected int timestamp = 0;
    public boolean active = false;
    public static final String PER_TIME_UNIT = "per_time_unit";
    public static final String DURATION_INDEPENDENT = "duration_independent";
    private transient Point floc;
    private transient Point tloc;
    private boolean lock = false;

    public Interrelationship(String l, Agent a, Distribution q, Distribution du, Distribution c, Distribution de) {
        super(l, a);
        this.quality = q;
        this.duration = du;
        this.cost = c;
        this.delay = de;
        this.setActive(false);
    }

    public Interrelationship(String l, Agent a) {
        super(l, a);
        this.setActive(false);
    }

    public Interrelationship() {
        this(null, null, null, null, null, null);
    }

    public int getTimeStamp() {
        return this.timestamp;
    }

    public void setTimeStamp(int t) {
        this.timestamp = t;
    }

    public Distribution getQuality() {
        return this.quality;
    }

    public void setQuality(Distribution q) {
        if (this.getQuality() != null && this.getQuality().equals(q)) {
            return;
        }
        this.quality = q;
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
    }

    public Distribution getDuration() {
        return this.duration;
    }

    public void setDuration(Distribution d) {
        if (this.getDuration() != null && this.getDuration().equals(d)) {
            return;
        }
        this.duration = d;
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
    }

    public Distribution getCost() {
        return this.cost;
    }

    public void setCost(Distribution c) {
        if (this.getCost() != null && this.getCost().equals(c)) {
            return;
        }
        this.cost = c;
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
    }

    public Distribution getDelay() {
        return this.delay;
    }

    public void setDelay(Distribution d) {
        if (this.getDelay() != null && this.getDelay().equals(d)) {
            return;
        }
        this.delay = d;
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
    }

    public void setModel(String m) {
        if (this.getModel() != null && this.getModel().equals(m)) {
            return;
        }
        this.model = m;
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
    }

    public String getModel() {
        return this.model;
    }

    public boolean hasModel() {
        return false;
    }

    public boolean getActive() {
        if (this.hasAttribute("active")) {
            if (!(this.getAttribute("active") instanceof Boolean)) {
                this.setActive(Boolean.valueOf((String)this.getAttribute("active")));
            }
            return (Boolean)this.getAttribute("active");
        }
        return false;
    }

    public void setActive(boolean a) {
        this.setAttribute("active", new Boolean(a));
        if (a) {
            this.setStatus(3);
        } else {
            this.setStatus(0);
        }
    }

    public boolean isActive() {
        return this.getActive();
    }

    public Node getFrom() {
        return this.from;
    }

    public Outcome getFromOutcome() {
        return this.from_outcome;
    }

    protected void setFromOutcome(Outcome o) {
        this.from_outcome = o;
    }

    protected void setFrom(Node n, Outcome o) {
        if (this.from != null) {
            this.from.removeOutInterrelationship(this);
        }
        this.from = n;
        if (this.from != null) {
            this.from.addOutInterrelationship(this);
        }
        this.setFromOutcome(o);
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 2));
    }

    protected void setFrom(Node n) {
        this.setFrom(n, this.getFromOutcome());
    }

    public Node getTo() {
        return this.to;
    }

    protected void setTo(Node n) {
        if (this.to != null) {
            this.to.removeInInterrelationship(this);
        }
        this.to = n;
        if (this.to != null) {
            this.to.addInInterrelationship(this);
        }
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 2));
    }

    protected void setEndpoints(Node f, Outcome fo, Node t) {
        if (f instanceof Interrelationship || t instanceof Interrelationship) {
            System.err.println("Error: Cannot attach an IR to another IR");
            return;
        }
        this.setFrom(f, fo);
        this.setTo(t);
    }

    public void replace(Interrelationship i) {
        Node of = i.getFrom();
        VirtualNode vf = null;
        if (of != null) {
            vf = new VirtualNode(of.getLabel(), of.getAgent());
        }
        Outcome oo = i.getFromOutcome();
        Outcome vo = null;
        if (oo != null) {
            vo = (Outcome)oo.clone();
        }
        Node ot = i.getTo();
        VirtualNode vt = null;
        if (ot != null) {
            vt = new VirtualNode(ot.getLabel(), ot.getAgent());
        }
        i.setEndpoints(vf, vo, vt);
        this.setEndpoints(of, oo, ot);
    }

    public Node excise() {
        Node n = super.excise();
        VirtualNode f = null;
        if (this.getFrom() != null) {
            f = new VirtualNode(this.getFrom().getLabel(), this.getFrom().getAgent());
        }
        Outcome o = null;
        if (this.getFromOutcome() != null) {
            o = (Outcome)this.getFromOutcome().clone();
        }
        VirtualNode t = null;
        if (this.getTo() != null) {
            t = new VirtualNode(this.getTo().getLabel(), this.getTo().getAgent());
        }
        this.setEndpoints(f, o, t);
        return n;
    }

    public void delete() {
        this.setEndpoints(null, null, null);
        super.delete();
    }

    public boolean matches(Node n) {
        if (n.getClass().isInstance(this)) {
            if (!super.matches(n)) {
                return false;
            }
        } else {
            return false;
        }
        if (n instanceof Interrelationship) {
            if (!Interrelationship.matches(((Interrelationship)n).getQuality(), this.getQuality())) {
                return false;
            }
            if (!Interrelationship.matches(((Interrelationship)n).getDuration(), this.getDuration())) {
                return false;
            }
            if (!Interrelationship.matches(((Interrelationship)n).getCost(), this.getCost())) {
                return false;
            }
            if (!Interrelationship.matches(((Interrelationship)n).getDelay(), this.getDelay())) {
                return false;
            }
        }
        return true;
    }

    public void copy(Node n) {
        if (n instanceof Interrelationship) {
            Interrelationship i = (Interrelationship)n;
            if (this.quality != null) {
                i.setQuality((Distribution)this.quality.clone());
            } else {
                i.setQuality(null);
            }
            if (this.duration != null) {
                i.setDuration((Distribution)this.duration.clone());
            } else {
                i.setDuration(null);
            }
            if (this.cost != null) {
                i.setCost((Distribution)this.cost.clone());
            } else {
                i.setCost(null);
            }
            if (this.delay != null) {
                i.setDelay((Distribution)this.delay.clone());
            } else {
                i.setDelay(null);
            }
            if (this.model != null) {
                i.setModel(this.getModel());
            } else {
                i.setModel(null);
            }
            i.setActive(this.getActive());
        }
        super.copy(n);
    }

    public Object clone() {
        Interrelationship cloned = null;
        try {
            cloned = (Interrelationship)super.clone();
        }
        catch (Exception e) {
            System.out.println("Clone Error: " + e);
        }
        if (this.quality != null) {
            cloned.setQuality((Distribution)this.quality.clone());
        } else {
            cloned.setQuality(null);
        }
        if (this.duration != null) {
            cloned.setDuration((Distribution)this.duration.clone());
        } else {
            cloned.setDuration(null);
        }
        if (this.cost != null) {
            cloned.setCost((Distribution)this.cost.clone());
        } else {
            cloned.setCost(null);
        }
        if (this.delay != null) {
            cloned.setDelay((Distribution)this.delay.clone());
        } else {
            cloned.setDelay(null);
        }
        if (this.model != null) {
            cloned.setModel(this.getModel());
        } else {
            cloned.setModel(null);
        }
        VirtualNode vf = null;
        if (this.getFrom() != null) {
            vf = new VirtualNode(this.getFrom().getLabel(), this.getFrom().getAgent());
        }
        VirtualNode vt = null;
        if (this.getTo() != null) {
            vt = new VirtualNode(this.getTo().getLabel(), this.getTo().getAgent());
        }
        cloned.setEndpoints(vf, null, vt);
        return cloned;
    }

    public String toTTaems(float v) {
        StringBuffer sb = new StringBuffer("");
        sb.append(super.toTTaems(v));
        if (this.getFrom() != null) {
            sb.append("   (from " + this.getFrom().getLabel() + ")\n");
            if (this.getFrom().isVirtual()) {
                sb.append(";   ** Note: from node " + this.getFrom().getLabel() + " is virtual\n");
            }
        }
        if (this.getFromOutcome() != null) {
            sb.append("   (from_outcome " + this.getFromOutcome().getLabel() + ")\n");
        }
        if (this.getTo() != null) {
            sb.append("   (to " + this.getTo().getLabel() + ")\n");
            if (this.getTo().isVirtual()) {
                sb.append(";   ** Note: to node " + this.getTo().getLabel() + " is virtual\n");
            }
        }
        if (this.hasModel() && this.getModel() != null && v >= 1.1f) {
            sb.append("   (model " + this.getModel() + ")\n");
        }
        return sb.toString();
    }

    public void update(int time) {
        this.setTimeStamp(time);
    }

    public Outcome applyNLEonOutcome(Outcome o, boolean complex, TaemsRandom tr) {
        return o;
    }

    public boolean needToBeUpdated() {
        TaskBase task = (TaskBase)this.getFrom();
        if (task.getCurrentQuality() != 0.0f && !this.getActive()) {
            return true;
        }
        return this.getActive() && task.getCurrentQuality() == 0.0f;
    }

    public int calculateTreeHeight(FontMetrics fm) {
        return this.calculateHeight(fm);
    }

    public void updateRect(Graphics g) {
        int x = this.loc.x;
        int y = this.loc.y;
        Dimension d = this.getSize(g);
        int w = d.width;
        int h = d.height;
        this.rect = new Rectangle(x - w / 2, y - h / 2, w, h);
    }

    public Dimension getSize(Graphics g) {
        g.setFont(mediumFont);
        Dimension d = super.getSize(g);
        g.setFont(normalFont);
        return d;
    }

    public boolean isVisible() {
        if (!super.isVisible()) {
            return false;
        }
        if (this.getTo() != null && !this.getTo().isVisible()) {
            return false;
        }
        return this.getFrom() == null || this.getFrom().isVisible();
    }

    public void paintLines(Graphics g) {
        if (this.lock) {
            return;
        }
        this.lock = true;
        if (this.isVisible()) {
            int np = 0;
            float[] px = new float[5];
            float[] py = new float[5];
            g.setColor(Color.black);
            if (this.getFrom() != null) {
                if (this.getFrom().getLocation() == null) {
                    System.err.println("Warning, paintLines for ir " + this.getLabel() + " from node " + this.getFrom().getLabel() + " ran into null location");
                    return;
                }
                if (this.getFrom().getLocation().x == Integer.MIN_VALUE) {
                    System.err.println("Warning, paintLines for ir " + this.getLabel() + " from node " + this.getFrom().getLabel() + " ran into none location");
                    return;
                }
                px[np] = this.getFrom().getLocation().x;
                py[np] = this.getFrom().getLocation().y;
                ++np;
                if (this.getTo().isSelected()) {
                    g.setColor(Color.blue);
                }
                if (this.getFrom().isSelected()) {
                    g.setColor(Color.red);
                }
                if (this.isSelected()) {
                    g.setColor(Color.blue);
                }
            }
            if (this.getLocation() == null) {
                System.err.println("Warning, paintLines for ir " + this.getLabel() + " ran into null location");
                return;
            }
            px[np] = this.getLocation().x;
            py[np] = this.getLocation().y;
            ++np;
            if (this.getTo() != null) {
                if (this.getTo().getLocation() == null) {
                    System.err.println("Warning, paintLines for ir " + this.getLabel() + " to node " + this.getTo().getLabel() + " ran into null location");
                    return;
                }
                if (this.getTo().getLocation().x == Integer.MIN_VALUE) {
                    System.err.println("Warning, paintLines for ir " + this.getLabel() + " to node " + this.getTo().getLabel() + " ran into none location");
                    return;
                }
                px[np] = this.getTo().getLocation().x;
                py[np] = this.getTo().getLocation().y;
                ++np;
            }
            Spline spline = new Spline(px, py, np);
            spline.Generate();
            spline.draw(g);
            Point p1 = spline.getPoint(0.15f);
            Point p2 = spline.getPoint(0.25f);
            Arrow.drawArrowhead(g, p1.x, p1.y, p2.x, p2.y);
            p1 = spline.getPoint(0.75f);
            p2 = spline.getPoint(0.85f);
            Arrow.drawArrowhead(g, p1.x, p1.y, p2.x, p2.y);
        }
        this.lock = false;
    }

    public void paint(Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        this.updateRect(g);
        if (this.lock) {
            return;
        }
        this.lock = true;
        if (this.isVisible()) {
            g.setColor(this.getBackground());
            g.fillRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
            g.setColor(this.getForeground());
            g.drawRect(this.rect.x, this.rect.y, this.rect.width - 1, this.rect.height - 1);
            try {
                g.setFont(mediumFont);
                g.drawString(this.getLabel(), this.rect.x + 5, this.rect.y + 2 + fm.getAscent());
                g.setFont(normalFont);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                System.err.println("Freaky string error.");
            }
        }
        this.lock = false;
    }

    protected Color getForeground() {
        if (this.isActive() || Taems.printing) {
            return Color.black;
        }
        return Color.gray;
    }
}

