/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.io.Serializable;
import taems.Agent;
import taems.Interrelationship;
import taems.Outcome;
import taems.TaskBase;
import utilities.Distribution;
import utilities.TaemsRandom;

public class HindersInterrelationship
extends Interrelationship
implements Serializable,
Cloneable {
    public HindersInterrelationship(String l, Agent a, Distribution q, Distribution d, Distribution c, Distribution delay) {
        super(l, a, q, d, c, delay);
    }

    public HindersInterrelationship() {
    }

    public Outcome applyNLEonOutcome(Outcome o, boolean complex, TaemsRandom tr) {
        TaskBase task = (TaskBase)this.getFrom();
        Outcome outc = (Outcome)o.clone();
        if (this.getActive()) {
            float powerQ = 1.0f;
            if (complex) {
                powerQ = task.getCurrentQuality() / task.getMaximumQuality();
            }
            if (this.quality != null) {
                tr.setDistribution(this.quality);
                float power_q = tr.nextValue();
                tr.unsetDistribution();
                power_q = 1.0f - power_q;
                if (power_q < 0.0f) {
                    power_q = 0.0f;
                }
                outc.setQuality(o.getQuality().applyPower(powerQ * power_q));
            }
            if (this.duration != null) {
                tr.setDistribution(this.duration);
                float power_d = tr.nextValue();
                tr.unsetDistribution();
                power_d = 1.0f + power_d;
                outc.setDuration(o.getDuration().applyPower(powerQ * power_d));
            }
            if (this.cost != null) {
                tr.setDistribution(this.cost);
                float power_c = tr.nextValue();
                tr.unsetDistribution();
                power_c = 1.0f + power_c;
                outc.setCost(o.getCost().applyPower(powerQ * power_c));
            }
        }
        return outc;
    }

    public void update(int time) {
        TaskBase task = (TaskBase)this.getFrom();
        if (task.getCurrentQuality() != 0.0f && !this.getActive()) {
            this.setActive(true);
            super.update(time);
        } else if (this.getActive() && task.getCurrentQuality() == 0.0f) {
            this.setActive(false);
            super.update(time);
        }
    }

    public String toTTaems(float v) {
        StringBuffer sb = new StringBuffer("");
        sb.append("(spec_hinders\n");
        sb.append(super.toTTaems(v));
        if (this.getQuality() != null) {
            sb.append("   (quality_power " + this.getQuality().output() + ")\n");
        }
        if (this.getDuration() != null) {
            sb.append("   (duration_power " + this.getDuration().output() + ")\n");
        }
        if (this.getCost() != null) {
            sb.append("   (cost_power " + this.getCost().output() + ")\n");
        }
        if (this.getDelay() != null) {
            sb.append("   (delay " + this.getDelay().output() + ")\n");
        }
        sb.append(")\n");
        return sb.toString();
    }
}

