/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.io.Serializable;
import java.util.Enumeration;
import taems.QAF;
import taems.TaskBase;

public class ExactlyOneQAF
extends QAF
implements Serializable,
Cloneable {
    public ExactlyOneQAF() {
        super("q_exactly_one");
    }

    public float calculateQuality(Enumeration e) {
        float q = 0.0f;
        boolean alreadyOneExcuted = false;
        while (e.hasMoreElements()) {
            TaskBase t = (TaskBase)e.nextElement();
            float weight = 1.0f;
            if (t.getCurrentQuality() == 0.0f) continue;
            if (alreadyOneExcuted) {
                return 0.0f;
            }
            alreadyOneExcuted = true;
            if (t.getAttribute("weighting_factor") != null) {
                weight = ((Float)t.getAttribute("weighting_factor")).floatValue();
            }
            q = weight * t.getCurrentQuality();
        }
        return q;
    }

    public float calculateMaximumQuality(Enumeration e) {
        float q = 0.0f;
        boolean alreadyOneExcuted = false;
        while (e.hasMoreElements()) {
            TaskBase t = (TaskBase)e.nextElement();
            float weight = 1.0f;
            if (t.getCurrentQuality() == 0.0f) continue;
            if (alreadyOneExcuted) {
                return 0.0f;
            }
            alreadyOneExcuted = true;
            if (t.getAttribute("weighting_factor") != null) {
                weight = ((Float)t.getAttribute("weighting_factor")).floatValue();
            }
            q = weight * t.getMaximumQuality();
        }
        return q;
    }
}

