/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.io.Serializable;
import taems.MLCSchedule;
import taems.Precondition;
import utilities.Distribution;
import utilities.Log;

public class EarliestStartTimePrecondition
extends Precondition
implements Serializable,
Cloneable {
    protected Distribution earliestStartTime;
    protected Log log = Log.getDefault();

    public EarliestStartTimePrecondition(MLCSchedule p, Distribution d) {
        this.parentMLC = p;
        this.earliestStartTime = d;
    }

    public Distribution getEarliestStartDistribution() {
        return this.earliestStartTime;
    }

    public int getEarliestStartTime() {
        return (int)this.earliestStartTime.calculateMin();
    }

    public void setgetEarliestStartDistribution(Distribution d) {
        this.earliestStartTime = d;
    }

    public boolean check(int time) {
        boolean answer = true;
        String reason = "";
        if (this.optional) {
            return true;
        }
        if (time < this.getEarliestStartTime()) {
            answer = false;
            reason = "time is not right " + time + " < " + this.getEarliestStartTime();
        }
        this.log.log("#### Checking : " + this.output() + " is " + answer + " [" + reason + "]", 2);
        return answer;
    }

    public void completed(int time) {
    }

    public void clear() {
    }

    public String output() {
        StringBuffer sb = new StringBuffer();
        sb.append("EarliestStartTime : " + this.getEarliestStartDistribution());
        return sb.toString();
    }

    public Object clone() {
        EarliestStartTimePrecondition cloned = new EarliestStartTimePrecondition(null, this.getEarliestStartDistribution());
        cloned.setOptional(this.isOptional());
        return cloned;
    }

    public String toTTaems(float v) {
        StringBuffer sb = new StringBuffer("           (spec_earlieststarttime_precondition\n");
        sb.append("              (earliest_start_time " + this.getEarliestStartDistribution() + ")\n");
        sb.append("           )\n");
        return sb.toString();
    }
}

