/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.util.Vector;

public class Criteria
extends Vector
implements Cloneable {
    public static final int QUALITY_THRESHOLD = 0;
    public static final int COST_LIMIT = 1;
    public static final int DURATION_LIMIT = 2;
    public static final int QUALITY_CERTAINTY_THRESHOLD = 3;
    public static final int COST_CERTAINTY_THRESHOLD = 4;
    public static final int DURATION_CERTAINTY_THRESHOLD = 5;
    public static final int GOODNESS_QUALITY_SLIDER = 6;
    public static final int GOODNESS_COST_SLIDER = 7;
    public static final int GOODNESS_DURATION_SLIDER = 8;
    public static final int THRESHOLD_QUALITY_SLIDER = 9;
    public static final int THRESHOLD_COST_SLIDER = 10;
    public static final int THRESHOLD_DURATION_SLIDER = 11;
    public static final int UNCERTAINTY_QUALITY_SLIDER = 12;
    public static final int UNCERTAINTY_COST_SLIDER = 13;
    public static final int UNCERTAINTY_DURATION_SLIDER = 14;
    public static final int THRESHOLD_CERTAINTY_QUALITY_SLIDER = 15;
    public static final int THRESHOLD_CERTAINTY_COST_SLIDER = 16;
    public static final int THRESHOLD_CERTAINTY_DURATION_SLIDER = 17;
    public static final int META_GOODNESS_SLIDER = 18;
    public static final int META_THRESHOLD_SLIDER = 19;
    public static final int META_UNCERTAINTY_SLIDER = 20;
    public static final int META_UNCERTAINTY_THRESHOLD_SLIDER = 21;
    private static final int NUMCRIT = 22;
    protected String label = "unknown";
    protected int slidertotal = 1;

    public Criteria() {
        super(22);
        this.setSize(22);
    }

    public Criteria(int a) {
        this();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String l) {
        this.label = l;
    }

    public void setSliderTotal(int st) {
        this.slidertotal = st;
    }

    public int getSliderTotal() {
        return this.slidertotal;
    }

    public Object clone() {
        Criteria cloned = null;
        try {
            cloned = (Criteria)super.clone();
        }
        catch (Exception e) {
            System.out.println("Clone Error: " + e);
        }
        cloned.setLabel(new String(this.getLabel()));
        return cloned;
    }

    public void setGoodnessQuality(Float f) {
        this.setAndCheckValue(f, 6, 7, 8, -1);
    }

    public Float getGoodnessQuality() {
        return (Float)this.elementAt(6);
    }

    public void setGoodnessCost(Float f) {
        this.setAndCheckValue(f, 7, 6, 8, -1);
    }

    public Float getGoodnessCost() {
        return (Float)this.elementAt(7);
    }

    public void setGoodnessDuration(Float f) {
        this.setAndCheckValue(f, 8, 7, 6, -1);
    }

    public Float getGoodnessDuration() {
        return (Float)this.elementAt(8);
    }

    public void setThresholdQuality(Float f) {
        this.setAndCheckValue(f, 9, 10, 11, -1);
    }

    public Float getThresholdQuality() {
        return (Float)this.elementAt(9);
    }

    public void setThresholdCost(Float f) {
        this.setAndCheckValue(f, 10, 9, 11, -1);
    }

    public Float getThresholdCost() {
        return (Float)this.elementAt(10);
    }

    public void setThresholdDuration(Float f) {
        this.setAndCheckValue(f, 11, 10, 9, -1);
    }

    public Float getThresholdDuration() {
        return (Float)this.elementAt(11);
    }

    public void setQualityThreshold(Float f) {
        this.setElementAt(f, 0);
    }

    public Float getQualityThreshold() {
        return (Float)this.elementAt(0);
    }

    public void setCostThreshold(Float f) {
        this.setElementAt(f, 1);
    }

    public Float getCostThreshold() {
        return (Float)this.elementAt(1);
    }

    public void setDurationThreshold(Float f) {
        this.setElementAt(f, 2);
    }

    public Float getDurationThreshold() {
        return (Float)this.elementAt(2);
    }

    public void setUncertaintyQuality(Float f) {
        this.setAndCheckValue(f, 12, 13, 14, -1);
    }

    public Float getUncertaintyQuality() {
        return (Float)this.elementAt(12);
    }

    public void setUncertaintyCost(Float f) {
        this.setAndCheckValue(f, 13, 12, 14, -1);
    }

    public Float getUncertaintyCost() {
        return (Float)this.elementAt(13);
    }

    public void setUncertaintyDuration(Float f) {
        this.setAndCheckValue(f, 14, 12, 13, -1);
    }

    public Float getUncertaintyDuration() {
        return (Float)this.elementAt(14);
    }

    public void setThresholdCertaintyQuality(Float f) {
        this.setElementAt(f, 15);
    }

    public Float getThresholdCertaintyQuality() {
        return (Float)this.elementAt(15);
    }

    public void setThresholdCertaintyCost(Float f) {
        this.setElementAt(f, 16);
    }

    public Float getThresholdCertaintyCost() {
        return (Float)this.elementAt(16);
    }

    public void setThresholdCertaintyDuration(Float f) {
        this.setElementAt(f, 17);
    }

    public Float getThresholdCertaintyDuration() {
        return (Float)this.elementAt(17);
    }

    public void setQualityCertaintyThreshold(Float f) {
        this.setElementAt(f, 3);
    }

    public Float getQualityCertaintyThreshold() {
        return (Float)this.elementAt(3);
    }

    public void setCostCertaintyThreshold(Float f) {
        this.setElementAt(f, 4);
    }

    public Float getCostCertaintyThreshold() {
        return (Float)this.elementAt(4);
    }

    public void setDurationCertaintyThreshold(Float f) {
        this.setElementAt(f, 5);
    }

    public Float getDurationCertaintyThreshold() {
        return (Float)this.elementAt(5);
    }

    public void setMetaGoodness(Float f) {
        this.setAndCheckValue(f, 18, 19, 20, 21);
    }

    public Float getMetaGoodness() {
        return (Float)this.elementAt(18);
    }

    public void setMetaThreshold(Float f) {
        this.setAndCheckValue(f, 19, 18, 20, 21);
    }

    public Float getMetaThreshold() {
        return (Float)this.elementAt(19);
    }

    public void setMetaUncertainty(Float f) {
        this.setAndCheckValue(f, 20, 18, 19, 21);
    }

    public Float getMetaUncertainty() {
        return (Float)this.elementAt(20);
    }

    public void setMetaUncertaintyThreshold(Float f) {
        this.setAndCheckValue(f, 21, 18, 19, 20);
    }

    public Float getMetaUncertaintyThreshold() {
        return (Float)this.elementAt(21);
    }

    protected void setAndCheckValue(Float value, int start, int dependance1, int dependance2, int dependance3) {
        float valueDependance3;
        int numOfDependance = 2;
        if (this.getSliderTotal() <= 0) {
            this.setElementAt(value, start);
            return;
        }
        if (value.floatValue() > (float)this.getSliderTotal()) {
            value = new Float(this.getSliderTotal());
        }
        this.setElementAt(value, start);
        if (this.elementAt(dependance1) == null) {
            this.setElementAt(new Float(0.0f), dependance1);
        }
        if (this.elementAt(dependance2) == null) {
            this.setElementAt(new Float(0.0f), dependance2);
        }
        if (dependance3 != -1 && this.elementAt(dependance3) == null) {
            this.setElementAt(new Float(0.0f), dependance3);
        }
        float valueDependance1 = ((Float)this.elementAt(dependance1)).floatValue();
        float valueDependance2 = ((Float)this.elementAt(dependance2)).floatValue();
        if (dependance3 != -1) {
            valueDependance3 = ((Float)this.elementAt(dependance3)).floatValue();
            ++numOfDependance;
        } else {
            valueDependance3 = 0.0f;
        }
        float total = value.floatValue() + valueDependance1 + valueDependance2 + valueDependance3;
        if (total > (float)this.getSliderTotal()) {
            if (dependance3 == -1) {
                float delta = ((float)this.getSliderTotal() - value.floatValue()) / (valueDependance1 + valueDependance2);
                this.setElementAt(new Float(valueDependance1 * delta), dependance1);
                this.setElementAt(new Float(valueDependance2 * delta), dependance2);
            } else {
                float delta = ((float)this.getSliderTotal() - value.floatValue()) / (valueDependance1 + valueDependance2 + valueDependance3);
                this.setElementAt(new Float(valueDependance1 * delta), dependance1);
                this.setElementAt(new Float(valueDependance2 * delta), dependance2);
                this.setElementAt(new Float(valueDependance3 * delta), dependance3);
            }
        }
    }

    public String toTTaems(float v) {
        StringBuffer sb = new StringBuffer("");
        sb.append("(spec_evaluation_criteria\n");
        sb.append("   (label " + this.getLabel() + ")\n");
        sb.append("   (goodness_quality_slider " + this.elementAt(6) + ")\n");
        sb.append("   (goodness_cost_slider " + this.elementAt(7) + ")\n");
        sb.append("   (goodness_duration_slider " + this.elementAt(8) + ")\n");
        sb.append("   (threshold_quality_slider " + this.elementAt(9) + ")\n");
        sb.append("   (threshold_cost_slider " + this.elementAt(10) + ")\n");
        sb.append("   (threshold_duration_slider " + this.elementAt(11) + ")\n");
        sb.append("   (quality_threshold " + this.elementAt(0) + ")\n");
        sb.append("   (cost_limit " + this.elementAt(1) + ")\n");
        sb.append("   (duration_limit " + this.elementAt(2) + ")\n");
        sb.append("   (uncertainty_quality_slider " + this.elementAt(12) + ")\n");
        sb.append("   (uncertainty_cost_slider " + this.elementAt(13) + ")\n");
        sb.append("   (uncertainty_duration_slider " + this.elementAt(14) + ")\n");
        sb.append("   (threshold_certainty_quality_slider " + this.elementAt(15) + ")\n");
        sb.append("   (threshold_certainty_cost_slider " + this.elementAt(16) + ")\n");
        sb.append("   (threshold_certainty_duration_slider " + this.elementAt(17) + ")\n");
        sb.append("   (quality_certainty_threshold " + this.elementAt(3) + ")\n");
        sb.append("   (cost_certainty_threshold " + this.elementAt(4) + ")\n");
        sb.append("   (duration_certainty_threshold " + this.elementAt(5) + ")\n");
        sb.append("   (meta_goodness_slider " + this.elementAt(18) + ")\n");
        sb.append("   (meta_threshold_slider " + this.elementAt(19) + ")\n");
        sb.append("   (meta_uncertainty_slider " + this.elementAt(20) + ")\n");
        sb.append("   (meta_uncertainty_threshold_slider " + this.elementAt(21) + ")\n");
        sb.append(")\n");
        return sb.toString();
    }
}

