/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.io.Serializable;
import taems.Agent;
import taems.Interrelationship;
import taems.Method;
import taems.Resource;
import utilities.Distribution;
import utilities.Log;

public class ConsumesInterrelationship
extends Interrelationship
implements Serializable,
Cloneable {
    public ConsumesInterrelationship(String l, Agent a, Distribution c, String m) {
        super(l, a, null, null, null, null);
        this.setConsumes(c);
        this.setModel(m);
    }

    public ConsumesInterrelationship(String l, Agent a, Distribution c) {
        this(l, a, c, "per_time_unit");
    }

    public ConsumesInterrelationship() {
    }

    public void setConsumes(Distribution c) {
        this.setCost(c);
    }

    public Distribution getConsumes() {
        return this.getCost();
    }

    public boolean hasModel() {
        return true;
    }

    public String toTTaems(float v) {
        StringBuffer sb = new StringBuffer("");
        if (this.getFrom() != null && !this.getFrom().isVirtual() && !(this.getFrom() instanceof Method)) {
            Log.getDefault().log("Warning: From node on IR " + this.getLabel() + " is not a Method", 1);
        }
        if (this.getTo() != null && !this.getTo().isVirtual() && !(this.getTo() instanceof Resource)) {
            Log.getDefault().log("Warning: To node on IR " + this.getLabel() + " is not a Resource", 1);
        }
        if (v == 1.0f) {
            sb.append("(spec_uses\n");
        } else {
            sb.append("(spec_consumes\n");
        }
        sb.append(super.toTTaems(v));
        if (this.getCost() != null) {
            sb.append("   (consumes " + this.getConsumes().output() + ")\n");
        }
        sb.append(")\n");
        return sb.toString();
    }
}

