/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/*****************************************************************
* Author : Regis Vincent [vincent@cs.umass.edu]
* Creation date: 25 Feb 99 15:41
* Sensor.java
*****************************************************************/
package simulator.sensor;

/* Global Includes */
import java.util.Hashtable;
import java.util.Enumeration;
import java.util.Vector;

/* Local Includes */
import simulator.*;
import utilities.TaemsRandom;
import utilities.Log;
import simulator.locale.*;
/**
 * Base class for the sensor script. This class is the parent
 * for all others sensors that we have defined.
 * <P>
 * The important function is sense that really calls the sensing
 */

public class Sensor {
    protected  Hashtable data;
    protected  String name;
    
  /**
   * Constructor.
   */
  public Sensor(String n, String d) {
    name = n;
    data = simulator.script.Script.parseDataLine(d);
  }

  /**
   * pulse. As usual in this framework, pulse is the function
   * call at each new time pulse. I can so whatever I want here.
   * <P>
   * Nothing is good.
   */
  public void pulse() { }

    
 /**
   * Init, usually you will retrieve input properties here, and setup
   * any state you need to.  
   * @see agent.simplest.State#reTypeProperty
   */  
  public void init() {
  }

  /**
   * make the real sensing
   * @param d - the String with the parameter to instantiate at
   * runtime.
   * @return Object  if it was sucessfull, null otherwise
   * @exception simulator.sensor.SensingErrorException An error occurred
   */
  public Object sense(Locale l, String d) throws SensingErrorException {
    return null;
  }

  /**
   * Returns the input data table
   */
  public Hashtable getData() { return data; }

  /**
   * Returns the name of this sensor
   */
  public String getName() { return name; }

  /**
   * Return a Sensor description like:  Name, Data1:Type1 , Data2:Type2
   * @return a useful description of this sensor.
   */
  public String exportSensor() {
    String answer = "Sensor, " + this.getClass().getName() + ", " + name;
    for (Enumeration e = data.keys(); e.hasMoreElements() ; ) {
      String key = (String)e.nextElement();
      answer = answer + ", " + key + ":" + (getData().get(key)).getClass().getName();
    }
    return(answer);
  }

  /**
   * Convert Hashtable in a big unique string used as keyword
   * for caching the values or anything else. 
   */
  protected String generateKey(Hashtable h) {
    Vector keysVector = new Vector();
    String key, answer = "";
    
    if (h != null) {
      for (Enumeration keys = h.keys(); keys.hasMoreElements() ; )
	keysVector.addElement((String)keys.nextElement());

      // sorting by lexicalorder
      for (int i = 0; i < keysVector.size()-1; i++) {
        int enumr = i;
        key = (String)keysVector.elementAt(enumr);
        for (int j = i; j < keysVector.size(); j++) {
          if (key.compareTo((String)keysVector.elementAt(j)) < 0) {
            enumr = j;
            key = (String)keysVector.elementAt(enumr);
          }
        }
        if (i != enumr) { // swap
          keysVector.setElementAt(keysVector.elementAt(i), enumr);
          keysVector.setElementAt(key, i);
        }
      }
      
      for (int i = 0; i < keysVector.size(); i++) {
	key = (String)keysVector.elementAt(i);
	answer = answer + "," + key + ":" + h.get(key);
      }
    }
    return(answer);
  }

    public Object getObjectSensed(simulator.locale.Locale loc) {
	return null;
    }

  /**
   * Return a Sensor description like:  Name, Data1:Type1:Value1 , 
   * Data2:Type2:Value2
   * @return a useful description of this sensor.
   */
  public String toString() {
    String answer = name;
    for (Enumeration e = data.keys(); e.hasMoreElements() ; ) {
      String key = (String)e.nextElement();
      answer = answer + ", " + key + ":" + (getData().get(key)).getClass().getName() +
	":" + getData().get(key) + " ";
    }
    return(answer);
  }
}
