/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/*****************************************************************
 * $Source: /nfs/shelob/cvs/masl/Mass/modules/simulator/simulator/sensor/LocalePathSensor.java,v $
 * $Revision: 1.2 $
 ******************************************************************
 *
 *                   LocalePathSensor.java
 *
 *     Author : Peter Amstutz [amstutz@cs.umass.edu]
 *              
 *
 * Creation date: 29 June 99 12:43
 * Last file update: $Date: 2005/01/19 19:00:22 $
 *****************************************************************/

package simulator.sensor;

import simulator.locale.*;

/** 
 * <B>Module</B>: simulator.sensor<p>
 * <B>Copyright</B>: UMASS - MASL 1999<P>
 * @version $Revision: 1.2 $
 * @author  Peter Amstutz (amstutz@cs.umass.edu)<P>
 * <B> Description:</B>
 *
 * Sensor type which agents can use to query their current locale path.
 */
public class LocalePathSensor extends Sensor {
	/**
	   Constructor.
	   @param <b>n</b> The sensor name
	   @param <b>d</b> The sensor data line (from sensors.cfg)
	 */
	public LocalePathSensor(String n, String d) {
		super(n, d);
	}

    public Object getObjectSensed(simulator.locale.Locale loc) {
		return loc;
	}

	/** 
		@param <b>l</b> The locale we're sensing from
		@param <b>d</b> A dataline (unused)
		@return A string with the locale's full path from its global locale.
	 */
	public Object sense(Locale l, String d) {
		String s=l.getName();
		while(l.getParent()!=null) {
			l = l.getParent();
			s = l.getName() + "/" + s;
		}
		return s;
	}
}
