/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/*****************************************************************
 * $Source: /nfs/shelob/cvs/masl/Mass/modules/simulator/simulator/sensor/LocalAgentSensor.java,v $
 * $Revision: 1.2 $
 ******************************************************************
 *
 *                   LocalAgentSensor.java
 *
 *     Author : Peter Amstutz [amstutz@cs.umass.edu]
 *              
 *
 * Creation date: 23 July 99 3:45pm
 * Last file update: $Date: 2005/01/19 19:00:22 $
 *****************************************************************/

package simulator.sensor;

import simulator.*;
import simulator.locale.*;
import java.util.Enumeration;
import java.util.Hashtable;

/** 
 * <B>Module</B>: simulator.sensor<p>
 * <B>Copyright</B>: UMASS - MASL 1999<P>
 * @version $Revision: 1.2 $
 * @author  Peter Amstutz (amstutz@cs.umass.edu)<P>
 * <B> Description:</B>
 *
 * Sensor type which agents can use to query what other agents
 * are in their current locale.
 */
public class LocalAgentSensor extends Sensor {
	/**
	   Constructor.
	   @param <b>n</b> The sensor name
	   @param <b>d</b> The sensor data line (from sensors.cfg)
	 */
	public LocalAgentSensor(String n, String d) {
		super(n, d);
	}

	public Object getObjectSensed(simulator.locale.Locale loc) {
		return loc;
	}

	/** 
		@param <b>l</b> The locale we're sensing from
		@param <b>d</b> A dataline (unused)
		@return A space-delimited list of locales
	 */
	public Object sense(Locale l, String d) {
		String s="";
		Enumeration e = simulator.Simulator.getSimulator().getAgentTable().elements();
		while(e.hasMoreElements()) {
			Agent a = (Agent)e.nextElement();
			if(a.getLocale()==l) 
				s = s + a.getName() + " ";
		}
		return s;
	}
}
