/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	Write.java
 ***************************************************************************************/

package simulator.script;

import utilities.Log;

/**
 * Just writes a line of data out using Log.
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>Line:String - The line of text to write out
 * <LI>Level:Integer - The level to log at (0-5, default 2, optional)
 * </UL>
 */
public class Write extends Reaction {
  int level = 2;

  /**
   * Constructor.
   */
  public Write(String d) {
    super(d);
  }
  
  /**
   * Init
   */
  public void init() {

    // Level
    if (getData().containsKey("Level"))
      level = Integer.parseInt((String)getData().get("Level"));

    super.init();
  }

  /**
   * Starts the reaction
   * @return True if it was sucessfull, false otherwise
   */
  public boolean realize() {
     Log.getDefault().log("(WriteReaction) " + getData().get("Line"), level);
     return true;
  }
}
