/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	Timer.java
 ***************************************************************************************/

package simulator.script;

import utilities.Clock;
import java.util.*;

/**
 * Returns true for a certain time interval, possibly repeating.
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>Start:Integer - The time to start returning true (default 0, optional)
 * <LI>Length:Integer - The length of time to continue returning true
 * <LI>Delay:Integer - The amount of time to pause after stopping before
 * going off again (default forever - it won't repeat, optional).
 * </UL>
 */
public class Timer extends Assertion {
  int start = 0;
  int len;
  int delay = Integer.MAX_VALUE;

  /**
   * Constructor.
   */
  public Timer(String d) {
    super(d);
  }
  
  /**
   * Init.
   */  
  public void init() {
    
    // Get it
    if (getData().containsKey("Start"))
      start = Integer.parseInt((String)getData().get("Start"));

    // Get it
    len = Integer.parseInt((String)getData().get("Length"));

    // Get it
    if (getData().containsKey("Delay"))
      delay = Integer.parseInt((String)getData().get("Delay"));

    super.init();
  }

  /**
   * Checks the assertion.
   */
  public boolean check() {
    int t = Clock.getTime();

    if (t < start) return false;

    t -= start;
    t %= (len + delay);

    if ((t >= 0) && (t < len))
      return true;

    return false;
  }
}
