/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	TimeChanged.java
 ***************************************************************************************/

package simulator.script;

import utilities.Clock;
import java.util.*;

/**
 * Returns true if the time is different from the last time it was
 * checked.  Put this at the end of your short-circuited assertion
 * list to ensure things only fire once in a time slot.  Also 
 * useful in conjunction with ScriptPulseType during the POSTEVENTS
 * script time.
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>None
 * </UL>
 */
public class TimeChanged extends Assertion {
  int last = -1;

  /**
   * Constructor.
   */
  public TimeChanged(String d) {
    super(d);
  }
  
  /**
   * Checks the assertion.
   */
  public boolean check() {
    int t = Clock.getTime();

    if (last == t)
      return false;

    last = t;

    return true;
  }
}
