/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	Time.java
 ***************************************************************************************/

package simulator.script;

import utilities.Clock;
import java.util.*;

/**
 * Simple assertion which tests the time.
 * Comparison test is "CurValue Op Value" (e.g. CurTime < GivenTime).
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>Op:String - Comparison operator (e.g. "==", ">", "<", ">=", "<=", "!=")
 * (optional, default ==)
 * <LI>Value:Integer - The target time to compare the current time with.
 * </UL>
 */
public class Time extends Assertion {
  String op = "==";
  int time;

  /**
   * Constructor.
   */
  public Time(String d) {
    super(d);
  }
  
  /**
   * Init.
   */  
  public void init() {
    
    // Get the operator
    if (getData().containsKey("Op"))
      op = (String)getData().get("Op");

    // Get the time
    time = Integer.parseInt((String)getData().get("Value"));

    super.init();
  }

  /**
   * Checks the assertion.
   */
  public boolean check() {
    int t = Clock.getTime();

    if (op.equals("==")) {
      return (t == time);

    } if (op.equals(">")) {
      return (t > time);

    } if (op.equals("<")) {
      return (t < time);

    } if (op.equals(">=")) {
      return (t >= time);

    } if (op.equals("<=")) {
      return (t <= time);

    } if (op.equals("!=")) {
      return (t != time);
    }

    return false;
  }
}
