/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	StepSim.java
 ***************************************************************************************/

package simulator.script;

import simulator.*;

/**
 * Steps the simulator
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>Steps:Integer - The number of steps to step (optional, default 1)
 * </UL>
 */
public class StepSim extends Reaction {
  int steps = 1;

  /**
   * Constructor.
   */
  public StepSim(String d) {
    super(d);
  }
    
  /**
   * Init
   */
  public void init() {

    // Steps
    if (getData().containsKey("Steps"))
      steps = Integer.parseInt((String)getData().get("Steps"));

    super.init();
  }

  /**
   * Starts the reaction
   * @return True if it was sucessfull, false otherwise
   */
  public boolean realize() {
     Simulator.getSimulator().step(steps);
     return true;
  }
}
