/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	StartScript.java
 ***************************************************************************************/

package simulator.script;

import simulator.*;
import java.util.*;

/**
 * Starts a script if it is found.
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>Script:String - The name of the script to start
 * </UL>
 */
public class StartScript extends Reaction {
  Script script;
  int last = 0;

  /**
   * Constructor.
   */
  public StartScript(String d) {
    super(d);
  }
  
  /**
   * Init.
   */  
  public void init() {
    
    findScript();

    super.init();
  }

  /**
   * Finds the script object
   */
  public Script findScript() {

    String s = (String)getData().get("Script");

    Enumeration e = Simulator.getSimulator().getScripter().getScripts();
    while (e.hasMoreElements()) {
      Script scr = (Script)e.nextElement();
      if (scr.getName().equalsIgnoreCase(s))
	return scr;
    }

    return null;
  }

  /**
   * Realize
   */
  public boolean realize() {

    if (script == null)
      findScript();
    if (script == null)
      return false;

    script.start();

    return true;
  }
}
