/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	SetResourceMin.java
 ***************************************************************************************/

package simulator.script;

import simulator.*;
import java.util.*;

/**
 * Sets the minimum level of a resource to a fixed value, using a 
 * ResourceEvent.
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>Resource:String - The name of the resource to check
 * <LI>Dur:Integer - The desired duration of the event forcing the
 * maximum to a specific value (optional, default 0)
 * <LI>Level:Float - The target level to use
 * </UL>
 */
public class SetResourceMin extends SetResourceLevel {

  /**
   * Constructor.
   */
  public SetResourceMin(String d) {
    super(d);
  }
  
  /**
   * Creates the event we'll be using
   */
  public ResourceEvent createEvent() {

    return new ResourceEvent(0, dur, rsrc, ResourceEvent.NO_CHANGE, level, ResourceEvent.NO_CHANGE, true);
  }
}
