/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	SetResourceMax.java
 ***************************************************************************************/

package simulator.script;

import simulator.*;
import java.util.*;

/**
 * Sets the maximum level of a resource to a fixed value, using a 
 * ResourceEvent.
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>Resource:String - The name of the resource to check
 * <LI>Dur:Integer - The desired duration of the event forcing the
 * maximum to a specific value (optional, default 0)
 * <LI>Level:Float - The target level to use
 * </UL>
 */
public class SetResourceMax extends SetResourceLevel {

  /**
   * Constructor.
   */
  public SetResourceMax(String d) {
    super(d);
  }
  
  /**
   * Creates the event we'll be using
   */
  public ResourceEvent createEvent() {

    return new ResourceEvent(0, dur, rsrc, ResourceEvent.NO_CHANGE, ResourceEvent.NO_CHANGE, level, true);
  }
}
