/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	SetResourceLevelWithOther.java
 ***************************************************************************************/

package simulator.script;

import simulator.*;
import java.util.*;

/**
 * Sets the current level of a resource to the level of some other 
 * resource, using a ResourceEvent.
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>Resource:String - The name of the resource to check
 * <LI>Dur:Integer - The desired duration of the event forcing the
 * level to a specific value (optional, default 0)
 * <LI>Level:String - The resource to set the current level to.
 * </UL>
 */
public class SetResourceLevelWithOther extends Reaction {
  String op;
  Resources level;
  int dur = 0;
  Resources rsrc;
  Vector events = new Vector();

  /**
   * Constructor.
   */
  public SetResourceLevelWithOther(String d) {
    super(d);
  }
  
  /**
   * Init.
   */  
  public void init() {
    
    // Duration
    if (getData().containsKey("Dur"))
      dur = Integer.parseInt((String)getData().get("Dur"));

    // Get the resource
    rsrc = findResource("Resource");
    level = findResource("Level");

    super.init();
  }

  /**
   * Finds the resource object
   */
  public Resources findResource(String rsc) {

    String rsrc = (String)getData().get(rsc);

    Enumeration e = Simulator.getSimulator().resources.elements();
    while (e.hasMoreElements()) {
      Resources r = (Resources)e.nextElement();
      if (r.getName().equalsIgnoreCase(rsrc))
	return r;
    }

    return null;
  }

  
  /**
   * Creates the event we'll be using
   */
  public ResourceEvent createEvent() {

    return new ResourceEvent(0, dur, rsrc, level.getCurrentValue(), ResourceEvent.NO_CHANGE, ResourceEvent.NO_CHANGE, true);
  }

  /**
   * Performs the action
   */
  public boolean realize() {

    if (rsrc == null)
      findResource("Resource");
    if (rsrc == null)
      return false;
    if (level == null)
      findResource("Level");
    if (level == null)
      return false;

    ResourceEvent e = createEvent();
    EventQueue.getQueue().addEvent(e);
    events.addElement(e);

    return true;
  }
}
