/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	SetPreprocessKey.java
 ***************************************************************************************/

package simulator.script;

import java.util.*;

/**
 * Sends a regenerate taems event to an agent.  This is essentially
 * a specialization of the SendMessage reaction.
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>Agent:String - The name of the recipient
 * <LI>Key:String - The name of the key to set
 * <LI>Value:String - The name of the value to set (if the
 * value is set to the literal string "null", the key will
 * be removed).
 * </UL>
 */
public class SetPreprocessKey extends SendMessage {

  /**
   * Constructor.
   */
  public SetPreprocessKey(String d) {
    super(d);
  }
  
  /**
   * Init.
   */  
  public void init() {
    super.init();

    // Agent
    agent = (String)getData().get("Agent");

    // Source
    String source = "simulator";

    // Perf
    perf = "tell";

    // Content word
    CW =  new String("PreprocessKey");

    // CD - View
    String k = (String)getData().get("Key");
    String v = (String)getData().get("Value");
    CD = k + " " + v;

    // Control
    control = true;

    // Other junk
    other = null;
  }
}
