/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	SendCommitment.java 
 ***************************************************************************************/

package simulator.script;

import utilities.*;
import simulator.*;
import java.util.*;
import taems.*;

/**
 * Sends a Taems Commitment to an agent, embedded in a KQML message.
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>ToAgent:String - The name of the recipient. Broadcast is represented as the wild card *
 * <LI>FromAgent:String - The name of the source (optional, default "simulator")
 * <LI> Label:String - Label of the commitment
 * <LI> Importance:Integer - 
 * <LI> MinQuality:Float - Minimum Quality expected for this commitment
 * <LI> EarliestStartTime:Integer - 
 * <LI> Deadline:Integer -
 * <LI> TimeSatisfied:Integer -
 * <LI> Task:String - The task you want be done
 * <LI> Type:String - The type of commitment
 * <LI>all the Commitment parameters : 
 * commitment.  Make sure you don't use the "," as a separator, use the DELIM feature  as described in reTypeProperty.
 * </UL>
 * <UL>
 * Script, AndScript, Send Commit,  Fire: *<BR>
 * Assertion, Time, Value:5, Op:< <BR>
 * Assertion, TimeChanged<BR>
 * Reaction, SendCommitment, Label:tets, Importance:30, MinQuality:60, EarliestStartTime:10, Deadline:20, TimeSatisfied:450, ToAgent:*<BR>
 * </UL>
 */
public class SendCommitment extends Reaction {
//  String agent;
//  String source = "simulator";
  String perf = "tell";
  String CW = "Commitment";
  String CD = "";
  boolean control = false;
  Hashtable other = null;

  String label;
  String from_agent = "simulator";
  String to_agent;
  String tasks;
  String type;
  int importance;
  float min_quality;
  int earliest_start_time;
  int deadline;
  int time_satisfied;
  Hashtable attributes;

  /**
   * Constructor.
   */
  public SendCommitment(String d) {
    super(d);
  }
  
  /**
   * Init.
   */  
  public void init() {
    // label
    if (getData().containsKey("Label"))
      label = (String)getData().get("Label");
    // from_agent
    if (getData().containsKey("FromAgent"))
      from_agent = (String)getData().get("FromAgent");
    // to_agent
    if (getData().containsKey("ToAgent"))
      to_agent = (String)getData().get("ToAgent");
    // CAN ONLY TAKE ONE TASK AS A PARAMETER
    // MODIFY TO TAKE LIST
    // tasks
    if (getData().containsKey("Task"))
      tasks = (String)getData().get("Task");
    // type
    if (getData().containsKey("Type"))
      type = (String)getData().get("Type");
    // importance
    if (getData().containsKey("Importance"))
      importance = Integer.parseInt((String)getData().get("Importance"));
    // min_quality
    if (getData().containsKey("MinQuality"))
      min_quality = (new Float((String)getData().get("MinQuality"))).floatValue();
    // earliest_start_time
    if (getData().containsKey("EarliestStartTime"))
      earliest_start_time = Integer.parseInt((String)getData().get("EarliestStartTime"));
    // deadline
    if (getData().containsKey("Deadline"))
      deadline = Integer.parseInt((String)getData().get("Deadline"));
    // time_satisfied
    if (getData().containsKey("TimeSatisfied"))
      time_satisfied = Integer.parseInt((String)getData().get("TimeSatisfied"));
    // attributes
    //    if (getData().containsKey("Attributes"))
    //	attributes = (Hashtable)Converter.reTypeProperty((String)getData().get("Attributes"), "Hashtable");
    super.init();
  }

  /**
   * Gets a ref to the agent
   * @param n Name of the agent to look for
   * @return The Agent, or null if not found
   */
  public simulator.Agent findAgent(String n) {

    synchronized (Simulator.getAgentTable()) {
      return Simulator.getSimulator().findAgent(n);
    }
  }

  /**
   * Performs the action
   */
  public boolean realize() {
      boolean broadcast = false;
      simulator.Agent a = null ,s = null;

      if (!to_agent.equals("*")) {
	  a = findAgent(to_agent);
	  if (a == null) return false;
      }
      else 
	  broadcast = true;
      
    if (!from_agent.equalsIgnoreCase("simulator")) {
      s = findAgent(from_agent);
      if (s == null) return false;
    }

    // Create a Commitment, converts it to TTAems and sends it via KQML

    Commitment c = new Commitment();
    Task task = new Task();
    Vector taskVector = new Vector();

    task.setLabel(tasks);
    taskVector.addElement(task);

    c.setLabel(label);
    c.setFromAgent(new taems.Agent(from_agent));
    c.setToAgent(new taems.Agent(to_agent));
    c.setTaskVector(taskVector);
    c.setType(type);
    c.setImportance(importance);
    c.setMinimumQuality(min_quality);
    c.setEarliestStartTime(earliest_start_time);
    c.setDeadline(deadline);
    c.setTimeSatisfied(time_satisfied);
    c.setID(TaemsRandom.getDefault().getUniqID());
    if (attributes != null) {
      Enumeration e = attributes.keys();
      while (e.hasMoreElements()) {
	String key = (String)e.nextElement();
	c.setAttribute(key, (String)attributes.get(key));
      }
    }

    CD = c.toTTaems(Taems.VCUR);

    KQMLMessage msg = new KQMLMessage(perf, "(" + CW + " " + CD + ")", to_agent);
    if (s != null)
      msg.setSourceAddr(s.getName());
    
    if (broadcast) {
	synchronized (Simulator.getAgentTable()) {
	    for (Enumeration e = Simulator.getSimulator().getAgentTable().keys() ; e.hasMoreElements(); ) {
		simulator.Agent agent = (simulator.Agent)Simulator.getSimulator().getAgentTable().get(e.nextElement());
		agent.sendMsg(msg);
	    }
	}
    }
    else
	a.sendMsg(msg);

    return true;
  }
}







