/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	ScriptStarted.java
 ***************************************************************************************/

package simulator.script;

import simulator.*;
import java.util.*;

/**
 * Tests weather a given script started.  Note this will only fire once
 * for each time the script starts - it does not check weather the script
 * is active.
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>Script:String - The name of the script to check
 * </UL>
 */
public class ScriptStarted extends Assertion {
  Script script;
  int last = 0;

  /**
   * Constructor.
   */
  public ScriptStarted(String d) {
    super(d);
  }
  
  /**
   * Init.
   */  
  public void init() {
    
    findScript();

    super.init();
  }

  /**
   * Finds the script object
   */
  public Script findScript() {

    String s = (String)getData().get("Script");

    Enumeration e = Simulator.getSimulator().getScripter().getScripts();
    while (e.hasMoreElements()) {
      Script scr = (Script)e.nextElement();
      if (scr.getName().equalsIgnoreCase(s))
	return scr;
    }

    return null;
  }

  /**
   * Checks the assertion.
   */
  public boolean check() {

    if (script == null)
      findScript();
    if (script == null)
      return false;

    if (last != script.getActivations()) {
      last = script.getActivations();
      return true;
    }

    return false;
  }
}
