/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	ResourceLevelCompare.java
 ***************************************************************************************/

package simulator.script;

import simulator.*;
import java.util.*;

/**
 * Compares the current level of two resources in the simulation environment.
 * Comparison test is "CurLevel1 Op CurLevel2" (e.g. Bedroom_Temp < Bathroom_Temp).
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>Resource1:String - The name of the first resource to check
 * <LI>Op:String - Comparison operator (e.g. "==", ">", "<", ">=", "<=", "!=")
 * <LI>Resource2:String - The name of the second resource to check
 * </UL>
 */
public class ResourceLevelCompare extends Assertion {
  String op;
  Resources rsrc1;
  Resources rsrc2;

  /**
   * Constructor.
   */
  public ResourceLevelCompare(String d) {
    super(d);
  }
  
  /**
   * Init.
   */  
  public void init() {
    
    // Get the operator
    op = (String)getData().get("Op");

    // Get the resources
    rsrc1 = findResource("Resource1");
    rsrc2 = findResource("Resource2");

    super.init();
  }

  /**
   * Finds the resource object
   */
  public Resources findResource(String rsc) {

    String rsrc = (String)getData().get(rsc);

    Enumeration e = Simulator.getSimulator().resources.elements();
    while (e.hasMoreElements()) {
      Resources r = (Resources)e.nextElement();
      if (r.getName().equalsIgnoreCase(rsrc))
	return r;
    }

    return null;
  }

  /**
   * Checks the assertion.
   */
  public boolean check() {

    if (rsrc1 == null)
      findResource("Resource1");
    if (rsrc1 == null)
      return false;

    if (rsrc2 == null)
      findResource("Resource2");
    if (rsrc2 == null)
      return false;

    float rlevel1 = rsrc1.getCurrentValue();
    float rlevel2 = rsrc2.getCurrentValue();

    if (op.equals("==")) {
      return (rlevel1 == rlevel2);

    } if (op.equals(">")) {
      return (rlevel1 > rlevel2);

    } if (op.equals("<")) {
      return (rlevel1 < rlevel2);

    } if (op.equals(">=")) {
      return (rlevel1 >= rlevel2);

    } if (op.equals("<=")) {
      return (rlevel1 <= rlevel2);

    } if (op.equals("!=")) {
      return (rlevel1 != rlevel2);
    }

    return false;
  }
}
