/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	ResetScript.java
 ***************************************************************************************/

package simulator.script;

import simulator.*;
import java.util.*;

/**
 * Resets a given script.
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>Script:String - The name of the script to reset
 * </UL>
 */
public class ResetScript extends Reaction {
  Script script;

  /**
   * Constructor.
   */
  public ResetScript(String d) {
    super(d);
  }
  
  /**
   * Init.
   */  
  public void init() {
    
    findScript();

    super.init();
  }

  /**
   * Finds the script object
   */
  public Script findScript() {

    String s = (String)getData().get("Script");

    Enumeration e = Simulator.getSimulator().getScripter().getScripts();
    while (e.hasMoreElements()) {
      Script scr = (Script)e.nextElement();
      if (scr.getName().equalsIgnoreCase(s))
	return scr;
    }

    return null;
  }

  /**
   * Realize
   */
  public boolean realize() {

    if (script == null)
      script = findScript();
    if (script == null) {
      return false;
    }

    script.reset();

    return true;
  }
}
