/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	RegenerateTaems.java
 ***************************************************************************************/

package simulator.script;

import java.util.*;

/**
 * Sends a regenerate taems event to an agent.  This is essentially
 * a specialization of the SendMessage reaction.
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>Agent:String - The name of the recipient
 * <LI>View:String - The name of the view to generate (default "All")
 * (one of All, Objective, Subjective, Conditional).
 * </UL>
 */
public class RegenerateTaems extends SendMessage {

  /**
   * Constructor.
   */
  public RegenerateTaems(String d) {
    super(d);
  }
  
  /**
   * Init.
   */  
  public void init() {
    super.init();

    // Agent
    agent = (String)getData().get("Agent");

    // Source
    String source = "simulator";

    // Perf
    perf = "tell";

    // Content word
    CW =  new String("GenerateTaskStructure");

    // CD - View
    CD = "All";
    if (getData().containsKey("View"))
      CD = (String)getData().get("View");

    // Control
    control = false;

    // Other junk
    other = null;
  }
}
